/***************************************************************************
                          dlgmapoptionsspeedwalk.cpp
                      -------------------
    description          :
    begin                : Thu Mar 1 2001
    copyright            : (C) 2001 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "dlgmapoptionsspeedwalk.h"

DlgMapOptionsSpeedwalk::DlgMapOptionsSpeedwalk(QWidget *parent, const char *name) : QDialog(parent,name,true)
{
	initDialog();
	connect (chkSpeedWalkLimit,SIGNAL(clicked()),SLOT(slotDoLimitSpeedWalkClicked()));
}

DlgMapOptionsSpeedwalk::~DlgMapOptionsSpeedwalk()
{
}

void DlgMapOptionsSpeedwalk::setDoLimitSpeedWalk(bool set)
{
	chkSpeedWalkLimit->setChecked(set);
	txtAbortNum->setEnabled(set);
	lblNumMoves->setEnabled(set);
}

void DlgMapOptionsSpeedwalk::setSpeedWalkLimit(int numMoves)
{
	QString str;
	str.sprintf("%d",numMoves);
	txtAbortNum->setText(str);
}

int DlgMapOptionsSpeedwalk::getSpeedWalkLimit(void)
{
	bool OK;
	QString str(txtAbortNum->text());
	return str.toInt(&OK);
}

int DlgMapOptionsSpeedwalk::getSpeedwalkDelay(void)
{
	bool OK;
	QString str(txtDelay->text());
	return str.toInt(&OK);
}

void DlgMapOptionsSpeedwalk::setSpeedwalkDelay(int delay)
{
	QString str;
	str.sprintf("%d",delay);
	txtDelay->setText(str);
}


bool DlgMapOptionsSpeedwalk::getDoLimitSpeedWalk(void)
{ return chkSpeedWalkLimit->isChecked(); }

void DlgMapOptionsSpeedwalk::slotDoLimitSpeedWalkClicked(void)
{
	setDoLimitSpeedWalk(chkSpeedWalkLimit->isChecked());
}

