/***************************************************************************
                          cmappath.h
                      -------------------
    description          : The path map element
    begin                : Wed Oct 20 1999
    copyright            : (C) 1999 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CMAPPATH_H
#define CMAPPATH_H

#include <qpainter.h>
#include <qlist.h>

#include "cmapelement.h"
#include "cmaproom.h"

class CMapRoom;

/**This class is used to store the details of each path on
  *the map (The exits from one room to another)
  *@author John-Paul Stanford
  */
class CMapPath : public CMapElement
{
public:

	/** This is the constuctor for the map paths and
	  * used to create a path
	  */
	CMapPath (direction SrcDir,direction DestDir,CMapRoom *DestRoom,CMapRoom *SrcRoom);
	
    /** Check to see if the mouse is in a path edit move box */
	signed int elementInEditBox(int x,int y,CMapZone *currentZone);
	
	bool elementIn(int x1,int y1,int x2,int y2,CMapZone *currentZone);	
	/** Returns true if the path is two way other wise returns false */ 	
	//bool isTwoWay(void);
	void setEditMode(bool edit);

	/** Get the directions of the start and finish directions of the path */
	direction getSrcDir(void)                    { return srcDir; }
	direction getDestDir(void)                   { return destDir; }
	
	void setOpsitePath(CMapPath *path)           { opsitePath = path; }
	CMapPath *getOpsitePath(void)                { return opsitePath; }

	/** Get a pointer to the destination room */
	CMapRoom *getDestRoom(void)                  { return destRoom; }
	CMapRoom *getSrcRoom(void)                   { return srcRoom; }

	/** Set the start and finish directrions of the path */
	void setSrcDir(direction SrcDir)             { srcDir = SrcDir; }
	void setDestDir(direction DestDir)           { destDir = DestDir; }

	/** Set a pointer to the destination room */
	void setDestRoom(CMapRoom *DestRoom)         { destRoom = DestRoom; }	
	void setSrcRoom(CMapRoom *SrcRoom)           { srcRoom = SrcRoom; }
	
	/** Set the special exit command string */
	void setSpecialCmd(QString cmd)              { specialCmd = cmd; }
	/** Return the special exit command string */
	QString getSpecialCmd(void)                  { return specialCmd; }
	
	/** Tell the mapp if this path is a special exit */
	void setSpecialExit(bool special)            { bSpecialExit = special; }
	/** Return if this path is a special exit */
	bool getSpecialExit(void)                    { return bSpecialExit; }
	
	/** Used to move the path by an offset */
	void moveBy(int x,int y);
	
	bool mouseInElement(int x,int y,CMapZone *currentZone);
	bool mouseInResize(int x,int y,CMapZone *currentZone);	
	
	bool getDone(void)                           { return done; }
	void setDone(bool set)                       { done = set; }	

	/** Find out with segment the mouse pointer is in.
	  * retrun -1 if not in any path segment.          */
	signed int mouseInPathSeg(int x,int y,CMapZone *currentZone);
		
	/** Paint mentods used to dispaly the paths in it's various states */
	virtual void paint(QPainter *p,CMapZone *currentZone);
	virtual void dragPaint(QPainter *p,int offsetx,int offsety,CMapZone *currentZone);
	virtual void lowerPaint(QPainter *p,CMapZone *currentZone);
	virtual void higherPaint(QPainter *p,CMapZone *currentZone);
	virtual void dragEditPaint(QPainter *p,int offsetx,int offsety,signed int pointNum,CMapZone *currentZone);
	
	virtual elementTyp getElementType(void)      { return PATH; }
	virtual CMapElement *copy(void);
	
	/** Just to add a new bend to the math */
	void addBend(int x,int y);	
	/** Delete a bend from the path */
	void delBend(int bendNum);
	/** Moves the bend */
	void moveBend(int bendNum, int x, int y);	
	/** Get a list of bends in the path */
	QList<QPoint> *getBends(void)                 { return &bendList; }

	/** This method is used to calcualte the distance from a path segmeant */
	int distance (int x,int y,int x1,int x2,int y1,int y2);

	virtual void read(KCMapFile* kcmfile);
	virtual void write(KCMapFile* kcmfile);
			
private:	
	QRect getPathRect(CMapZone *currentZone);
	bool done;
	CMapPath *opsitePath;
	/** These are used to store the directions the path enters and leaves a room */
	direction srcDir,destDir;	

	/** Used to store a pointer to the desination room */
	CMapRoom *destRoom,*srcRoom;
	
	bool bSpecialExit;
	QString specialCmd;
	QList<QPoint> bendList;
	QPoint *pointEditing;
	
	int getSmallest(int num1,int num2);
	int getLargest(int num1,int num2);
	
};

#endif
