/***************************************************************************
                          kaspaerr.cpp  -  description                              
                             -------------------                                         
    begin                : Mon Sep 4 2000                                           
    copyright            : (C) 2000 by Jan Mueller                         
    email                : janmueller7@hotmail.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "kaspaerr.h"
#include <str.h>
#include <stdio.h>

////////////////////////////////////////
///// KaspaErr

  KaspaErr::KaspaErr(const char *s=0) {
		if(s) err=mystrdup(s);
	}

  KaspaErr::KaspaErr(const KaspaErr& e) {
		if(e.error()) err=mystrdup(e.error());
	}

  KaspaErr::~KaspaErr() {
		delete err;
	}

	KaspaErr& KaspaErr::operator=(KaspaErr& e) {
		if(!(&e==this)) {
			if(e.error()) err=mystrdup(e.error());
			else err=0L;
		}
		return *this;
	}

  void KaspaErr::print() const {
		printf("Error: %s\n", err);
	}

  char *KaspaErr::error() const {
		return err;
	}
