/***************************************************************************
                          resource.h  -  description
                             -------------------
    begin                : Die Aug 17 03:44:15 CEST 1999

    copyright            : (C) 1999 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef RESOURCE_H
#define RESOURCE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qevent.h>
///////////////////////////////////////////////////////////////////
// resource.h  -- contains macros used for commands


///////////////////////////////////////////////////////////////////
// COMMAND VALUES FOR MENUBAR AND TOOLBAR ENTRIES


///////////////////////////////////////////////////////////////////
// File-menu entries
#define ID_FILE_NEW_WINDOW          10010
#define ID_FILE_NEW                 10020
#define ID_FILE_OPEN                10030
#define ID_FILE_OPEN_RECENT         10040
#define ID_FILE_CLOSE               10050
#define ID_FILE_SAVE                10060
#define ID_FILE_SAVE_AS             10070
#define ID_FILE_PRINT               10080
#define ID_FILE_QUIT                10090
#define ID_FILE_BIBTEX              10100
#define ID_FILE_EXPORT              10110

///////////////////////////////////////////////////////////////////
// Edit-menu entries
#define ID_EDIT_COPY                11010
#define ID_EDIT_CUT                 11020
#define ID_EDIT_PASTE               11030

///////////////////////////////////////////////////////////////////
// View-menu entries
#define ID_VIEW_TOOLBAR             12010
#define ID_VIEW_STATUSBAR           12020

#define ID_OPT_WALLPAPER            12022
#define ID_OPT_SEARCH								12024
///////////////////////////////////////////////////////////////////
// Help-menu entries
#define ID_HELP_CONTENTS            1002

///////////////////////////////////////////////////////////////////
// General application values
#define ID_STATUS_MSG               1001
#define ID_URLLINE									1003

enum {
 ID_AUTHOR_DELREC=13001,
 ID_AUTHOR_FLUSH,
 ID_AUTHOR_RESET,
 ID_AUTHOR_IMPIMG,
 ID_AUTHOR_EXPIMG,
 ID_AUTHOR_DELIMG,
 ID_AUTHOR_NEWPUBL,
 ID_AUTHOR_INSPUBL,
 ID_AUTHOR_REMPUBL,
 ID_AUTHOR_NEWPART,
 ID_AUTHOR_REMPART,
 ID_AUTHOR_INSPART,
 ID_AUTHOR_NEWLINK,
 ID_AUTHOR_INSLINK,
 ID_AUTHOR_REMLINK,

 ID_BIBLIO_SHOWPUBL,
 ID_BIBLIO_DELREC,
 ID_BIBLIO_FLUSH,
 ID_BIBLIO_RESET,
 ID_BIBLIO_INSORGPUBLISHER,
 ID_BIBLIO_SHOWORGPUBLISHER,
 ID_BIBLIO_NEWORGPUBLISHER,

 ID_PART_DELREC,
 ID_PART_FLUSH,
 ID_PART_RESET,
 ID_PART_SHOWPUBL,
 ID_PART_SHOWMEMO,
 ID_PART_SHOWINTRO,
 ID_PART_NEWAUTHOR,
 ID_PART_REMAUTHOR,
 ID_PART_INSAUTHOR,
 ID_PART_NEWLINK,
 ID_PART_INSLINK,
 ID_PART_EDITDATA,
 ID_PART_REMLINK,

 ID_PUBL_SHOWBIBLIO,
 ID_PUBL_SHOWLINKS,
 ID_PUBL_NEWAUTHOR,
 ID_PUBL_INSAUTHOR,
 ID_PUBL_REMAUTHOR,
 ID_PUBL_DELREC,
 ID_PUBL_FLUSH,
 ID_PUBL_RESET,
 ID_PUBL_NEWPUBL,
 ID_PUBL_INSPUBL,
 ID_PUBL_REMPUBL,
 ID_PUBL_NEWPART,
 ID_PUBL_REMPART,
 ID_PUBL_NEWLINK,
 ID_PUBL_INSLINK,
 ID_PUBL_REMLINK,
 ID_PUBL_INSPUBLISHER,
 ID_PUBL_SHOWPUBLISHER,
 ID_PUBL_NEWPUBLISHER,

 ID_HTML_RESET,
 ID_HTML_NEWLINK,
 ID_HTML_INSLINK,
 ID_HTML_REMLINK,
 ID_HTML_SHOWPART,

 ID_NOTE_INSAUTHOR,
 ID_NOTE_INSPUBL,
 ID_NOTE_INSPART,
 ID_NOTE_INSNOTE,
 ID_NOTE_REMLINK,
 ID_NOTE_DELREC,
 ID_NOTE_FLUSH,
 ID_NOTE_RESET,

 ID_PUBLISHER_DELREC,
 ID_PUBLISHER_FLUSH,
 ID_PUBLISHER_RESET,

 ID_PARTMEMO_SHOWPUBL,
 ID_PARTMEMO_SHOWPART,
 ID_PARTMEMO_DELREC,
 ID_PARTMEMO_FLUSH,
 ID_PARTMEMO_RESET,

 ID_SELECTION_RESET,

 ID_NEW_PUBLISHER,
 ID_NEW_AUTHOR,
 ID_NEW_NOTE,
 ID_NEW_PUBL,
 ID_OVERV_NOTE,
 ID_OVERV_AUTHOR,
 ID_OVERV_PUBL,
 ID_SEARCH_START,
 ID_SEARCH_INDEX,

 ID_BACK,
 ID_FORWARD,
};


#define RO 1
#define RW 2
#define INV 4
#define WORK 8

struct CommandSetup {
	int command;
	int setup;
};

#define Event_Author (Event_User+1)
#define Event_Note (Event_User+2)
#define Event_AuthorOverview (Event_User+3)
#define Event_NoteOverview (Event_User+4)
#define Event_Publ (Event_User+5)
#define Event_Biblio (Event_User+6)
#define Event_Part (Event_User+7)
#define Event_Publisher (Event_User+8)
#define Event_PartMemo (Event_User+9)
#define Event_HTMLData (Event_User+10)
#define Event_PublOverview (Event_User+11)
#define Event_Invalid (Event_User+30)

#define BT_BOOK           0   // ->INBOOK
#define BT_BOOKLET        1
#define BT_JOURNAL        2		// ->ARTICLE
#define BT_MANUAL         3
#define BT_MASTERTHESIS   4
#define BT_MISC           5
#define BT_PROCEEDING     6		// ->INPROCEEDING
#define BT_TECHREPORT     7
#define BT_UNPUBLISHED    8
#define BT_PHDTHESIS			9

#define BT_INBOOK				 10
#define BT_INCOLLECTION	 11
#define BT_INPROCEEDING	 12
#define BT_ARTICLE			 13

#define DB_NAME "dbname=kaspaliste"

bool idle(void);
extern bool cancelRequested;

#endif // RESOURCE_H

