/***************************************************************************
                          table.cpp  -  description
                             -------------------
    begin                : Sat Sep 4 1999
    copyright            : (C) 1999 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <assert.h>
#include "table.h"

#define Inherited KaspaBase

// Creates new Note
Table::Table(const char *tbl, const char *dbname):
	Inherited(dbname), rec(0), callBack(0L)
{
  table=mystrdup(tbl);
  idletimeout.tv_sec = 0;
  idletimeout.tv_usec = 50;

}

Table::Table(const char *tbl, Sql *conn):
	Inherited(conn), rec(0), callBack(0L)
{
  table=mystrdup(tbl);
  idletimeout.tv_sec = 0;
  idletimeout.tv_usec = 50;

}

void Table::init(KaspaRec *r) {
  assert(r);
  if(r->next)
    throw TblMoreThanOneRec("Table::Table(char *): Internal Error!");

  rec=r;
  if(isValid() && lockObj(id()))
    readonly=false;
  else
    readonly=true;
}	


Table::~Table() {
	try {
	if(isWorking()) abort(); // throw KaspaErr("Table::~Table(): Still Working!!!");
			
  if(!isReadOnly())
    unlockObj(id());
	delete rec; rec=0L;

	} catch(...) {
  delete rec;
	throw;
	}
}

void Table::reset() {
	try {
	  Oid oldid=id();
		if(!isReadOnly())
	    unlockObj(oldid);
  	delete rec;
		rec=0L;
  	Str s("where oid=");
	  oid2str(oldid, &s);
  	rec=read(s);
	  if(!rec) rec=invalid();

	  if(rec->next)
  	  throw TblMoreThanOneRec("Table::reset(): Internal Error!");

	  // new tuple returned? Unlock old one and test if new one can be locked.
		if(isValid()&&lockObj(rec->id.get()))
			readonly=false;
		else
			readonly=true;
	} catch (...) {
			delete rec; rec=0L;
			rec=invalid();
			readonly=false;
			throw;
	}
}

void Table::flush(bool block) {
	try {
	  if(!isValid())
  	  throw TblIsInvalid("Table::deleteRec(): Attemp to save an invalid tuple!");
	  if(isReadOnly())
  	  throw TblIsReadOnly("Table::deleteRec(): Attemp to save a read-only tuple!");
	  Str s("where oid=");
  	oid2str(id(), &s);
	  write(s);
	} catch (...) {
			delete rec; rec=0L;
			rec=invalid();
			throw;
	}
}

bool Table::isValid() {
  return (rec->id.get()!=InvalidOid);
}

bool Table::isReadOnly() {
  return readonly;
}

void Table::deleteRec() {
	try {
	  if(!isValid())
  	  throw TblIsInvalid("Table::deleteRec(): Attemp to delete an invalid tuple!");
	  if(isReadOnly())
  	  throw TblIsReadOnly("Table::deleteRec(): Attemp to delete an read-only tuple!");
		unlockObj(id());
	  del(id());
	} catch (BaseDeleteLock) { throw; }
	  catch (...) {
			delete rec;
			rec=0L;
			rec=invalid();
			throw;
	}
}

Title *Table::getLinks() {
  return Inherited::getLinks(id());
}


void Table::insertLink(Oid note) {
  if(isValid())
    Inherited::newLink(note, id(), table);
}

void Table::removeLink(Oid o) {
	Str s="where (obj1=";
	oid2str(o, &s);
	s+=" and obj2=";
	oid2str(id(), &s);
	s+=") or (obj1=";
	oid2str(id(), &s);
	s+=" and obj2=";
	oid2str(o, &s);
	s+=")";
	
	deleteLink(s);
}

AuthorName *Table::getAuthors() {
	return getAuthorNames("order by lastname");
}

PublTitle *Table::getPubls() {
	return getPublTitles("order by title");
}
	
NoteTitle *Table::getNotes() {
	return getNoteTitles("order by title");
}
	
PartTitle *Table::getParts() {
	return getPartTitles("order by title");
}

PublisherName *Table::getPublishers() {
	/* "where serie = ''" doesn't work!?!?! */
	return getPublisherNames("except select oid, name, city, serie from publisher where serie != '' order by name");
}

PublisherName *Table::getJournals() {
	return getPublisherNames("where serie!='' order by serie");
}

bool Table::idle() {
	if(callBack)
		return callBack();
	else {
		select (0L, 0L, 0L, 0L, &idletimeout);
		return true;
	}
}





























