#ifndef _STARTUPWIZARD_H_
#define _STARTUPWIZARD_H_

// QT includes
#include <qwidget.h>
#include <qlabel.h>
#include <qlist.h>
class QButtonGroup;
class QLineEdit;

// Local includes
#include "kwizard.h"
#include "configmodulebase.h"
#include "wizardpage.h"

class StartupWizard : public KWizard
{
  Q_OBJECT

public:
  StartupWizard(QWidget* parent, const char* name);
  ~StartupWizard();

protected:
  void initModules();
  void createWizardPage(WizardPage* psWizardPage, ConfigModuleBase* module);

  void initPage1();
  void initPage2();
  void initPage3();
  void initPage4();
  void initPage5();
  void initPage6();

  void saveAllOptions();
  
private:
  QList<ConfigModuleBase> fModuleList;


public slots:
  /** Called whenever the help button is pressed
   */
  void slotHelpButtonPressed() {};
  void slotOkClicked();

protected slots:
 
};

#endif
