// Local includes
#include "psentry.h"
#include "databaseresource.h"

// Stdlib includes
#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>

PSEntry::PSEntry(DBEntry* dbEntry)
{ 
  if (dbEntry == NULL)
    {
      fDBEntry = new DBEntry;
    }
  else
    {
      fDBEntry = dbEntry;
    }

  sync();
}

PSEntry::~PSEntry()
{
  delete (fDBEntry);
}

void PSEntry::setKey(int key)
{
  fModified = TRUE;

  char temp[10];

  sprintf(temp, "%d", key);
  
  fKey = temp;
}

DBEntry* PSEntry::getDBEntry()
{
  /** Stores whether something has been modified in this entry or not.
   */
  fDBEntry->fModified = fModified;

  /** Stores whether this entry should be deleted as of next perge or not
   */
  fDBEntry->fDeleteMe = fDeleteMe;

  // These are the fields of an entry
  fDBEntry->fLastname = fLastname;
  fDBEntry->fFirstname = fFirstname;
  
  fDBEntry->fTitle = fTitle;
  fDBEntry->fCompany = fCompany;
  
  fDBEntry->fAddress = fAddress;
  fDBEntry->fCity = fCity;
  fDBEntry->fState = fState;
  fDBEntry->fZip = fZip;
  fDBEntry->fCountry =  fCountry;
  
  fDBEntry->fPhone1 = fPhone1;
  fDBEntry->fPhone2 = fPhone2;
  fDBEntry->fPhone3 = fPhone3;
  fDBEntry->fPhone4 = fPhone4;
  fDBEntry->fPhone5 = fPhone5;
  
  fDBEntry->fCustom1 = fCustom1;
  fDBEntry->fCustom2 = fCustom2;
  fDBEntry->fCustom3 = fCustom3;
  fDBEntry->fCustom4 = fCustom4;
  
  fDBEntry->fComment = fComment;
  
  fDBEntry->fReferredBy = fReferredBy;
  
  fDBEntry->fEditDate = fEditDate;
  fDBEntry->fMergeDate = fMergeDate;
  fDBEntry->fLastReach =  fLastReach;
  fDBEntry->fLastAttempt = fLastAttempt;
  fDBEntry->fLastMeeting = fLastMeeting;
  
  fDBEntry->fRecordCreator =  fRecordCreator;
  fDBEntry->fCreateDate = fCreateDate;
  
  //QList<NoteStruct> fNotes;
  
  fDBEntry->fGroup = (int)fGroup;
  
  fDBEntry->fCustom1Label = fCustom1Label;
  fDBEntry->fCustom2Label = fCustom2Label;
  fDBEntry->fCustom3Label = fCustom3Label;
  fDBEntry->fCustom4Label = fCustom4Label;
  
  fDBEntry->fPhone1Type = (int)fPhone1Type;
  fDBEntry->fPhone2Type = (int)fPhone2Type;
  fDBEntry->fPhone3Type = (int)fPhone3Type;
  fDBEntry->fPhone4Type = (int)fPhone4Type;
  fDBEntry->fPhone5Type = (int)fPhone5Type;

  fDBEntry->fKey = fKey;

  return fDBEntry;
}

PSEntry* PSEntry::duplicateSelf()
{
  PSEntry* entry = new PSEntry(NULL);

  entry->setLastName(fLastname);
  entry->setFirstName(fFirstname);
  
  entry->setTitle(fTitle);
  entry->setCompany(fCompany);

  entry->setAddress(fAddress);
  entry->setCity(fCity);
  entry->setState(fState);
  entry->setZip(fZip);
  entry->setCountry(fCountry);

  entry->setPhone1(fPhone1, fPhone1Type);
  entry->setPhone2(fPhone2, fPhone2Type);
  entry->setPhone3(fPhone3, fPhone3Type);
  entry->setPhone4(fPhone4, fPhone4Type);
  entry->setPhone5(fPhone5, fPhone5Type);

  entry->setCustom1(fCustom1, fCustom1Label);
  entry->setCustom2(fCustom2, fCustom2Label);
  entry->setCustom3(fCustom3, fCustom3Label);
  entry->setCustom4(fCustom4, fCustom4Label);

  entry->setComment(fComment);
  
  entry->setReferredBy(fReferredBy);
  
  entry->setEditDate(fEditDate);
  entry->setMergeDate(fMergeDate);
  entry->setLastReach(fLastReach);
  entry->setLastAttempt(fLastAttempt);
  entry->setLastMeeting(fLastMeeting);

  entry->setRecordCreator(fRecordCreator);
  entry->setCreateDate(fCreateDate);

  entry->setGroup(fGroup);
  
  return entry;
}

void PSEntry::sync()
{
 setLastName(fDBEntry->fLastname);
  setFirstName(fDBEntry->fFirstname);
  
  setTitle(fDBEntry->fTitle);
  setCompany(fDBEntry->fCompany);
  
  setAddress(fDBEntry->fAddress);
  setCity(fDBEntry->fCity);
  setState(fDBEntry->fState);
  setZip(fDBEntry->fZip);
  setCountry(fDBEntry->fCountry);

  setGroup((eGroupType)fDBEntry->fGroup);

  setPhone1(fDBEntry->fPhone1, (ePhoneType)fDBEntry->fPhone1Type);
  setPhone2(fDBEntry->fPhone2, (ePhoneType)fDBEntry->fPhone2Type);
  setPhone3(fDBEntry->fPhone3, (ePhoneType)fDBEntry->fPhone3Type);
  setPhone4(fDBEntry->fPhone4, (ePhoneType)fDBEntry->fPhone4Type);
  setPhone5(fDBEntry->fPhone5, (ePhoneType)fDBEntry->fPhone5Type);

  setCustom1(fDBEntry->fCustom1, fDBEntry->fCustom1Label);
  setCustom2(fDBEntry->fCustom2, fDBEntry->fCustom2Label);
  setCustom3(fDBEntry->fCustom3, fDBEntry->fCustom3Label);
  setCustom4(fDBEntry->fCustom4, fDBEntry->fCustom4Label);

  setComment(fDBEntry->fComment);
  
  setReferredBy(fDBEntry->fReferredBy);

  //cout << "Merge Date: " << fDBEntry->mergeDate << endl;

  setEditDate(fDBEntry->fEditDate);
  setMergeDate(fDBEntry->fMergeDate);
  setLastReach(fDBEntry->fLastReach);
  setLastAttempt(fDBEntry->fLastAttempt);
  setLastMeeting(fDBEntry->fLastMeeting);
  
  setRecordCreator(fDBEntry->fRecordCreator);
  setCreateDate(fDBEntry->fCreateDate);
  
  setKey(fDBEntry->fKey.toInt());

  fModified = FALSE;
  fDeleteMe = FALSE;
}
