#include "psassociate.h"
#include "psdatabasemanager.h"
#include "resource.h"

#include <qapplication.h>

#include <kapp.h>

#include <iostream.h>
#include <stdlib.h>

PSAssociate::PSAssociate(PSDatabaseManager* psDatabaseManager, QWidget *parent, const char *name)
	: QDialog(parent, name, false)
{
  QString caption = "PeopleSpace ListView";
  caption += VERSION;

  setCaption(caption);

  fPSDatabaseManager = psDatabaseManager;
  connect(fPSDatabaseManager, SIGNAL(groupFilterApplied(int, 
							QList<QString>*,  
							QList<QString>*,  
							QList<QString>*,  
							QList<QString>*)),
	  this, SLOT( slotGroupFilterApplied(int, 
					     QList<QString>*,  
					     QList<QString>*,  
					     QList<QString>*,  
					     QList<QString>*)));
  connect(fPSDatabaseManager, SIGNAL( databaseHasOpened(QString, int) ), this, SLOT( slotDatabaseHasOpened(QString, int) ));
  connect(fPSDatabaseManager, SIGNAL( databaseHasClosed() ), this, SLOT( slotDatabaseHasClosed() ));
  
  fContactListView = new CListView(this, "ContactListView");
  fContactListView->addColumn("Name", 100);
  fContactListView->addColumn("Field1", 100);
  fContactListView->addColumn("Field2", 100);
  fContactListView->addColumn("Key", 100);
  fContactListView->setGeometry(0,0,this->width(), this->height());
  fContactListView->setAllColumnsShowFocus( true );
  fContactListView->setMultiSelection( false );
  connect(fContactListView, SIGNAL( selectionChanged(QListViewItem*) ), this, SLOT( slotSelectionChanged(QListViewItem*)));
  
}

PSAssociate::~PSAssociate()
{
}

void PSAssociate::clearList()
{
  fContactListView->clear();
}

void PSAssociate::setListView( QList<QString>* field1List,  
				   QList<QString>* field2List,  
				   QList<QString>* field3List,  
				   QList<QString>* keyFieldList)
{
  KConfig* config = kapp->getConfig();

   fContactListView->clear();

  QString* field1 = field1List->first();
  QString* field2 = field2List->first();
  QString* field3 = field3List->first();
  QString* keyField = keyFieldList->first(); 

  while (field1 != NULL)
    {
      addItem(*field1, *field2, *field3, *keyField);

      field1 = field1List->next();
      field2 = field2List->next();
      field3 = field3List->next();
      keyField = keyFieldList->next();
    }

  config->setGroup("LISTVIEW");
  fContactListView->setSorting(config->readNumEntry("SortColumn", 0));
  fContactListView->triggerUpdate();
  kapp->getKApplication()->processEvents();

  if (fContactListView->childCount() > 0)
      fContactListView->setSelected(fContactListView->firstChild(), true);
  else
    emit entrySelected(-1, true, true);
}

void PSAssociate::addItem(QString name, QString field1, QString field2, QString key)
{
  QListViewItem* item;

  item = new QListViewItem(fContactListView, name, field1, field2, key);
}

void PSAssociate::resizeEvent(QResizeEvent* e)
{
  QWidget::resizeEvent(e);

  fContactListView->setGeometry(0,0,this->width(), this->height());
}

void PSAssociate::changeSelectedEntry(int direction)
{
  QListViewItem* item, *nextItem;
  bool found = false;

  switch(direction)
    {
    case ID_VIEW_NEXT:
      item = fContactListView->currentItem();
      fContactListView->setSelected(item, false);
      fContactListView->setSelected(item->itemBelow(), true);
      break;

    case ID_VIEW_PREV:
      item = fContactListView->currentItem();
      fContactListView->setSelected(item, false);
      fContactListView->setSelected(item->itemAbove(), true);
      break;

    case ID_VIEW_LAST:
      item = fContactListView->currentItem();
      fContactListView->setSelected(item, false);
      nextItem = item->itemBelow();
      
      while (nextItem != NULL)
	{
	  item = nextItem;
	  nextItem = item->itemBelow();
	}
      fContactListView->setSelected(item, true);
      
      break;
      
    case ID_VIEW_FIRST:
      item = fContactListView->currentItem();
      fContactListView->setSelected(item, false);
      fContactListView->setSelected(fContactListView->firstChild(), true);
      break;

    default:  // set to specific key
      item = fContactListView->currentItem();
      fContactListView->setSelected(item, false);
      item = fContactListView->firstChild();
      while ((item != NULL) && (!found))
	{
	  if (atoi(item->text(3)) == direction)
	    found = true;
	  else
	    item = item->itemBelow();
	}
      
      if (found)
	fContactListView->setSelected(item, true);

      else
	fContactListView->setSelected(fContactListView->firstChild(), true);
      
      break;
      
    }
}

int PSAssociate::selectedEntry()
{ 
  QListViewItem* item = fContactListView->currentItem();
  return atoi(item->text(3));
}
  
//////////////////////////////////////////////////
/////////////////// SLOTS ////////////////////////

void PSAssociate::slotGroupFilterApplied(int, 
			      QList<QString>* list1,  
			      QList<QString>* list2,  
			      QList<QString>* list3,  
			      QList<QString>* list4)
{
  setListView(list1, list2, list3, list4);
}

void PSAssociate::slotDatabaseHasOpened(QString pathWithFile, int flag)
{
}

void PSAssociate::slotDatabaseHasClosed()
{
  disconnect(fContactListView, SIGNAL( selectionChanged(QListViewItem*) ), this, SLOT( slotSelectionChanged(QListViewItem*)));
  fContactListView->clear();
  connect(fContactListView, SIGNAL( selectionChanged(QListViewItem*) ), this, SLOT( slotSelectionChanged(QListViewItem*)));
}

void PSAssociate::slotSelectionChanged(QListViewItem* item)
{
  //cout << "Selected Item: " << item->text(3) << endl;

  bool first = false, last = false;

  if (item->itemAbove() == 0)
    first = true;

  if (item->itemBelow() == 0)
    last = true;

  emit entrySelected(atoi(item->text(3)), first, last);
}

#include "psassociate.moc"
