#include "modcolumns.h"

// QT includes
#include <qgroupbox.h>
#include <qcombobox.h>
#include <qlabel.h>

// KDE includes
#include <kapp.h>
#include <klocale.h>
#include <kconfig.h>

ModColumns::ModColumns(QWidget* parent, const char* name) : ConfigModuleBase("Columns", "ListView", parent, name)
{
  KConfig* config = kapp->getConfig();
  config->setGroup("LISTVIEW");

  fFieldGroupBox = new QGroupBox(i18n("List View Fields"), this, "FieldGroupBox");
  fFieldGroupBox->setGeometry(5, 5, 270, 120);

  QLabel* label = new QLabel(i18n("Field 1:"), fFieldGroupBox);
  label->setGeometry(10, 20, 250, 20); 

  fField1Combo = new QComboBox(fFieldGroupBox, "Field1Combo");
  fField1Combo->setGeometry(10, 40, 250, 25);
  fField1Combo->setCurrentItem(config->readNumEntry("Field1", 0));

  label = new QLabel(i18n("Field 2:"), fFieldGroupBox);
  label->setGeometry(10, 65, 250, 20); 
  
  fField2Combo = new QComboBox(fFieldGroupBox, "Field2Combo");
  fField2Combo->setGeometry(10, 85, 250, 25);
  fField2Combo->setCurrentItem(config->readNumEntry("Field2", 0));

  fSortingGroupBox = new QGroupBox(i18n("Sorting Column"), this, "SortingGroupBox");
  fSortingGroupBox->setGeometry(5, 135, 270, 80);

  label = new QLabel(i18n("Sort by column:"), fSortingGroupBox);
  label->setGeometry(10, 20, 250, 20);

  fSortingCombo = new QComboBox(fSortingGroupBox, "SortingCombo");
  fSortingCombo->setGeometry(10, 40, 250, 25);
  fSortingCombo->insertItem(i18n("Name"));
  fSortingCombo->insertItem(i18n("Field1"));
  fSortingCombo->insertItem(i18n("Field2"));
  fSortingCombo->insertItem(i18n("Key"));
  fSortingCombo->setCurrentItem(config->readNumEntry("SortColumn", 0));
}

ModColumns::~ModColumns()
{
}

void ModColumns::saveOptions()
{
  KConfig* config = kapp->getConfig();

  config->setGroup("LISTVIEW");
  config->writeEntry("Field1", 0);
  config->writeEntry("Field2", 0);
  config->writeEntry("SortColumn", fSortingCombo->currentItem());
}

#include "modcolumns.moc"
