#ifndef LISTDIALOG_H_
#define LISTDIALOG_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 
#define NAME_COLUMN_NUM   0
#define FIELD1_COLUMN_NUM 1
#define FIELD2_COLUMN_NUM 2
#define KEY_COLUMN_NUM    3

// Local includes
class CListView;
class PSDatabaseManager;

// QT Dialog
#include <qdialog.h>
#include <qwidget.h>
#include <qlist.h>
class QPushButton;
class QComboBox;
class QListViewItem;

class ListDialog : public QDialog
{
  Q_OBJECT

public:
  ListDialog(PSDatabaseManager* databaseManager, QWidget *parent, const char *name);
  ~ListDialog();

 /** Sets the group filter combo box
   */
  void setGroupFilter(int filter);

  void saveYourself();

  void addItem(QString name, QString field1, QString field2, QString key);
  void clearList();
  int currentCount();
  void setFirstItemSelected();
  void setItemSelected(int key);

 /** returns the currently selected group filter
   */
  int groupFilter();

  /** Called whenever one of the direction arrows it pressed
   */
  void directionButtonClicked(int buttonId);

protected:
  void resizeEvent(QResizeEvent*);

private:
  CListView *fListView;

  PSDatabaseManager* fPSDatabaseManager;

  QPushButton* fRefreshButton;
  QPushButton* fHideButton;
  QPushButton* fQuitButton;

  QComboBox* fGroupCombo;

public slots:
  void slotGroupFilterChanged(int);
  void slotQuitButtonClicked();
  void slotHideButtonClicked();
  void slotListViewSelectionChanged(QListViewItem* item);
  void slotRefreshButtonClicked();
  void slotGroupFilterApplied(int, 
			 QList<QString>*,  
			 QList<QString>*,  
			 QList<QString>*,  
			 QList<QString>*);
  void slotDatabaseHasOpened(QString, int);
signals:
  //void groupFilterChanged(int);
  void quitButtonClicked();
  /** emitted when the selection changes. The paramiter will be the key of the
   * newly selected entry
   */
  //void selectionChanged(int);

  /** User pressed the refresh button. The list should be updated accordingly
   */
  //void refreshButtonClicked();

};

#endif

