// Local includes
#include "dbopentypedialog.h"

// QT includes
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qlabel.h>

// KDE includes
#include <kapp.h>
#include <klocale.h>

// Standard includes
#include <iostream.h>

DBOpenTypeDialog::DBOpenTypeDialog(QWidget* parent, const char* name) : QDialog(parent, name, TRUE)
{
  this->resize(200, 200);
  this->setCaption(i18n("Open DB Options"));

  fOKButton = new QPushButton(i18n("&OK"), this, "OKButton");
  fOKButton->setGeometry(this->width()/2-30, this->height()-40, 60, 30);
  connect(fOKButton, SIGNAL( clicked() ), this, SLOT( slotOKButtonClicked() ));

  fButtonGroup = new QButtonGroup(this, "ButtonGroup");
  fButtonGroup->setGeometry(5, 5, 190, 150);

  QLabel* label;

  label = new QLabel(i18n("How would you like this\ndatabase opened?"), fButtonGroup);
  label->setAutoResize( TRUE );
  label->setAlignment(AlignHCenter);
  label->setGeometry(((fButtonGroup->width()/2) - (label->width()/2)), 15, label->width(), label->height());

  QRadioButton *radioButton;

  radioButton = new QRadioButton(i18n("Read / Write"), fButtonGroup);
  radioButton->setGeometry(20, 60, 150, 15);
  fButtonGroup->insert(radioButton);
  radioButton = new QRadioButton(i18n("Read Only"), fButtonGroup);
  radioButton->setGeometry(20, 75, 150, 15);
  fButtonGroup->insert(radioButton);
  radioButton = new QRadioButton(i18n("R/W first. If failure, R"), fButtonGroup);
  radioButton->setGeometry(20, 90, 150, 15);
  fButtonGroup->insert(radioButton);

  fButtonGroup->setButton(0);
  slotSelectedRadioButtonChanged(0);
  connect(fButtonGroup, SIGNAL(clicked(int) ), this, SLOT( slotSelectedRadioButtonChanged(int)));

  fDefaultCheckBox = new QCheckBox(i18n("Save as Default"), this, "DefaultCheckBox");
  fDefaultCheckBox->setGeometry(40, 125, 150, 15);

  show();
}

DBOpenTypeDialog::~DBOpenTypeDialog()
{
}

int DBOpenTypeDialog::selectedOption()
{
  return fSelectedOption;
}

bool DBOpenTypeDialog::defaultCheckBoxIsChecked()
{
  return fDefaultCheckBox->isChecked();
}

////////////////////////////////////////////////
////////////////  SLOTS  ///////////////////////

void DBOpenTypeDialog::slotOKButtonClicked()
{
  done(1);
}

void DBOpenTypeDialog::slotSelectedRadioButtonChanged(int id)
{
  fSelectedOption = id;
}

#include "dbopentypedialog.moc"
