// Local includes
#include "datepickerdialog.h"

// KDE includes
#include <kdatepik.h>
#include <kapp.h>
#include <klocale.h>

// QT includes
#include <qpushbutton.h>

DatePickerDialog::DatePickerDialog(QWidget* parent, const char* name, QDate date) : QDialog(parent, name, TRUE)
{
  this->setGeometry(parent->width()/2 -100, parent->height()/2, 200, 200);
  this->setCaption(i18n("PS Date Picker"));

  QPushButton* cancel;
  fOk = new QPushButton( i18n("&Ok"), this );
  fOk->setGeometry(10 , 160, 85, 30 );
  connect( fOk, SIGNAL(clicked()), SLOT(accept()) );
  fOk->setEnabled( FALSE );
  cancel = new QPushButton( i18n("&Cancel"), this );
  cancel->setGeometry(105, 160, 85, 30 );
  connect( cancel, SIGNAL(clicked()), SLOT(reject()) );

  fPickedDate = date;
  fDatePicker = new KDatePicker(this, fPickedDate);
  fDatePicker->setGeometry(5, 5, 190, 145);
  connect(fDatePicker, SIGNAL( dateSelected(QDate) ), this, SLOT( slotDateSelected(QDate) ));
}

DatePickerDialog::~DatePickerDialog()
{
}

QDate DatePickerDialog::selectedDate()
{
  return fPickedDate;
}
///////////////////////////////////////////////
//////////     SLOTS     //////////////////////

void DatePickerDialog::slotDateSelected(QDate date)
{
  fOk->setEnabled( TRUE );

  fPickedDate = date;
}
#include "datepickerdialog.moc"
