// Local includes
#include "commanager.h"

// KDE includes
#include <ksock.h>

// Standard includes
#include <iostream.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>  

ComManager::ComManager(KSocket* socket)
{
  fSocket = NULL;
  setSocket(socket);
}

ComManager::ComManager()
{
  fSocket = NULL;
}

ComManager::~ComManager()
{
  delete (fSocket);
}

void ComManager::setSocket(KSocket* socket)
{
  fSocket = socket;

  fSocket->enableRead( true );
  connect(fSocket, SIGNAL( readEvent( KSocket* ) ), this, SLOT( slotReadEvent( KSocket* ) ));
  connect(fSocket, SIGNAL( closeEvent( KSocket* ) ), SLOT( slotConnectionBroken() ) );
}

void ComManager::sendCommand(int command, QString param)
{
  QString message;

  if (fSocket == NULL)
    return;

  message.sprintf("%d", command);

  if (!param.isEmpty())
    {
      message += " ";
      message += param;
    }
  
  message += "\n";

  write(fSocket->socket(), (const char*)message, message.length());
}

bool ComManager::connected()
{
  if (fSocket != NULL)
    return true;
  
  return false;
}

/////////////////////////////////////////////////
//////////////////////// SLOTS //////////////////

void ComManager::slotReadEvent(KSocket* socket)
{
  char buffer;
  int bytes, retval, spacePos;
  QString socketIn, command;
  fd_set rfds;
  struct timeval tv;     

  FD_ZERO(&rfds);
  FD_SET(socket->socket(), &rfds);

  tv.tv_sec = 10;
  tv.tv_usec = 0;           

  // This method of reading from the socket was roughly based on the method used in KBiff
  retval = select(socket->socket()+1,  &rfds, NULL, NULL, &tv); 
  while ((retval) && ( (((bytes = ::read(socket->socket(), &buffer, 1)) > 0) && (buffer != '\n')) || (bytes < 0)  ))
    {
      if (bytes > 0)
        {
          socketIn += buffer;
        }
      retval = select(socket->socket()+1,  &rfds, NULL, NULL, &tv);
    }                                             

  // Strip return characters
  socketIn = socketIn.simplifyWhiteSpace();

  // Now we need to get the command out
  spacePos = socketIn.find(" ", 0, false);
  if (spacePos > 0)
    {
      command = socketIn.left(spacePos);
      socketIn = socketIn.remove(0, spacePos+1);
    }
  else
    {
      command = socketIn;
      socketIn = "";
    }

  emit receiveCommand(command.toInt(), socketIn);
}

void ComManager::slotConnectionBroken()
{
  delete(fSocket);
  fSocket = NULL;
  emit connectionBroken();
}

#include "commanager.moc"
