/***************************************************************************
                          lostview.h  -  description                              
                             -------------------                                         
    begin                : Sat Jun  5 13:37:40 CEST 1999
                                           
    copyright            : (C) 1999 by jec                         
    email                : cuendet@linkvest.ch                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef LOSTVIEW_H 
#define LOSTVIEW_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <kapp.h>
#include <qlistview.h>

#include <list>
#include <string>


/**
  * This class provides an incomplete base for your application view. 
  */



#include "lost_treenode.h"
#include <qlist.h>

#include "utils.h"



class LoSTApp;
class LoST_TreeNode;

class LoSTView : public QListView
{
  Q_OBJECT

 public:

	enum e_SortOptions { NAME, SIZE };
	enum e_ViewOptions { REAL_SIZE, USED_SIZE, PERCENT };

  /** Constructor for the main view */
  LoSTView(LoSTApp* a);
  /** Destructor for the main view */
  ~LoSTView();

	void updateTree(const QString& base);
	void updateTree();
	void stopUpdate();
	bool isUpdating() { return isUpdating_; };

	void excludeDirs();
	void diffWithRpms();
	void diffWithDebs();

	const QPixmap* getPixmap(LoST_TreeNode::e_Type type, int param);
	
	e_SortOptions getSortOption() const;
	void setSortOption(e_SortOptions o);
	e_ViewOptions getViewOption() const;
	void setViewOption(e_ViewOptions o);

	virtual void setColumnWidth ( int column, int w );
	
	const QString& getBasePath() { return basePath_; };
	
	StdStringList& getExcludeDirList();
	void setExcludeDirList(StdStringList& list);
	
public slots:

	void slotRightButtonPressed(QListViewItem* view, const QPoint& p, int i);

protected:

	void resizeEvent(QResizeEvent* e);
	
	int getListOfInstalledFiles(StdStringList& alist, QString& errorString);
	int getListOfInstalledFiles_RPM(StdStringList& filesList, QString& errorString);
	int getListOfInstalledFiles_DEB(StdStringList& filesList, QString& errorString);
	bool fillNode(LoST_TreeNode* node);
	
	void setNeedSizeUpdateToAll(LoST_TreeNode* node);
	
	void treatPopupMenu(int id, LoST_TreeNode* item);
	
	void removePath(const QString& str);
	
	void updateView();
	
private:
	LoSTApp* parent_;

	QString basePath_;
	bool mustStop_;
	bool isUpdating_;
	bool isUpdated_;
	
	//QList<QString> directoryToDelete_;
	
	LoST_TreeNode* root_;
	StdStringList excludeDirList_;
	
	QPixmap closeDirPixmap_;
	QPixmap openDirPixmap_;
	QPixmap filesPixmap_;
	QPixmap filePixmap_;
	QPixmap symLinkPixmap_;
	QPixmap unknownPixmap_;
	
	e_SortOptions sortOption_;
	e_ViewOptions viewOption_;
	bool asc_;
};

#endif // LOSTVIEW_H 











