/***************************************************************************
                          kreglo.h  -  description                              
                             -------------------                                         
    begin                : Thu Jul  1 16:24:56 MEST 1999
                                           
    copyright            : (C) 1999 by [CRY0]                         
    email                : cryo@tronet.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef KREGLO_H
#define KREGLO_H

#include <stdlib.h>
#include <kapp.h>
#include <kconfig.h>
#include <qwidget.h>
#include "kwm.h"
#include "qpainter.h"
#include "qimage.h"
#include "qpixmap.h"
#include "qpaintdevice.h"
#include "qapplication.h"
#include "qtimer.h"
#include "qcursor.h"
#include "qpopupmenu.h"

class KReglo : public QWidget
{
  Q_OBJECT 
public: 
  /** construtor */
  KReglo( QWidget*parent=0, const char* name=0 );
  /** destructor */
  ~KReglo();

	// Configuration values.
	bool bStartupHorizontal;
	bool bHorizontalRulerTop;
	bool bVerticalRulerLeft;
	int  iZoomFactor;

protected:
    QPainter *MainPainter, *MagnifierPainter;
	QPixmap backPixmapH, backPixmapV;
	QPixmap magnifierPixmap;
	QTimer *timer;
	QPoint globalMousePoint, localMousePoint;
	QCursor *gCursor;
	QPopupMenu pMenu;
	QPalette *palette;

	void paintEvent ( QPaintEvent * );	
	void mousePressEvent( QMouseEvent *e );
	void mouseMoveEvent( QMouseEvent *e );
	void mouseReleaseEvent( QMouseEvent *e );
	void mouseDoubleClickEvent ( QMouseEvent * e );
private:		
	KConfig *kcfg;
	int MarkerX;
	int MouseX, MouseY;

	bool bIsDragging;
	bool bIsMovingWindow;
	bool bIsHorizontal;

private slots:
	void refreshMouseCoordinates();
	void Quit();
	void Preferences();	
};
#endif



















