/***************************************************************************
                          kwebcam.h  -  description
                             -------------------
    begin                : Sat Nov  6 05:44:07 EST 1999
    copyright            : (C) 1999 by Troy Ogden
    email                : badger@bookshelves.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KWEBCAM_H
#define KWEBCAM_H

#include "kweboptions.h"
#include <qlayout.h>
#include <kmenubar.h>
#include <kapp.h>
#include <qwidget.h>
#include <kprocess.h>
#include <kmsgbox.h>
#include <ktmainwindow.h>
#include <qtimer.h>
#include <qpixmap.h>
#include <qpainter.h>
#include <qcheckbox.h>
#include <qmessagebox.h>

class KWebcam : public  KTMainWindow
{
  Q_OBJECT 

protected:
	KProcess*	m_camProcess;
	KMenuBar*	m_menubar;
	QPopupMenu*	fileMenu;
	QPopupMenu*	quitMenu;
	QPopupMenu*	m_helpMenu;
	QPopupMenu*	optionsMenu;
	KStatusBar*	my_statusbar;
	KWebOptions* 	optionsDlg;
	QLabel*		my_frame;
	QLabel*		my_label;


public:
	QPushButton	*thebutton;
	QPushButton	*quit;
	QTimer* 	timer;
	char host[30], login_name[20], passwd[20];
	KWebcam(QWidget *parent = 0, const char *name = 0);
	~KWebcam();

private:
	QLabel		*mylabel;
	QPixmap		my_pix;
	QLabel		*picLabel;
	QPainter*	p;
	QString 	formatstring;
	QString 	errstring;
	KConfig 	*config;
	void		paintEvent( QPaintEvent * );
	QCheckBox 	*offlinebutton;

public slots:
	void camProcess();
	void timerDone();
	void getOptions();
	void readStderr(KProcess *proc, char *buffer, int buflen);

private slots:
	void toggleTextSLOT();
	void stopCam();
	void kwebConnect();

signals:
	void timeout ();
	void receivedStderr (KProcess *proc, char *buffer, int buflen);

};

#endif
