/***************************************************************************
                          globals.h  -  description
                             -------------------
    begin                : Fri Jun 2 2000
    copyright            : (C) 2000 by CFJH
    email                : hochwald@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef _GLOBALS_H_
#define _GLOBALS_H_

#define CNT_TEMPUNITS 4  // Anzahl Temperatureinheiten
#define CNT_PRSUNITS 5  // Luftdruck
#define CNT_LEVELUNITS 6   // Pegel
#define CNT_WINDDIRUNITS 2   // Windrichtung
#define CNT_WINDSTRENGTHUNITS 4   // Windstrke

#define FLOAT_VALIDS "0123456789+-.,"  // Gltige Zeichen fr eine Float-Zahl
#include <qimage.h>

struct GridSettingsType {
  short int Grid;           // # der Gridfelder
  short int ZeroLine;       // Position der Nulllinie
  short int ColorFlags;     // autom. Farbbestimmung der Skalen
                            // Bit 0 : Temperatur
                            // Bit 1 : Luftdruck
                            // Bit 2 : Niederschlag/Pegel

  char LineUnits[10];       // Typ Line Einheit
  float LineGrids;      // Einheiten pro Grid
  float LineZero;       // Nulllinie
  short int LineDspLeft,LineDspRight; // Anzeige links/rechts

  char PrsUnits[10];        // Typ Pressure
  float PrsGrids;
  float PrsZero;
  short int PrsDspLeft,PrsDspRight; // Anzeige links/rechts

  char LevelUnits[10];      // Typ Level
  float LevelGrids;
  float LevelZero;
  short int LevelDspLeft,LevelDspRight; // Anzeige links/rechts

  char WindDirUnits[10],    // Einheit Windrichtung
  WindStrengthUnits[10];    // Einheit Windstrke

  long int Reserved[32];    // fr sptere Erweiterungen
};

extern char* (TempUnits[CNT_TEMPUNITS]);
extern char* (PrsUnits[CNT_PRSUNITS]);
extern char* (LevelUnits[CNT_LEVELUNITS]);
extern char* (WindDirUnits[CNT_WINDDIRUNITS]);
extern char* (WindStrengthUnits[CNT_WINDSTRENGTHUNITS]);

extern char* float2char(float f, int Len, int Nk);
extern int checkfloat(const char* S);

int MonTage(int Monat,int Jahr);
char* TimeToStrg(int Time);
int SetTempScales(const char *Unit, QWidget *ScaleEdit, QWidget *ZeroEdit);
int SetPrsScales(const char *Unit, QWidget *ScaleEdit, QWidget *ZeroEdit);
int SetLevelScales(const char *Unit, QWidget *ScaleEdit, QWidget *ZeroEdit);

typedef QPixmap* PixPtr;

#endif