/***************************************************************************
                          dlgedit.h  -  description
                             -------------------
    begin                : Fri Jun 2 2000
    copyright            : (C) 2000 by CFJH
    email                : hochwald@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
    kweather - a program for recording weather events
    Copyright (C) 1999 Jrgen Hochwald <hochwald@kde.org>
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
			
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
					
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/    
#ifndef _DLGCONVERT_H_
#define _DLGCONVERT_H_

//#include <ktmainwindow.h>
#include <qdialog.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <kapp.h>
#include <qwidgetstack.h>
#include <kwr.h>
#include <ktoolbar.h>
#include "chart.h"
#include "data.h"

class EditDlg : public QDialog // KTMainWindow
{
Q_OBJECT
public:
   EditDlg(DataFile* DFile, TChart* TC, const char* name=0);
   ~EditDlg(void);
   //int Aktualisieren(void);
   
signals:

private slots:
   void PrevBtnClick();
   void NextBtnClick();
   void FirstBtnClick();
   void LastBtnClick();
   void OkBtnClick();
   void AbortBtnClick();
   void WetterBtnClick();
   void KWRValueChange(float f);
   void WetterEditChange(const char* Text);

protected:
   virtual void keyPressEvent ( QKeyEvent * kev);

private:
   QPushButton *CloseBtn;
   //KToolBar *ToolBar;
   QLabel *TagLab, *GroupLab, *ItemLab, *PreviousLab;
   
   QLabel *EditEinheitLab, *WindEinheitLab, *WindRichtungLab;
   QFrame *EditFrm, *WetterFrm, *WindFrm;
   QLineEdit *LEdit;
   QLineEdit *WetterEdit, *WSEdit;
   KWindRose *KW;
   QPushButton *WetterBtn;

   TChart *Chart;
   DataFile* DF;
   
   int Tag,Item,Count;   // aktueller Eintrag Tag / Element / Count
   int MaxTag; //,MaxItem;   // Hchstmglicher Wert fr Tag und Item (im ZA-Arr)
   //int ZA[MAXDATA];      // Zuordnungsarray, Speichert lckenlos die 'echten'
                         // Daten, also ohne die Header (TYP_GROUP)
   
   void SetupToolBar();
   void UpdateHeader();  // Tages und Itemdaten aktualisieren
   void DisplayData();   // Anzeige der Daten
   int  StoreData();     // Daten berprfen und speichern
};
#endif
