// kvncauthwdg.cpp
// Author: Markus Wuebben <markus.wuebben@kde.org>
// This code is published under the GPL.

#include "kvncauthwdg.h"
#include "kvncauthwdg.moc"
#include "kviewer.h"

KVNCAuthWdg::KVNCAuthWdg(QWidget *parent, const char * name, KVNCCanvas *viewer)
  :QDialog(parent,name,true) {

  QString temp;
  view = viewer;

  setMaximumSize(300,100);
  setMinimumSize(300,100);
  temp.sprintf("%s login:",view->host());
  setCaption(temp);

  QLabel *label1 = new QLabel(this);
  label1->setText("Password:");
  label1->resize(label1->sizeHint());
  label1->move(20,20);

  passwdLdt = new QLineEdit(this,"NULL");
  passwdLdt->setEchoMode(QLineEdit::Password);
  passwdLdt->setGeometry(100,16,150,25);
  connect(passwdLdt,SIGNAL(returnPressed()),SLOT(slotOkPressed()));

  ok = new QPushButton("Ok" ,this,"NULL");
  ok->setGeometry(55,60,70,25);
  connect(ok,SIGNAL(pressed()),this,SLOT(slotOkPressed()));

  cancel = new QPushButton("Cancel", this);
  cancel->setGeometry(180,60,70,25);
  connect(cancel,SIGNAL(pressed()),this,SLOT(slotCancelPressed()));

}


void KVNCAuthWdg::slotOkPressed() {

  view->setPassword(passwdLdt->text());
  done(1);

}


void KVNCAuthWdg::slotCancelPressed() {

  done(0);

}  

void KVNCAuthWdg::retry() {

  passwdLdt->setText("");

}


KVNCConnectDlg::KVNCConnectDlg(QWidget *parent, const char *name, KVNCCanvas *wid)
  : QDialog(parent,name,true) {

  QString te;
  setMaximumSize(400,140);
  setMinimumSize(400,140);
  setCaption("Connect to Server...");

  viewer = wid;
  assert(wid);

  QLabel *label = new QLabel(this);
  label->setText("Host Name:");
  label->resize(label->sizeHint());
  label->move(20,30);

  hostNameLdt = new QLineEdit(this);
  hostNameLdt->setGeometry(100,27,150,25);

  te.sprintf("%s",viewer->host());
  if(te.isEmpty())
    hostNameLdt->setText("localhost");
  else
    hostNameLdt->setText(viewer->host());

  QLabel *label1 = new QLabel(this);
  label1->setText("Display #:");
  label1->resize(label1->sizeHint());
  label1->move(20,80);

  displayNumberLdt = new QLineEdit(this);
  displayNumberLdt->setGeometry(100,76,150,25);
  connect(displayNumberLdt,SIGNAL(returnPressed()),SLOT(slotOkPressed()));
  if(viewer->display() != -1) {
    te.sprintf("%i",viewer->display());
    displayNumberLdt->setText(te);
  }

  ok = new QPushButton("Ok" ,this,"NULL");
  ok->setGeometry(300,22,70,25);
  connect(ok,SIGNAL(clicked()),this,SLOT(slotOkPressed()));

  options = new QPushButton("Options",this,"NULL");
  options->setGeometry(300,57,70,25);
  connect(options,SIGNAL(clicked()),this,SLOT(slotOptionsPressed()));

  cancel = new QPushButton("Cancel", this);
  cancel->setGeometry(300,92,70,25);
  connect(cancel,SIGNAL(clicked()),this,SLOT(slotCancelPressed()));


}


void KVNCConnectDlg::slotOkPressed() {

  int dis;
  viewer->setHost(hostNameLdt->text());
  QString temp = displayNumberLdt->text();
  if(temp.isEmpty())
    dis = -1;
  else
    dis = temp.toUInt();    
  viewer->setDisplay(dis);
  done(1);

}

void KVNCConnectDlg::slotOptionsPressed() {
  
  KVNCOptionsWdg *wdg = new KVNCOptionsWdg(0L,0L,viewer);
  wdg->exec();

}

void KVNCConnectDlg::slotCancelPressed() {

  done(0);

}




KVNCOptionsWdg::KVNCOptionsWdg(QWidget *parent,const char *name, KVNCCanvas *wid)
  :QDialog(parent,name,true) {

  setCaption("Connection Options...");
  resize(200,300);

  canvas = wid;

  // Read settings
  _encodings = 0;
  readConfig();

  groupBox = new QGroupBox(this);
  groupBox->setTitle("Preferred encodings");
  groupBox->move(20,15);
  groupBox->resize(160,145);

  hex = new QCheckBox("Hextile",groupBox);
  hex->setGeometry(5,17,100,15);
  if(_hextile)
    hex->setChecked(true);

  corre = new QCheckBox("CoRRE",groupBox);
  corre->setGeometry(5,42,100,15);
  if(_corre)
    corre->setChecked(true);

  rre = new QCheckBox("RRE",groupBox);
  rre->setGeometry(5,67,100,15);
  if(_rre)
    rre->setChecked(true);

  raw = new QCheckBox("Raw",groupBox);
  raw->setGeometry(5,92,100,15);
  if(_raw)
    raw->setChecked(true);

  copyRect = new QCheckBox("copy Rect",groupBox);
  copyRect->setGeometry(5,117,140,15);
  if(_copyrect)
    copyRect->setChecked(true);

  deIconify = new QCheckBox("Deiconify on bell",this);
  deIconify->setGeometry(25,170,160,15);
  if(_deiconify)
    deIconify->setChecked(true);

  bit = new QCheckBox("Request 8-bit session",this);
  bit->setGeometry(25,195,160,15);
  if(_restrict)
    bit->setChecked(true);

  shared = new QCheckBox("Request shared session",this);
  shared->setGeometry(25,220,160,15);
  if(_shared)
    shared->setChecked(true);
  
  ok = new QPushButton("Ok",this);
  ok->setGeometry(20, 250, 70,25);
  connect(ok,SIGNAL(clicked()),this,SLOT(okPressed()));


  cancel = new QPushButton("Cancel",this);
  cancel->setGeometry(105, 250, 70, 25);
  connect(cancel,SIGNAL(clicked()),this,SLOT(cancelPressed()));

}


void KVNCOptionsWdg::readConfig() {


  KConfig * config = KApplication::getKApplication()->getConfig();

  config->setGroup("Options");

  _hextile = config->readNumEntry("hextile",0);
  _corre = config->readNumEntry("corre",0);
  _rre = config->readNumEntry("rre",0);
  _raw = config->readNumEntry("raw",0);
  _copyrect = config->readNumEntry("copyrect",0);
  _deiconify = config->readNumEntry("deiconify",0);
  _restrict = config->readNumEntry("restrict",0);
  _shared = config->readNumEntry("shared",0);
  
  config->sync();

}


void KVNCOptionsWdg::writeConfig() {

  KConfig * config =  KApplication::getKApplication()->getConfig();
  config->setGroup("Options");

  config->writeEntry("hextile",_hextile);
  config->writeEntry("corre", _corre);
  config->writeEntry("rre", _rre);
  config->writeEntry("raw", _raw);
  config->writeEntry("copyrect", _copyrect);
  config->writeEntry("deiconify",_deiconify);
  config->writeEntry("restrict",_restrict);
  config->writeEntry("shared",_shared); 
  config->writeEntry("numEncodings", _encodings);

 
  config->sync();

}

void KVNCOptionsWdg::okPressed() {

  if(hex->isChecked()) {
    _encodings++;
    _hextile = true;
  }
  else
    _hextile = false;

  if(corre->isChecked()) {
    _encodings++;
    _corre = true;
  }
  else
    _corre = false;

  if(rre->isChecked()) {
    _encodings++;
    _rre = true;
  }
  else
    _rre = false;

  if(raw->isChecked()) {
    _encodings++;
    _raw = true;
  }
  else
    _raw = false;

  if(copyRect->isChecked()) {
    _encodings++;
    _copyrect = true;
  }
  else
    _copyrect = false;
  
  if(deIconify->isChecked())
    _deiconify = true;
  else
    _deiconify = false;
  
  if(bit->isChecked())
    _restrict = true;
  else
    _restrict = false;
  
  if(shared->isChecked())
    _shared = true;
  else
    _shared = false;

     
  writeConfig();
  done(1);

}

void KVNCOptionsWdg::cancelPressed() {

  done(0);

}








