#include "labelFrames.h"

labelFrame::labelFrame(const char *label,QWidget *parent,const char *name)
{
  myFrame = new QFrame(parent,name);
  myLabel = new QLabel(label,parent,name,0);
  myFrame->setFrameStyle(QFrame::Box|QFrame::Raised);
}

void labelFrame::hide()
{
  myLabel->hide();
  myFrame->hide();
}

void labelFrame::show()
{
  myFrame->show();
  myLabel->show();
}

void labelFrame::setPalette(const QPalette &myPal)
{
  myLabel->setPalette(myPal);
}

void labelFrame::setGeometry(int x,int y,int w,int h)
{
  myFrame->setGeometry(x,y,w,h);
  myLabel->setGeometry(x+2,y+2,w-4,h-4);
}

void labelFrame::setText(const char *myText)
{
  myLabel->setText(myText);
}

