    /*

    view.h  for  ktsp-0.1.0

    Copyright (C) 1999 Uwe Thiem
                       uwe@kde.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */



#ifndef __VIEW_
#define __VIEW__


#include <qpainter.h>
#include <ktmainwindow.h>

#include "point.h"
#include "canvas.h"



class View : public KTMainWindow
  {
  public:
    View( int pointsShape, int pointsColour, int pointsSize,
          int linesStyle, int linesColour, int linesWidth );
    virtual ~View();
    void drawTsp( Point *tsp );

  protected:
    void calcScale();

  private:
    Canvas *w;
    Point *points;
    DBL _width;
    DBL _height;
    DBL _marginX;
    DBL _marginY;
    int _pointsShape;
    int _pointsColour;
    int _pointsSize;
    int _linesStyle;
    int _linesColour;
    int _linesWidth;
  };





#endif   // __VIEW__
