    /*

    point.h  for ktsp-0.1.0

    Copyright (C) 1999 Uwe Thiem
                       uwe@kde.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */



#ifndef __POINT__
#define __POINT__


#include "globals.h"



class Point
  {
  public:
    Point();
    Point( int numberOfNeighbours );
    Point( int numberOfNeighbours, DBL x, DBL y );
    ~Point();
    void setNumberOfNeighbours( int number );
    DBL x() { return _x; }
    DBL y() { return _y; }
    void setX( DBL x ) { _x = x; }
    void setY( DBL y ) { _y = y; }
    int nextIndex();
    void setNextIndex( int next );
    Point *nextPointer();
    void setNextPointer( Point *next );
    int lastIndex();
    void setLastIndex( int last );
    Point *lastPointer();
    void setLastPointer( Point *last);
    int forwardI() { return _forwardi; }
    void setForwardI( int index ) { _forwardi = index; }
    Point *forwardP() { return _forwardp; }
    void setForwardP( Point *p ) { _forwardp = p; }
    int backwardI() { return _backwardi; }
    void setBackwardI( int index ) { _backwardi = index; }
    Point *backwardP() { return _backwardp; }
    void setBackwardP( Point *p ) { _backwardp = p; }
    bool directionForward() { return _directionForward; }
    void setDirectionForward( bool d ) { _directionForward = d; }
    void flipDirection() { _directionForward = !_directionForward; }
    int neighbour( int index );
    bool setNeighbour( int index, int value );

  private:
    DBL _x;
    DBL _y;
    int _forwardi;
    int  _backwardi;
    Point *_forwardp;
    Point *_backwardp;
    int *_neighbours;
    int _numberOfNeighbours;
    bool _directionForward;
  };



// Point inline functions

inline int Point::nextIndex()
  {
  if ( _directionForward )
    {
    return _forwardi;
    }
  else
    {
    return _backwardi;
    }
  }



inline void Point::setNextIndex( int next )
  {
  if ( _directionForward )
    {
    _forwardi = next;
    }
  else
    {
    _backwardi = next;
    }
  }


inline Point * Point::nextPointer()
  {
  if ( _directionForward )
    {
    return _forwardp;
    }
  else
    {
    return _backwardp;
    }
  }


inline void Point::setNextPointer( Point *next )
  {
  if ( _directionForward )
    {
    _forwardp = next;
    }
  else
    {
    _backwardp = next;
    }
  }


inline int Point::lastIndex()
  {
  if ( _directionForward )
    {
    return _backwardi;
    }
  else
    {
    return _forwardi;
    }
  }


inline void Point::setLastIndex( int last )
  {
  if ( _directionForward )
    {
    _backwardi = last;
    }
  else
    {
    _forwardi = last;
    }
  }


inline Point *Point::lastPointer()
  {
  if ( _directionForward )
    {
    return _backwardp;
    }
  else
    {
    return _forwardp;
    }
  }


inline void Point::setLastPointer( Point *last )
  {
  if ( _directionForward )
    {
    _backwardp = last;
    }
  else
    {
    _forwardp = last;
    }
  }


inline int Point::neighbour( int index )
  {
  if ( ( index < 0 ) || ( index >= _numberOfNeighbours ) )
    {
    return -1;
    }
  else
    {
    return _neighbours[index];
    }
  }



inline bool Point::setNeighbour( int index, int value )
  {
  if ( ( index < 0 ) || ( index >= _numberOfNeighbours ) )
    {
    return false;
    }
  else
    {
    _neighbours[index] = value;
    return true;
    }
  }



#endif      // __POINT__
