
/*

 $Id: urldlg.cpp,v 1.7 1999/11/20 13:19:14 espensa Exp $

 Copyright (C) Bernd Johannes Wuebben
               wuebben@math.cornell.edu
	       wuebben@kde.org

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */


#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>

#include <kapp.h>
#include <klocale.h>

#include "urldlg.h"

#include "urldlg.moc"


UrlDlg::UrlDlg( QWidget *parent, const QString& caption, 
		const QString& urltext)
  : KDialogBase( parent, "urldialog", true, caption, Ok|Cancel, Ok, true )
{
  QWidget *page = new QWidget( this ); 
  setMainWidget(page);
  QVBoxLayout *topLayout = new QVBoxLayout( page, 0, spacingHint() );
  
  QLabel *label = new QLabel( caption, page, "caption" );
  topLayout->addWidget( label );
  
  lineedit = new QLineEdit( urltext, page, "lineedit" );
  lineedit->setMinimumWidth(fontMetrics().maxWidth()*20);
  topLayout->addWidget( lineedit );

  topLayout->addStretch(10);
  topLayout->activate();
  page->setMinimumSize( page->sizeHint() );
}


void UrlDlg::focusInEvent( QFocusEvent * )
{
  lineedit->setFocus();
}

QString UrlDlg::getText()
{
  return lineedit->text();
}



#if 0



#include <qframe.h>
#include <qlabel.h>
#include <qlayout.h>

#include <kbuttonbox.h>
#include <klocale.h>

#include "urldlg.h"

#include "urldlg.moc"

//#define klocale KApplication::kApplication()->getLocale()





UrlDlg::UrlDlg( QWidget *parent, const QString& caption, 
		const QString& urltext)
  : QDialog( parent, "urldialog", TRUE )
{
  const int OUTER_SEP = 6;
  const int INNER_SEP = 6;

  QVBoxLayout *topLayout = new QVBoxLayout(this,OUTER_SEP,INNER_SEP);
  
  QLabel *label = new QLabel( caption, this, "caption" );
  topLayout->addWidget( label );
  
  lineedit = new QLineEdit( urltext, this, "lineedit" );
  lineedit->setMinimumWidth(fontMetrics().maxWidth()*20);
  topLayout->addWidget( lineedit );

  topLayout->addStretch(10);

  QFrame *hline = new QFrame( this );
  hline->setFrameStyle( QFrame::Sunken | QFrame::HLine );
  topLayout->addWidget( hline );

  KButtonBox *buttonBox = new KButtonBox( this, KButtonBox::HORIZONTAL, 0, 
					  INNER_SEP );
  buttonBox->addStretch();
  ok = buttonBox->addButton( i18n("&OK"), false );
  cancel = buttonBox->addButton( i18n("&Cancel"), false );
  buttonBox->layout();
  ok ->setDefault( true );
  connect( ok , SIGNAL(clicked()), SLOT(accept()) );
  connect( cancel , SIGNAL(clicked()), SLOT(reject()) );
  topLayout->addWidget( buttonBox );
  
  topLayout->activate();
}

//
// This can be removed
//
void UrlDlg::resizeEvent(QResizeEvent *)
{
}



#if 0
UrlDlg::UrlDlg( QWidget *parent,  const QString& caption, const QString& urltext)
	: QDialog( parent, "urldialog", TRUE )
{
	frame = new QGroupBox( caption, this );
	lineedit = new QLineEdit( this );
	lineedit->setText(urltext);

	this->setFocusPolicy( QWidget::StrongFocus );
	connect(lineedit, SIGNAL(returnPressed()), this, SLOT(accept()));

	ok = new QPushButton(i18n("OK"), this );
	cancel = new QPushButton(i18n("Cancel"), this ); 

	connect(cancel, SIGNAL(clicked()), this, SLOT(reject()));
	connect(ok, SIGNAL(clicked()), this, SLOT(accept()));
	resize(375, 120); 

}

void UrlDlg::resizeEvent(QResizeEvent *)
{
    frame->setGeometry(5, 5, width() - 10, 80);
    cancel->setGeometry(width() - 80, height() - 30, 70, 25);
    ok->setGeometry(10, height() - 30, 70, 25);
    lineedit->setGeometry(20, 35, width() - 40, 25);
}
#endif





void UrlDlg::focusInEvent( QFocusEvent *)
{
    lineedit->setFocus();

}

QString UrlDlg::getText()
{
	return lineedit->text();
}

#endif
