/***************************************************************************
                          knd_mon.cpp  -  description                              
                             -------------------                                         
    begin                : Thu Mar 25 14:26:46 GMT 1999
                                           
    copyright            : (C) 1999 by Mike Richardson                         
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include	"knd_view.h"

/*  KNDView								*/
/*  KNDView	: Constructor for view object				*/
/*  parent	: QWidget *	: Parent widget				*/
/*  slot	: int		: Slot in parent view list		*/
/*  base	: char *	: base of new name			*/
/*  appconf	: KConfig *	: Configuration or null			*/
/*  (returns)	: KNDView	:					*/

KNDView::KNDView
	(	KNDApp	*parent,
		int	slot,
		char	*base,
		KConfig	*appconf
	)
	:
	KTabCtl	(parent),
	parent	(parent),
	slot	(slot)
{
	if (appconf == NULL)
		sprintf	(name, "%s %d", base, slot) ;
	else	strcpy	(name, appconf->readEntry ("MonitorName", "NoName")) ;

	graphic = new KNDGraphic (this) ;
	packets	= new KNDPacket  (this) ;

	curtab	= 0	;
	onview	= true	;

	connect	(this, SIGNAL(tabSelected(int)), this, SLOT(tabSelect(int))) ;
}

/*  KNDView								*/
/*  ~KNDView	: Destructor for view object				*/
/*  (returns)	:		:					*/

KNDView::~KNDView ()
{
	delete	graphic ;
	delete	packets ;
}

/*  KNDView								*/
/*  setName	: Set monitor name					*/
/*  newname	: const char *	: New monitor name			*/
/*  (returns)	: void		:					*/

void	KNDView::setName
	(	const	char	*newname
	)
{
	parent->rename (name, newname) ;
	strcpy	(name, newname) ;
}

/*  KNDView								*/
/*  tabSelect	: Handle tab selection					*/
/*  tab		: int		: Selected tab				*/
/*  (returns)	: void		:					*/

void	KNDView::tabSelect
	(	int	tab
	)
{
	/* Note the selected tab and, depending on which, inform the	*/
	/* graphic and packet display objects whether they are on view	*/
	/* or not. This means that then can cease any display update	*/
	/* work when hidden, and hence save a potentially large amount	*/
	/* of CPU time.							*/
	switch (curtab = tab)
	{
		case 0 :
			graphic->setOnview (false) ;
			packets->setOnview (false) ;
			break ;

		case 1 :
			graphic->setOnview (true ) ;
			packets->setOnview (false) ;
			break ;

		case 2 :
			graphic->setOnview (false) ;
			packets->setOnview (true ) ;
			break ;
	}
}

/*  KNDView								*/
/*  setOnview	: Called to inform object whether it is on view		*/
/*  _onview	: bool		: TRUE if on view			*/
/*  (returns)	: void		:					*/

void	KNDView::setOnview
	(	bool	_onview
	)
{
	/* If this view is no longer on view then tell the graphic and	*/
	/* packet objects the same, so that thay can cease display	*/
	/* updates. However, if we are on view then call "tabSelect" to	*/
	/* inform which of them is on view.				*/
	if (!(onview = _onview))
	{
		graphic->setOnview (false) ;
		packets->setOnview (false) ;
	}
	else	tabSelect (curtab) ;
	
}

/*  KNDView								*/
/*  viewConfig	: View configuration tab				*/
/*  (returns)	: void		:					*/

void	KNDView::viewConfig ()
{
	showTab   (0) ;
	tabs->setCurrentTab (0) ;
	tabSelect (0) ;
}

/*  KNDView								*/
/*  viewConfig	: View graphic tab					*/
/*  (returns)	: void		:					*/

void	KNDView::viewGraphic ()
{
	showTab   (1) ;
	tabs->setCurrentTab (1) ;
	tabSelect (1) ;
}

/*  KNDView								*/
/*  viewConfig	: View packets tab					*/
/*  (returns)	: void		:					*/

void	KNDView::viewPackets ()
{
	showTab   (2) ;
	tabs->setCurrentTab (2) ;
	tabSelect (2) ;
}
