#ifndef	KSNUFFLEMULTI_H
#define	KSNUFFLEMULTI_H

#ifdef		HAVE_CONFIG_H
#include	<config.h>
#endif 

#include	<kapp.h>
#include	<qarray.h>
#include	<qlistbox.h>

#include	"ksnuffle.h"
#include	"knd_load.h"



class	QDragListBox : public QListBox
{
	Q_OBJECT	;

	KNDMulti  *parent	;
	int	  mouseDownAt	;
	int	  mouseUpAt	;

public	:
	QDragListBox (KNDMulti *) ;

protected :

	virtual	void	mousePressEvent   (QMouseEvent *) ;
	virtual	void	mouseReleaseEvent (QMouseEvent *) ;

signals :
	void	moved	(int, int) ;
}	;

/*  KNDClient							*/
/*  This class is used to handle the display of a histogram for	*/
/*  a particular monitor in the parallel graph display object.	*/

class	KNDClient : public QObject
{
	Q_OBJECT	;

	KNDMulti	*parent		;
	KNDLoadHist	*hist		;
	QLabel		label		;
	int		slot		;
	int	 	posn	  	;
	QString		name		;

public:
	KNDClient	(KNDMulti *, int, const char *) ;
       ~KNDClient	() ;

	void	setOrder  (int)	;
	void	setScale  (int)	;
	void	addPacket (PktInfo *) ;
	int	timerTick (long);
	void	repaint	  ()	;

	inline	const	char	*getName ()
	{
		return	name ;
	}	;

private slots :

	void	doubleClick () ;
}	;

/*  KNDMulti							*/
/*  This is the class that displays serveral load histograms	*/
/*  at once on the same display page.				*/

class	KNDMulti : public QWidget
{
	Q_OBJECT

	KNDApp			*parent	;
	QLabel			period	;
	QLabel			scale	;

	QArray<KNDClient *>	clients	;
	QList <KNDClient  >	ondisp	;
	QDragListBox		order	;

	bool			onview	;
	int			sccurr	;
	int			scdown	;

	void	rePlace	  () ;

public:

	KNDMulti (KNDApp *parent) ;
       ~KNDMulti () ;

	void	Register  (int, const char *) ;
	void	unRegister(int) ;
	void	showClient(int)	;

	void	addPacket (PktInfo *, int) ;

	void	timerTick (long) ;
	void	setOnview (bool) ;
	void	paint	  ()	 ;

protected slots :

	void	selected  (int)	 ;
	void	reOrder	  (int, int) ;
}	;

#endif	// KSNUFFLEMULTI_H
