/***************************************************************************
                          knd_confmon.h  -  description                              
                             -------------------                                         
    begin                : Thu Mar 25 14:26:46 GMT 1999
                                           
    copyright            : (C) 1999 by Mike Richardson                         
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef		KSNUFFLECONFMON_H 
#define		KSNUFFLECONFMON_H 

#ifdef		HAVE_CONFIG_H
#include	<config.h>
#endif 

#include	<kapp.h>
#include	<kfiledialog.h>
#include	<qpushbutton.h>
#include	<qlabel.h>
#include	<qlineedit.h>
#include	<qcombobox.h>
#include	<qcheckbox.h>
#include	<qgroupbox.h>
#include	<qspinbox.h>
#include	<qtooltip.h>

#include	"ksnuffle.h"
#include	"knd_view.h"
#include	"knd_mon.h"
#include	"knd_multi.h"
#include	"knd_pcap.h"
#include	"knd_gra.h"
#include	"knd_pkt.h"
#include	"knd_config.h"

enum	LogMode
{	LogNone		= 0,
	LogRecordText	= 1,
	LogRecordBin	= 2
}	;

enum	HostMode
{	Host		= 0,
	Srce		= 1,
	Dest		= 2
}	;

enum	JoinMode
{	And		= 0,
	Or		= 1
}	;

class	KNDConfMon : public KNDConf
{
	Q_OBJECT

	KNDPCap		*capture	;

	QCheckBox	c_prog		;

	QLabel		l_if		;
	QComboBox	s_if		;
	QLabel		l_proto		;
	QComboBox	s_epro		;
	QComboBox	s_ipro		;
	QComboBox	s_host1		;
	QLineEdit	t_host1		;
	QComboBox	s_port1		;
	QComboBox	s_host2		;
	QLineEdit	t_host2		;
	QComboBox	s_port2		;
	QComboBox	s_andor		;
	QLineEdit	t_prog		;
	HostMode	m_host1		;
	HostMode	m_host2		;
	JoinMode	m_andor		;

	QLineEdit	t_logt		;
	QLineEdit	t_logb		;
	QComboBox	s_log		;
	LogMode		m_log		;

	QString		v_if		;
	QString		v_epro		;
	QString		v_ipro		;
	QString		v_host1		;
	QString		v_host2		;
	QString		v_port1		;
	QString		v_port2		;
	QString		v_prog		;
	bool		v_andor		;

	bool		b_prog		;
	QString		v_logt		;
	QString		v_logb		;

	void		halt 	() ;
	void		addHost	(QString &, HostMode, QString &, QString &) ;

public	:
	KNDConfMon  (KNDView        *,
		     KNDPCap        *,
		     KNDGraphic	    *,
		     KNDPacket	    *,
		     KNDMulti	    *,
		     int	     ,
		     char	    *,
		     QArray<char *> *,
		     QArray<char *> *,
		     QArray<char *> *,
		     QArray<char *> *,
		     KConfig	    *) ;

virtual	~KNDConfMon ()		;

	void	writeConfig	(KConfig *) ;
	void	monitorStop	() ;
	void	monitorStart	() ;
	void	monitorFreeze	() ;
	void	monitorResume	() ;

private slots :

	virtual	void	clickSet    () ;
	virtual	void	clickReset  () ;
	virtual	void	clickClear  () ;
	virtual	void	clickGo     () ;
	virtual	void	clickFreeze () ;
	virtual	void	clickLog    () ;

	void	clickProg   (bool) ;
	void	deltaLog    (int ) ;
	void	deltaEProto (int ) ;

private	:

}	;

#endif	// KSNUFFLECONFMON_H 
