/***

serv.c  - TCP/UDP port statistics module
Written by Gerard Paul Java
Copyright (c) Gerard Paul Java 1997, 1998

This software is open source; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License in the included COPYING file for
details.

***/

#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <netdb.h>
#include <signal.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/udp.h>
#include <linux/if_packet.h>
#include <linux/if_ether.h>

#include <qobject.h>
#include <kmsgbox.h>
#include "kportstats.moc"
#include "kfilter.h"

#include "tcphdr.h"
#include "dirs.h"
#include "ipcsum.h"
#include "packet.h"
#include "ipfrag.h"
#include "ifaces.h"
#include "attrs.h"
#include "servname.h"
#include "log.h"
#include "options.h"
#include "instances.h"
#include "packet.h"
#include "logvars.h"



#define SCROLLUP 0
#define SCROLLDOWN 1

extern void writeutslog(struct portlistent *list, unsigned long nsecs, FILE * logfile);


IpPortStats::IpPortStats(QWidget *parent, char *iface,  struct OPTIONS *appoptions)
{
  QRect parentrect;
  parentrect = parent->geometry();
//  this->setGeometry(parentrect.left(), parentrect.top(),300, 300 );
//  optionsmodalparent = parent;

  logging = appoptions->logging;
  starttime = 0;
  statbegin = 0;
  now = 0;
  unow = 0;
  startlog = 0;

  updtime_usec = 0;
  sport = 0;
  dport = 0;
  ports = NULL;

  options = appoptions;

//  options.promisc = appoptions->promisc;
//  options.actmode = appoptions->actmode;
//  options.servnames = appoptions->servnames;

  tmpstr = new QString();
  qstrcpy((char*) &ifname, iface);

  portcol.numcols=1;
  portcol.pkts=0;
  portcol.bytes=0;
  portcol.pkts_to=0;
  portcol.bytes_to=0;
  portcol.pkts_from=0;
  portcol.bytes_from=0;

  mylistview = new QListView(parent, "PortListView");
  mylistview->setGeometry(0,56,480,240);
  //mylistview->setGeometry(parentrect);
  mylistview->addColumn("Proto/Port",-1);
  mylistview->setColumnWidth(0,70);
  
  if (options->portopts.pkts)
    {
      mylistview->addColumn("Pkts",-1);
      portcol.pkts=portcol.numcols;
      mylistview->setColumnWidth(portcol.pkts,60);
      portcol.numcols++;
    }

  if (options->portopts.bytes)
    {
      mylistview->addColumn("Bytes",-1);
      portcol.bytes=portcol.numcols;
      mylistview->setColumnWidth(portcol.bytes,80);
      portcol.numcols++;
    }

  if (options->portopts.pkts_to)
    {
      mylistview->addColumn("Pkts to",-1);
      portcol.pkts_to = portcol.numcols;
      mylistview->setColumnWidth(portcol.pkts_to,60);
      portcol.numcols++;
    }
  if (options->portopts.bytes_to)
    {
      mylistview->addColumn("Bytes to",-1);
      portcol.bytes_to = portcol.numcols;
      mylistview->setColumnWidth(portcol.bytes_to,75);
      portcol.numcols++;
    }
  if (options->portopts.pkts_from)
    {
      mylistview->addColumn("Pkts from",-1);
      portcol.pkts_from = portcol.numcols;
      mylistview->setColumnWidth(portcol.pkts_from,60);
      portcol.numcols++;
    }
  if (options->portopts.bytes_from)
    {
      mylistview->addColumn("Bytes from",-1);
      portcol.bytes_from = portcol.numcols;
      mylistview->setColumnWidth(portcol.bytes_from,75);  
      portcol.numcols++;
    }
  if (options->portopts.activity)
    {
      mylistview->addColumn("Activity",-1);
      portcol.activity = portcol.numcols;
      mylistview->setColumnWidth(portcol.activity,120);  
    }

  mylistview->setColumnWidthMode(1,QListView::Maximum);
  mylistview->setAllColumnsShowFocus(1);
  mylistview->setSorting(-1, FALSE);
  mylistview->show();

  /*
   * Mark this facility
  if (!facility_active(TCPUDPIDFILE))
      mark_facility(TCPUDPIDFILE, "TCP/UDP monitor");
  else {
      errbox("TCP/UDP monitor already active in another process", ANYKEY_MSG, &ch);
      return;
  }
  */         

  if (!iface_supported(ifname)) {
     fprintf(stderr, "Interface Not Supported\n");
    //  err_iface_unsupported();
    //  unlink(TCPUDPIDFILE);
      return;
  }
 
  if (!loadaddports(&ports))      
   {
     KMsgBox *mybox;
     mybox = new KMsgBox(this, "Error", "Error reading Port list.  It must be corrupt.  Please delete it! ~/.kde/share/config/ksnifferrc.ports", 2,"ok",0,0,0);
     mybox->show();
     delete(mybox);
   }
  initportlist(&list);

  if (options->servnames)
    setservent(1);
/*
  if (logging) {
    opentlog(&logfile, TCPUDPLOG);

    if (logfile == NULL)
    logging = 0;
  }
    
  if (logging)
    signal(SIGUSR1, rotate_serv_log);
        
  rotate_flag = 0;
  writelog(logging, logfile, "******** TCP/UDP service monitor started");
*/

  open_socket(&fd);

  if (fd < 0)
    return;

  //bzero(&isdntable, sizeof(struct isdntab));
    
  gettimeofday(&tv, NULL);
  starttime = startlog = timeint = tv.tv_sec;

  mycallback = new QSocketNotifier(fd, QSocketNotifier::Read);
  connect(mycallback, SIGNAL(activated(int)), SLOT(dataReceived(int)));

  tempstr = new QString();

  if (options->portopts.activity)
    {
      mytimer = new QTimer(this, "Port Stats Timer");
      connect( mytimer, SIGNAL(timeout()), SLOT(timerDone()) );
      mytimer->start( 1000, FALSE );                 // 2 seconds single-shot 
    }

}


IpPortStats::~IpPortStats()
{
  if (mytimer !=NULL)
    delete (mytimer);
  delete(tempstr);
  destroyportlist(&list);
  destroyporttab(ports);
  destroyfraglist();
  //destroy_isdn_table(&isdntable);
  delete(mycallback);
  delete(mylistview);
  delete(tmpstr);
}

void
IpPortStats::updateOptions(struct OPTIONS *appoptions)
{
// options.promisc = appoptions->promisc;
// options.actmode = appoptions->actmode;
// options.servnames = appoptions->servnames;
}


void
IpPortStats::dataReceived(int fd)
{
  char buf[8192];
  char aligned_buf[120];   
  char *ipacket;
  char *tpacket;
  unsigned int iphlen;
  struct sockaddr_pkt fromaddr;
  unsigned short linktype;
  unsigned int idx = 1;

  getpacket(fd, buf, &fromaddr, &ch, &br);


  if (br > 0) {
    if ((fromaddr.spkt_protocol == ntohs(ETH_P_IP)) &&
       ((strcmp(fromaddr.spkt_device, ifname) == 0))) {
        
  //      isdn_iface_check(&isdn_fd, fromaddr.spkt_device);
        linktype = getlinktype(fromaddr.spkt_family, fromaddr.spkt_device);
	        
	adjustpacket(buf, linktype, &ipacket, aligned_buf, &br);

	if (ipacket == NULL)
	    return;

	iphlen = ((struct iphdr *) ipacket)->ihl * 4;
	ck = ((struct iphdr *) ipacket)->check;
	((struct iphdr *) ipacket)->check = 0;
	csum = in_cksum((u_short *) ipacket, iphlen);

	if (ck != csum)
	    return;

	/*
	 * if not first fragment of a datagram, pass it to
	 * the fragment processor and get the ports from there.
	 */

	if ((ntohs(((struct iphdr *) ipacket)->frag_off) & 0x3fff) != 0) {
	    br = processfragment((struct iphdr *) ipacket, &sport, &dport, &firstin);
	    if (!firstin)
		return;
	} else {
	    tpacket = ipacket + iphlen;

	    if (((struct iphdr *) ipacket)->protocol == IPPROTO_TCP) {
	        sport = ntohs(((struct tcphdr *) tpacket)->source);
	        dport = ntohs(((struct tcphdr *) tpacket)->dest);
	    } else if (((struct iphdr *) ipacket)->protocol == IPPROTO_UDP) {
	        sport = ntohs(((struct udphdr *) tpacket)->source);
	        dport = ntohs(((struct udphdr *) tpacket)->dest);
	    }
	}
		
	if ((((struct iphdr *) ipacket)->protocol == IPPROTO_TCP) ||
	 (((struct iphdr *) ipacket)->protocol == IPPROTO_UDP)) {
	    printport(&list, ((struct iphdr *) ipacket)->protocol,
	       sport, ntohs(((struct iphdr *) ipacket)->tot_len),
		      idx, 0, ports, options->servnames);
	    printport(&list, ((struct iphdr *) ipacket)->protocol,
	       dport, ntohs(((struct iphdr *) ipacket)->tot_len),
		      idx, 1, ports, options->servnames);
	}
    }
}

  gettimeofday(&tv, NULL);
  now = tv.tv_sec;
  unow = tv.tv_sec * 1e+6 + tv.tv_usec;

  if (now - timeint >= 5) {
//    printelapsedtime(starttime, now, LINES - 3, 20, list.borderwin);
    timeint = now;
  }

  if (((now - startlog) >= options->logspan) && (logging)) {
//    writeutslog(list.head, now - starttime, logfile);
    startlog = now;
  }

  if (((options->updrate != 0) && (now - updtime >= options->updrate)) ||
    ((options->updrate == 0) && (unow - updtime_usec >= DEFAULT_UPDATE_DELAY))) {
    updtime = now;
    updtime_usec = unow;
}
	
  //check_rotate_flag(&logfile, logging);
	
/*   if (logging) {
        signal(SIGUSR1, SIG_DFL);
	writeutslog(list.head, time((time_t *) NULL) - starttime, logfile);
	writelog(logging, logfile, "******** TCP/UDP service monitor stopped");
	fclose(logfile);
    }
*/
    if (options->servnames)
	endservent();
}

void
IpPortStats::timerDone()
{
  struct portlistent *ptmp = NULL;
  float rate=0.0;

  gettimeofday(&tv, NULL);
  now = tv.tv_sec;
  unow = tv.tv_sec * 1e+6 + tv.tv_usec;

  ptmp = list.head;
  
  while (ptmp!=NULL)    		//Make sure list isn't empty
    {
      if (options->actmode == KBITS) {
          rate = ((float) (ptmp->spanbr * 8 / 1000)) / ((float) (now - ptmp->starttime));
          tempstr->sprintf("%2.2f kbits/sec",rate);
    } else {
          rate = ((float) (ptmp->spanbr / 1024)) / ((float) (now - ptmp->starttime));
          tempstr->sprintf("%2.2f kbytes/sec",rate);
    }

    ptmp->listviewitem->setText(portcol.activity,tempstr->data()); 
    ptmp->starttime = now;
    ptmp->spanbr = 0;

    ptmp = ptmp->next_entry;
    }
}



/*
 * SIGUSR1 logfile rotation signal handler
void rotate_serv_log()
{
    rotate_flag = 1;
    strcpy(target_logname, TCPUDPLOG);
    signal(SIGUSR1, rotate_serv_log);
}
*/

void 
IpPortStats::initportlist(struct portlist *list)
{
    list->head = list->tail = NULL;
    list->firstvisible = list->lastvisible = NULL;
    list->count = 0;
}



struct portlistent *
IpPortStats::addtoportlist(struct portlist *list, unsigned int protocol,
			    unsigned int port, int *nomem, int servnames)
{
    struct portlistent *ptemp;

    ptemp = (struct portlistent *)malloc(sizeof(struct portlistent));

    if (ptemp == NULL) {
//	printnomem();
        fprintf(stderr,"NO MORE MEMORY\n");
	*nomem = 1;
	return NULL;
    }
    if (list->head == NULL) {
	ptemp->prev_entry = NULL;
	list->head = ptemp;
	list->firstvisible = ptemp;
    }
    if (list->tail != NULL) {
	list->tail->next_entry = ptemp;
	ptemp->prev_entry = list->tail;
    }
    list->tail = ptemp;
    ptemp->next_entry = NULL;

    ptemp->protocol = protocol;
    ptemp->port = port;		/* This is used in checks later. */

    /* 
     * Obtain appropriate service name
     */

    servlook(servnames, htons(port), protocol, ptemp->servname, 10);

    ptemp->count = ptemp->bcount = 0;
    ptemp->icount = ptemp->ibcount = 0;
    ptemp->ocount = ptemp->obcount = 0;

    list->count++;
    ptemp->idx = list->count;
    switch (portcol.numcols) {
      case 1:
         ptemp->listviewitem = new QListViewItem(mylistview, ptemp->servname);
         break;

      case 2:
         ptemp->listviewitem = new QListViewItem(mylistview, ptemp->servname, "0");
         break;

      case 3:
         ptemp->listviewitem = new QListViewItem(mylistview, ptemp->servname, "0", "0");
         break;

      case 4:
         ptemp->listviewitem = new QListViewItem(mylistview, ptemp->servname, "0", "0", "0");
         break;

      case 5:
         ptemp->listviewitem = new QListViewItem(mylistview, ptemp->servname, "0", "0", "0", "0");
         break;

      case 6:
         ptemp->listviewitem = new QListViewItem(mylistview, ptemp->servname, "0", "0", "0", "0", "0");
         break;

      case 7:
         ptemp->listviewitem = new QListViewItem(mylistview, ptemp->servname, "0", "0", "0", "0", "0", "0");
         break;

     default:
         break;
    }

    return ptemp;
}

int
IpPortStats::portinlist(struct porttab *table, unsigned int port)
{
    struct porttab *ptmp = table;

    while (ptmp != NULL) {
	if (((ptmp->port_max == 0) && (ptmp->port_min == port)) ||
	   ((port >= ptmp->port_min) && (port <= ptmp->port_max)))
	    return 1;

	ptmp = ptmp->next_entry;
    }

    return 0;
}

int 
IpPortStats::goodport(unsigned int port, struct porttab *table)
{
    return ((port < 1024) || (portinlist(table, port)));
}

struct portlistent *
IpPortStats::inportlist(struct portlist *list,
			       unsigned int protocol, unsigned int port)
{
    struct portlistent *ptmp = list->head;

    while (ptmp != NULL) {
	if ((ptmp->port == port) && (ptmp->protocol == protocol))
	    return ptmp;

	ptmp = ptmp->next_entry;
    }

    return NULL;
}


void
IpPortStats::printportent(struct portlist *list, struct portlistent *entry,
		  unsigned int idx)
{
    if (portcol.pkts)
      {
        tmpstr->setNum(entry->count);
        entry->listviewitem->setText(portcol.pkts,tmpstr->data()); 
      }
    if (portcol.bytes)
      {
        tmpstr->setNum(entry->bcount);
        entry->listviewitem->setText(portcol.bytes,tmpstr->data()); 
      }
    if (portcol.pkts_to)
      {
        tmpstr->setNum(entry->icount);
        entry->listviewitem->setText(portcol.pkts_to,tmpstr->data()); 
      }
    if (portcol.bytes_to)
      {
        tmpstr->setNum(entry->ibcount);
        entry->listviewitem->setText(portcol.bytes_to,tmpstr->data()); 
      }
 
    if (portcol.pkts_from)
      {
        tmpstr->setNum(entry->ocount);
        entry->listviewitem->setText(portcol.pkts_from,tmpstr->data()); 
      }
  
    if (portcol.bytes_from)
      {
        tmpstr->setNum(entry->obcount);
        entry->listviewitem->setText(portcol.bytes_from,tmpstr->data()); 
      }
   
}


void destroyportlist(struct portlist *list)
{
    struct portlistent *ptmp = list->head;
    struct portlistent *ctmp = NULL;

    if (list->head != NULL)
	ctmp = list->head->next_entry;

    while (ptmp != NULL) {
	free(ptmp);
	ptmp = ctmp;

	if (ctmp != NULL)
	    ctmp = ctmp->next_entry;
    }
}


void
IpPortStats::printport(struct portlist *list, unsigned int protocol,
             unsigned int port, int br, unsigned int idx, int fromto,
             struct porttab *ports, int servnames)
{
    struct portlistent *listent;
    int nomem = 0;

    if (goodport(port, ports)) {
	listent = inportlist(list, protocol, port);

	if ((listent == NULL) && (!nomem))
	    listent = addtoportlist(list, protocol, port, &nomem, servnames);

	if (listent == NULL)
	    return;

	listent->count++;
	listent->bcount += br;
	listent->spanbr += br;

	if (fromto == 0) {	/* from */
	    listent->obcount += br;
	    listent->ocount++;
	} else {		/* to */
	    listent->ibcount += br;
	    listent->icount++;
	}

	printportent(list, listent, idx);
    }
}

int loadaddports(struct porttab **table)
{
    int fd;
    struct porttab *ptemp;
    struct porttab *tail = NULL;
    int br;

    *table = NULL;

    fd = open(PORTS_FILE, O_RDONLY);
    if (fd < 0)
	return 1;

    do {
	ptemp = (struct porttab *)malloc(sizeof(struct porttab));

	br = read(fd, &(ptemp->port_min), sizeof(unsigned int));
	br = read(fd, &(ptemp->port_max), sizeof(unsigned int));

	if (br < 0) {
//	    errbox("Error reading port list", ANYKEY_MSG, &resp);
//	    close(fd);
fprintf(stderr, "port list is corrupt\n");
fflush(stderr);
	    destroyporttab(*table);
	    return 0;
	}
	if (br > 0) {
	    if (*table == NULL) {
		*table = ptemp;
		ptemp->prev_entry = NULL;
	    }
	    if (tail != NULL) {
		tail->next_entry = ptemp;
		ptemp->prev_entry = tail;
	    }
	    tail = ptemp;
	    ptemp->next_entry = NULL;
	} else
         {
	    free(ptemp);
         }

    } while (br > 0);

    close(fd);
  return 1;
}

void destroyporttab(struct porttab *table)
{
    struct porttab *ptemp = table;
    struct porttab *ctemp = NULL;

    if (ptemp != NULL)
	ctemp = ptemp->next_entry;

    while (ptemp != NULL) {
	free(ptemp);
	ptemp = ctemp;

	if (ctemp != NULL)
	    ctemp = ctemp->next_entry;
    }
}
