#ifndef _KFLISTBASE_H_
#define _KFLISTBASE_H_

#include <qdir.h>
#include <qstring.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qlist.h>
#include "kfiled.h"
#include <qtableview.h>
#include <qdropsite.h>
#include <qdragobject.h>
#include <qtooltip.h>
#include <qpoint.h>
#include "fileinfo.h"

class KFileListBase;
enum StateType {
	FILEVIEW_NORMAL = 0x00,
	FILEVIEW_CANDRAG = 0x01,
	FILEVIEW_DRAGGING = 0x02,
	FILEVIEW_DORECTANGLE = 0x04,
	FILEVIEW_CANEDIT = 0x08,
	FILEVIEW_EDITING = 0x10,
};

class KFileListToolTip : public QToolTip
{
public:
	KFileListToolTip(QWidget *parent = 0);
protected:
	virtual void maybeTip(const QPoint& pos);
};

class KFileListBase : public QTableView, public QDropSite
{
	Q_OBJECT;

friend class KFileListToolTip;

public:
	KFileListBase(QWidget *parent = 0, const char *name = 0, WFlags f = 0);
	~KFileListBase();
	virtual void setFileList(FileInfoList *list, bool keepSel = FALSE);
	virtual void clearList();
	void setLinkArrow(QPixmap *larrow);
	void setDNDIcon(QPixmap *dndicon);
	FileInfoList* getSelected() { return Selected;}
	void selectAll();
	void setSelection(FileInfoList& list);
	void updateSelection();
	void startRenaming(FileInfo *item);

/*	void setUrl(const char *url);
	const char* url();
	int style() { return Style;}
	void setStyle(int st) { Style = st;}*/

signals:
	void renameItem(FileInfo *, const QString&);
	void openItem(FileInfo *);
	void changeSorting(QDir::SortSpec);
	void selectionChanged();
	void popup();
	void selected(KFileListBase *);
	void dropAccepted(QDropEvent*,FileInfo*);
	void backspacePressed();

protected:
	virtual void updateListSize() = 0;
	void mousePressEvent(QMouseEvent *);
	void mouseMoveEvent(QMouseEvent *);
	void mouseReleaseEvent(QMouseEvent *);
	void focusInEvent(QFocusEvent *);
	void focusOutEvent(QFocusEvent *);
	void keyPressEvent(QKeyEvent *e);
	virtual void mouseDoubleClickEvent(QMouseEvent *e);
	virtual void getTablePosition(int index, int& row, int& col) = 0;
	virtual bool getItemCell(int row, int col, FileInfo **item, QPoint p) = 0;
	virtual QRect getItemTextRect(FileInfo *item) = 0;
	virtual FileInfo* getNextItem(FileInfo *current, int code) = 0;
	virtual void scroll(FileInfo *item);
	void addToSelection(FileInfo *item);
	void removeFromSelection(FileInfo *item);
	void removeSelection();

	void dragEnterEvent(QDragEnterEvent *);
	void dragMoveEvent(QDragMoveEvent *);
	void dragLeaveEvent(QDragLeaveEvent *);
	void dropEvent(QDropEvent *);

	bool getItem(const QPoint& p, FileInfo **item);
	virtual void updateItem(FileInfo *item);
	virtual QRect tip(const QPoint& pos, QString& str);
	void drawFancyRect();
	virtual QRect getItemRect(FileInfo *item) = 0;

public slots:
	void cancelEdit();
	void terminateEdit();

protected:
	FileInfoList		*FileList;
	QPixmap			*LinkArrow;
	QPixmap			*DNDIcon;
	FileInfoList		*Selected;
	KFileEdit		*Edit;
//	bool			Editing;
	FileInfo		*CellEdited;
	FileInfo		*ItemClicked;
//	bool			canDrag;
//	bool			dragging;
	int			press_x, press_y;
	FileInfo		*TargetItem;
	bool			pressed;
	KFileListToolTip	*ToolTip;
//	bool			doRectangle;
	QPoint			anchorPoint;
	QRect			anchorRect;
	StateType		state;
};

QString getTruncatedString(const QString& str, QPainter *p, int w);

/*inline void KFileListBase::setUrl(const char *url)
{ Url = url;}

inline const char* KFileListBase::url()
{ return Url.data();}*/

#endif
