#include <iostream.h>
#include <time.h>
#include "kexplorer.h"
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qtoolbutton.h>
#include <qtoolbar.h>
#include <qmessagebox.h>
#include <qcursor.h>
#include <qdir.h>
#include <qdragobject.h>
#include <qtextstream.h>
#include <qkeycode.h>
#include <kstdaccel.h>
#include <kprocess.h>
#include "PropertyDlg.h"
#include "DeviceDlg.h"
#include "DeviceDelDlg.h"
#include "LineDlg.h"
#include "OpenDlg.h"
#include "bookmark.h"
#include "trashprot.h"
#include "smb.h"
#include "mystrlist.h"

// OLE
#include <kimgio.h>
#include <dither.h>
// OLE

#define APPLICATION(a,n)	SLOT(a)#n"()"

static QString	pathString;
#define	DESKTOP	pathString.sprintf("%s/",i18n("Desktop"))
#define	DESKTOP_SYSTEM	pathString.sprintf("%s/%s/",i18n("Desktop"),i18n("System"))
#define	DESKTOP_NETWORK	pathString.sprintf("%s/%s/",i18n("Desktop"),i18n("Network"))
#define	DESKTOP_NETWORKNEIGHBORHOOD	pathString.sprintf("%s/%s/",i18n("Desktop"),i18n("Network neighborhood"))

KMimeAppDict	*ApplicationNameDict;

QString getTime()
{
	const long int	timeval = time(0);
	QString		tmp = ctime(&timeval);
	int	pos = tmp.find(' ')+1;
	int	pos2 = tmp.find(' ',pos+1);
	pos2 = tmp.find(' ',pos2+1);
	pos2 = tmp.find(':',pos2+1);
	pos2 = tmp.find(':',pos2+1);
	QString	retval = tmp.mid(pos,pos2-pos);
	return retval;
}

// replaces all occurences of ~, $HOME, ...
void processPath(QString& path)
{
	int	pos = path.find('~');
	if (pos != -1) path.replace(pos,1,getenv("HOME"));
	while ((pos = path.find('$')) != -1) {
		int	pos2(pos+1);
		while (pos2 < (int)(path.length()) && (isalnum(path[pos2]) || path[pos2] == '_')) pos2++;
		QString		var = path.mid(pos+1,pos2-pos-1);
		path.replace(pos,pos2-pos,getenv(var.data()));
	}
	while ((pos = path.find("//")) != -1) path.replace(pos,2,"/");
}

bool containDirs(QStrList& list)
{
	QStrListIterator	it(list);
	for (;it.current();++it) if (QString(it.current()).right(1) == "/") return TRUE;
	return FALSE;
}

FileWindow* getWindow(FileViewWidget *wnd, FileWindowList *list)
{
	FileWindowListIterator	it(*list);
	for (;it.current();++it) if (it.current()->FileView == wnd) return it.current();
	return 0;
}

FileWindow* getWindow(KMDIWindow *wnd, FileWindowList *list)
{
	FileWindowListIterator	it(*list);
	for (;it.current();++it) if (it.current()->Window == wnd) return it.current();
	return 0;
}

void constructListMenu(QPopupMenu *m, bool remove = true, bool extend = true)
{
	if (remove) m->clear();
	m->setCheckable(TRUE);
	m->insertItem(i18n("by name"),LISTNAME_ID);
	m->insertItem(i18n("by size"),LISTSIZE_ID);
	m->insertItem(i18n("by type"),LISTTYPE_ID);
	m->insertItem(i18n("by date"),LISTDATE_ID);
	if (extend) {
		m->insertItem(i18n("by permissions"),LISTPERM_ID);
		m->insertItem(i18n("by user"),LISTUSER_ID);
		m->insertItem(i18n("by group"),LISTGROUP_ID);
		m->insertItem(i18n("by access date"),LISTACCESS_ID);
		m->insertItem(i18n("by device"),LISTDEVICE_ID);
		m->insertItem(i18n("by mode"),LISTMODE_ID);
		m->insertItem(i18n("by group ID"),LISTGID_ID);
		m->insertItem(i18n("by user ID"),LISTUID_ID);
		m->insertItem(i18n("by size (raw)"),LISTSIZE2_ID);
		m->insertItem(i18n("by blocks"),LISTBLOCKS_ID);
		m->insertItem(i18n("by nLinks"),LISTNLINKS_ID);
		m->insertItem(i18n("by creation date"),LISTCREATE_ID);
	}
}

void initKruiserDir()
{
	QString		path(KApplication::localkdedir().data());
	char	*args[4] = {"/share","/apps","/kruiser","/mnt"};
	for (int i=0;i<4;i++) {
		path += args[i];
		if (::access(path.data(),F_OK) != 0) ::mkdir(path.data(),0755);
	}
}

//----------------------------------------------------------------------------------------------

void KExplorer::initBusy()
{
	if (!Busy) {
		QList<QObject>		list;
		list.append((QObject*)(ToolBar->getButton(ABORT_ID)));
		list.append((QObject*)Manager->progress());
		setGlobalFilter(this,true,&list);
		ToolBar->setItemEnabled(ABORT_ID,TRUE);
		Busy = TRUE;
	}
}

void KExplorer::finishBusy()
{
	if (Busy) {
		QList<QObject>		list;
		list.append((QObject*)ToolBar->getButton(ABORT_ID));
		list.append((QObject*)Manager->progress());
		setGlobalFilter(this,false,&list);
		ToolBar->setItemEnabled(ABORT_ID,FALSE);
		Busy = FALSE;
	}
}

KExplorer::KExplorer(QWidget *parent, const char *name, WFlags f)
	: KTMainWindow(name)
{
	KOptions = new KExplorer_options;
	HistoryList.setAutoDelete(true);
	BookmarkList.setAutoDelete(true);
	BookmarkToolList.setAutoDelete(true);
	BookmarkAccel = new QAccel(this);
	connect(BookmarkAccel,SIGNAL(activated(int)),SLOT(menuActivated(int)));
	initKruiserDir();
	loadConfiguration();
	IconLoader = new KPIconLoader(KOptions->IconPath,KOptions->UseKDEIcons);
// OLE
// this enables QPixmap::load/write to handle xv-thumbnails;
	kimgioRegister();
// OLE
	Busy = FALSE;
	Manager = new ProtocolMgr(this);
	connect(Manager,SIGNAL(message(const char*)),SLOT(message1(const char*)));
	connect(Manager,SIGNAL(protocolClosed(Protocol*)),SLOT(protocolClosed(Protocol*)));
	DeviceList.setAutoDelete(TRUE);
	WindowList = new FileWindowList;
	WindowList->setAutoDelete(TRUE);
	MenuBar = menuBar();
	StatusBar = statusBar();
	MainView = new KSplitter(this);
	setView(MainView);
	LeftView = new KFixPanner(MainView,KFixPanner::Horizontal);
	MainRightView = new KSplitter(KSplitter::Vertical,MainView);
	Preview = 0;
	LeftViewInfo = new QLabel(i18n("All files"),LeftView);
	LeftViewInfo->resize(100,18);
	LeftViewInfo->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	LeftViewInfo->setLineWidth(1);
	DirectoryTree = new DirView(LeftView);
	DirectoryTree->setMouseTracking(KOptions->TrackingEnabled);
	LeftView->activate(LeftViewInfo,DirectoryTree);
	setupToolBar();
	setupMenu();
	RightSubView = new KSplitter(MainRightView);
	OldWindow = 0;
	if (KOptions->MultipleView) {
		MDIMgr = new KMDIMgrBase(RightSubView);
		connect(MDIMgr,SIGNAL(popup()),SLOT(popupMDI()));
		MDIMgr->setAutoTile(KOptions->AutoTile);
		for (int i=0;i<KOptions->WindowsCount;i++) createWindow(KOptions->Style);
	}
	else {
		FileView = createFileView(KOptions->Style);
		WindowList->append(new FileWindow(FileView,KOptions->Style));
		WindowList->last()->Sorting = KOptions->Sorting;
		if (KOptions->ViewType != SINGLE_ID) {
			RightSubView->setOrientation((KOptions->ViewType == SPLITV_ID ? KSplitter::Vertical : KSplitter::Horizontal));
			WindowList->append(new FileWindow(createFileView(KOptions->Style),KOptions->Style));
			WindowList->last()->Sorting = KOptions->Sorting;
		}
	}
//	RightView->activate(RightViewInfo,RightSubView);
	DirectoryTree->setRootLabel(i18n("Desktop"));
	DirectoryTree->setRootIcon(IconLoader->loadMiniIcon("desktop.xpm"));
	DirectoryTree->setModifierPixmap(DirLink,IconLoader->loadMiniIcon("link.xpm"));
	DirectoryTree->setModifierPixmap(DirMount,IconLoader->loadMiniIcon("mount.xpm"));
	DirectoryTree->setDNDIcon(IconLoader->loadMiniIcon("dndicon.xpm","unknown.xpm"));
	Status1Info = new QLabel(StatusBar);
	Status1Info->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	Status1Info->setLineWidth(1);
	StatusBar->insertWidget(Status1Info,200,STATUS1_ID);
	Status2Info = new QLabel(StatusBar);
	Status2Info->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	Status2Info->setLineWidth(1);
	StatusBar->insertWidget(Status2Info,400,STATUS2_ID);
	if (KOptions->StatusBarEnabled) enableStatusBar(KStatusBar::Show);
	else enableStatusBar(KStatusBar::Hide);
	ApplicationList = new KMimeAppList;
	ApplicationList->setAutoDelete(TRUE);
	ApplicationDict = new KMimeAppDict;
	ApplicationDict->setAutoDelete(FALSE);
	ExtensionList = new KMimeExtList;
	ExtensionList->setAutoDelete(TRUE);
	ExtensionDict = new KMimeExtDict;
	ExtensionDict->setAutoDelete(FALSE);
	FilenameDict = new KMimeExtList;
	FilenameDict->setAutoDelete(FALSE);
	Magic = new MimeMagic();
	Manager->setupMime(ExtensionDict,FilenameDict,Magic,KOptions->UseMagicNumbers);
	Manager->setupSubProtList(ProtList);
	loadDevices();

	connect(DirectoryTree,SIGNAL(selectionChanged(DirViewItem*)),SLOT(scanDirectory(DirViewItem*)));
	connect(DirectoryTree,SIGNAL(requestItemChilds(DirViewItem*)),SLOT(scanSubDirectories(DirViewItem*)));
	connect(DirectoryTree,SIGNAL(rightButtonPressed(DirViewItem*)),SLOT(popupDirectoryTree(DirViewItem*)));
	connect(DirectoryTree,SIGNAL(dropAccepted(QDropEvent*,DirViewItem*)),SLOT(dropOnTree(QDropEvent*,DirViewItem*)));
	connect(DirectoryTree,SIGNAL(updateHasChilds(DirViewItem*)),SLOT(updateHasChilds(DirViewItem*)));

	Pop1 = new QPopupMenu();
	Pop2 = new QPopupMenu();
	connect(Pop1,SIGNAL(activated(int)),SLOT(menuActivated(int)));
	connect(Pop2,SIGNAL(activated(int)),SLOT(menuActivated(int)));
	Pop3 = new QPopupMenu();
	Pop4 = new QPopupMenu();

	resize(KOptions->SavedWidth,KOptions->SavedHeight);
	LeftView->resize((KOptions->ShowTreeView ? KOptions->SavedDirWidth : 0),DirectoryTree->height());
	if (!KOptions->ShowTreeView) LeftView->hide();
	MainView->setResizeMode(LeftView,QSplitter::KeepSize);

	installEventFilter(this);
}

void KExplorer::initialize(const char *path)
{
	// Finish initialization
	initBusy();
	message1(i18n("Reading bookmarks..."));
	loadBookmarks();
	message1(i18n("Reading mime types..."));
	setupMimeTypes();
	message1(i18n("Reading magic file..."));
	Magic->setMagicFile(KOptions->MagicFile.data());
	showImagePreview(KOptions->ImagePreview);
	finishBusy();

	// Scan startup directory
	QString		HomePath, Path, Tree(DESKTOP_SYSTEM.data());
	HomePath = "file:";
	HomePath += getenv("HOME");
	if (HomePath.right(1) != "/") HomePath += '/';
	Tree += "Home/";
	if (WindowList->count() > 1) {
		FileWindowListIterator	it(*WindowList);
		while(!it.atLast() && it.current()) {
			updateWindow(it.current(),HomePath.data());
			it.current()->TreePath = Tree.data();
			++it;
		}
	}
	addToHistory(HomePath.data());
	if (path) {
		if (*path == '/') { Path = "file:"; Path += path;}
		else if (strchr(path,':')) Path = path;
	}
	else {
		if (KOptions->StartupDir == 1) { if(!KOptions->LastPath.isEmpty()) Path = KOptions->LastPath.data();}
		else { Path = "file:"; Path += getenv("PWD");}
	}
cout << "startup dir: " << Path << endl;
	if (!Path.isEmpty()) {
		if (Path.find(':') == -1)
			// case of special path : "Desktop/", "Desktop/System/", ...
			DirectoryTree->goToDir(Path.data(),false);
		else {
			if (Path.right(1) != "/") Path.append("/");
			KURL	url(Path.data());
			if (!goToDir(url)) {	// if can't find directory, default is to show HOME dir
				url.parse(HomePath.data());
				goToDir(url);
			}
		}
	}
	FileView = 0;
	windowSelected(WindowList->last());
	DirectoryTree->setFocus();
}

KExplorer::~KExplorer()
{
	delete ExtensionDict;
	delete FilenameDict;
	delete ExtensionList;
	delete ApplicationList;
	delete ProtList;
//	delete Pop1;
//	delete Pop2;
//	delete Pop3;
//	delete Pop4;
	delete WindowList;
	delete KOptions;
//	delete URLCompletion;
}

void KExplorer::setupMenu()
{
	KStdAccel	keys(ConfigFile);

	QPopupMenu	*file = new QPopupMenu();
	QPopupMenu	*newPop = new QPopupMenu();
	newPop->insertItem(i18n("Directory"),this,SLOT(newDir()));
	newPop->insertItem(i18n("Device"),this,SLOT(newDevice()));
	file->insertItem(i18n("New ..."),newPop);
	file->insertSeparator();
	file->insertItem(i18n("Open terminal"),this,SLOT(openTerminal()),Key_T+CTRL);
	file->insertSeparator();
	file->insertItem(i18n("Quit"),this,SLOT(shutdown()),keys.quit());
	MenuBar->insertItem(i18n("&File"),file);
	connect(kapp,SIGNAL(shutDown()),SLOT(shutdown()));

	QPopupMenu	*edit = new QPopupMenu();
	edit->insertItem(i18n("Cut"),this,SLOT(cut()),keys.cut());
	edit->insertItem(i18n("Copy"),this,SLOT(copy()),keys.copy());
	edit->insertItem(i18n("Paste"),this,SLOT(paste()),keys.paste());
	edit->insertSeparator();
	edit->insertItem(i18n("Delete"),this,SLOT(remove()),Key_Delete);
	edit->insertItem(i18n("Move to trash"),this,SLOT(moveToTrash()));
	edit->insertSeparator();
	edit->insertItem(i18n("Select all"),this,SLOT(selectAll()),Key_A+CTRL);
	edit->insertItem(i18n("Parent directory"),DirectoryTree,SLOT(cdUp()));
	edit->insertSeparator();
	edit->insertItem(i18n("Preferences..."),this,SLOT(options()));
	MenuBar->insertItem(i18n("&Edit"),edit);

	QPopupMenu	*view = new QPopupMenu();
	QPopupMenu	*toolPop = new QPopupMenu();
	view->setCheckable(TRUE);
	toolPop->setCheckable(true);
	toolPop->insertItem(i18n("General toolbar"),this,SLOT(toggleToolBar()),0,TOOLBAR_ID);
	toolPop->insertItem(i18n("View toolbar"),this,SLOT(toggleViewToolBar()),0,VTOOLBAR_ID);
	toolPop->insertItem(i18n("URL toolbar"),this,SLOT(toggleURLToolBar()),0,URLTOOLBAR_ID);
	view->insertItem(i18n("ToolBar"),toolPop);
	toolPop->setItemChecked(TOOLBAR_ID,KOptions->ToolBarEnabled);
	toolPop->setItemChecked(VTOOLBAR_ID,KOptions->ViewToolBarEnabled);
	toolPop->setItemChecked(URLTOOLBAR_ID,KOptions->URLToolBarEnabled);
	view->insertItem(i18n("StatusBar"),this,SLOT(toggleStatusBar()),0,STATUSBAR_ID);
	view->setItemChecked(STATUSBAR_ID,KOptions->StatusBarEnabled);
	view->insertSeparator();
	view->insertItem(i18n("Refresh"),this,SLOT(slotRefresh()),Key_F5);
	view->insertItem(i18n("Options..."),this,SLOT(options()));
	view->insertSeparator();
	view->insertItem(i18n("Big icons"),this,SLOT(bigIcons()),0,BIGICON_ID);
	view->insertItem(i18n("List icons"),this,SLOT(listIcons()),0,LISTICON_ID);
	view->insertItem(i18n("Small icons"),this,SLOT(smallIcons()),0,SMALLICON_ID);
	view->insertItem(i18n("Details"),this,SLOT(detailIcons()),0,DETAILICON_ID);
	view->setItemChecked(KOptions->Style,TRUE);
	view->insertSeparator();
	ListMenu = new QPopupMenu();
	constructListMenu(ListMenu,false,KOptions->SortingExtended);
	ListMenu->setItemChecked(LISTNAME_ID,TRUE);
	connect(ListMenu,SIGNAL(activated(int)),SLOT(menuActivated(int)));
	view->insertItem(i18n("Sort icons"),ListMenu);
	QPopupMenu	*viewPop = new QPopupMenu();
	viewPop->insertItem(i18n("Hidden files"),this,SLOT(toggleShowHidden()),0,HIDDEN_ID);
	viewPop->setItemChecked(HIDDEN_ID,KOptions->ShowHiddenFiles);
// OLE
	viewPop->insertItem(i18n("Mini-Images"),this,SLOT(toggleShowMiniImages()),0,MINIIMAGES_ID);
        viewPop->setItemChecked(MINIIMAGES_ID,KOptions->ShowMiniImages);			
// OLE
	viewPop->insertItem(i18n("Archive files"),this,SLOT(toggleShowArchive()),0,ARCHIVE_ID);
	viewPop->setItemChecked(ARCHIVE_ID,KOptions->ShowArchive);
	viewPop->insertSeparator();
	viewPop->insertItem(i18n("Image preview"),this,SLOT(toggleImagePreview()),0,PREVIEW_ID);
	viewPop->setItemChecked(PREVIEW_ID,KOptions->ImagePreview);
	viewPop->insertItem(i18n("Directory tree"),this,SLOT(toggleShowTreeView()),0,TREEVIEW_ID);
	viewPop->setItemChecked(TREEVIEW_ID,KOptions->ShowTreeView);
	view->insertItem(i18n("View..."),viewPop);
	view->insertSeparator();
	view->insertItem(i18n("Multiple view"),this,SLOT(toggleMultipleView()),0,MULTIPLE_ID);
	view->setItemChecked(MULTIPLE_ID,KOptions->MultipleView);
	QPopupMenu	*viewType = new QPopupMenu();
	viewType->insertItem(i18n("Single"),this,SLOT(singleView()),0,SINGLE_ID);
	viewType->insertItem(i18n("Split vertical"),this,SLOT(splitVertical()),0,SPLITV_ID);
	viewType->insertItem(i18n("Split horizontal"),this,SLOT(splitHorizontal()),0,SPLITH_ID);
	viewType->setCheckable(TRUE);
	viewType->setItemChecked(KOptions->ViewType,TRUE);
	view->insertItem(i18n("View type"),viewType,VIEWTYPE_ID);
	view->setItemEnabled(VIEWTYPE_ID,!(KOptions->MultipleView));
	MenuBar->insertItem(i18n("&View"),view);

	QPopupMenu	*tools = new QPopupMenu();
	tools->insertItem(i18n("Find ..."),this,SLOT(launchFind()),keys.find());
	tools->insertSeparator();
	tools->insertItem(i18n("Connect new device"),this,SLOT(newDevice()),keys.openNew());
	tools->insertItem(i18n("Remove device"),this,SLOT(removeDevice()),Key_D+CTRL);
	tools->insertSeparator();
	tools->insertItem(i18n("Go to..."),this,SLOT(goToDir()),Key_G+CTRL);
	MenuBar->insertItem(i18n("&Tools"),tools);

	WindowMenu = new QPopupMenu();
	WindowMenu->insertItem(i18n("New window"),this,SLOT(newWindow()));
	WindowMenu->insertSeparator();
	WindowMenu->insertItem(i18n("Cascade"),this,SLOT(cascade()));
	QPopupMenu	*tilePop = new QPopupMenu();
	tilePop->insertItem(i18n("Vertical"),this,SLOT(tileV()));
	tilePop->insertItem(i18n("Horizontal"),this,SLOT(tileH()));
	tilePop->insertSeparator();
	tilePop->insertItem(i18n("Automatic"),this,SLOT(toggleAutoTile()),0,AUTOTILE_ID);
	tilePop->setCheckable(TRUE);
	tilePop->setItemChecked(AUTOTILE_ID,KOptions->AutoTile);
	WindowMenu->insertItem(i18n("Tile"),tilePop);
	WindowMenu->insertItem(i18n("Maximize"),this,SLOT(maximize()));
	WindowMenu->insertItem(i18n("Minimize"),this,SLOT(minimize()));
	WindowMenu->insertItem(i18n("Restore"),this,SLOT(restore()));
	WindowMenu->insertItem(i18n("Close"),this,SLOT(wClose()));
	WindowMenu->insertSeparator();
	MenuBar->insertItem(i18n("&Windows"),WindowMenu,WINDOWS_ID);
	MenuBar->setItemEnabled(WINDOWS_ID,KOptions->MultipleView);
	connect(WindowMenu,SIGNAL(activated(int)),SLOT(menuActivated(int)));

	HistoryMenu = new QPopupMenu;
	MenuBar->insertItem(i18n("&Go"),HistoryMenu,HISTORYMENU_ID);
	connect(HistoryMenu,SIGNAL(activated(int)),SLOT(menuActivated(int)));

	QPopupMenu	*help = kapp->getHelpMenu(true,	"Kruiser v0.4\n"
							"\n"
							"A Win95-like file system explorer\n"
							"for the KDE environment.\n"
							"\n"
							"Author : Michael Goffioul (goffioul@emic.ucl.ac.be)"
						 );
/*	QPopupMenu	*help = new QPopupMenu();
	help->insertItem(i18n("Content"),this,SLOT(mainCallback()),keys.help());
	help->insertSeparator();
	help->insertItem(i18n("About KExplorer..."),this,SLOT(mainCallback()));*/
	MenuBar->insertSeparator();
	MenuBar->insertItem(i18n("&Help"),help);
}

void KExplorer::setupToolBar()
{
//	ToolBar = toolBar();
	KToolBar	*tmpBar = new KToolBar(this);
	ToolBarID = addToolBar(tmpBar);
	if (KOptions->ToolBarEnabled) enableToolBar(KToolBar::Show,ToolBarID);
	else enableToolBar(KToolBar::Hide,ToolBarID);
	Combo = new DirCombo(ToolBar);
	ToolBar->insertWidget(DIRCOMBO_ID,200,Combo);
	DirectoryTree->setCombo(Combo);
	ToolBar->insertButton(*(IconLoader->loadToolBarIcon("dirup.xpm")),DIRUP_ID,SIGNAL(clicked()),DirectoryTree,SLOT(cdUp()),TRUE,i18n("Parent directory"));
	ToolBar->insertSeparator();
	ToolBar->insertButton(*(IconLoader->loadToolBarIcon("connect.xpm")),CONNECT_ID,SIGNAL(clicked()),this,SLOT(newDevice()),TRUE,i18n("Connect new device"));
	ToolBar->insertButton(*(IconLoader->loadToolBarIcon("disconn.xpm")),DISCONNECT_ID,SIGNAL(clicked()),this,SLOT(removeDevice()),TRUE,i18n("Remove device"));
	ToolBar->insertSeparator();
	ToolBar->insertButton(*(IconLoader->loadToolBarIcon("delete.xpm")),DELETE_ID,SIGNAL(clicked()),this,SLOT(remove()),TRUE,i18n("Delete"));
	ToolBar->insertButton(*(IconLoader->loadToolBarIcon("property.xpm")),PROPERTY_ID,SIGNAL(clicked()),this,SLOT(property()),TRUE,i18n("Properties"));
	ToolBar->insertSeparator();
	ToolBar->insertButton(*(IconLoader->loadToolBarIcon("cut.xpm")),CUT_ID,SIGNAL(clicked()),this,SLOT(cut()),TRUE,i18n("Cut"));
	ToolBar->insertButton(*(IconLoader->loadToolBarIcon("copy.xpm")),COPY_ID,SIGNAL(clicked()),this,SLOT(copy()),TRUE,i18n("Copy"));
	ToolBar->insertButton(*(IconLoader->loadToolBarIcon("paste.xpm")),PASTE_ID,SIGNAL(clicked()),this,SLOT(paste()),TRUE,i18n("Paste"));
	ToolBar->insertSeparator();
	ToolBar->insertButton(*(IconLoader->loadToolBarIcon("bigicon.xpm")),BIGICON_ID,SIGNAL(clicked()),this,SLOT(bigIcons()),TRUE,i18n("Big icons"));
	ToolBar->insertButton(*(IconLoader->loadToolBarIcon("lsicon.xpm")),LISTICON_ID,SIGNAL(clicked()),this,SLOT(listIcons()),TRUE,i18n("Icon list"));
	ToolBar->insertButton(*(IconLoader->loadToolBarIcon("smicon.xpm")),SMALLICON_ID,SIGNAL(clicked()),this,SLOT(smallIcons()),TRUE,i18n("Small icons"));
	ToolBar->insertButton(*(IconLoader->loadToolBarIcon("detail.xpm")),DETAILICON_ID,SIGNAL(clicked()),this,SLOT(detailIcons()),TRUE,i18n("Detail list"));
	ToolBar->setToggle(BIGICON_ID,TRUE);
	ToolBar->setToggle(LISTICON_ID,TRUE);
	ToolBar->setToggle(SMALLICON_ID,TRUE);
	ToolBar->setToggle(DETAILICON_ID,TRUE);
	ToolBar->setButton(KOptions->Style,TRUE);
	ToolBar->insertSeparator();
	ToolBar->insertButton(*(IconLoader->loadToolBarIcon("stop.xpm")),ABORT_ID,SIGNAL(clicked()),this,SLOT(abort()),FALSE,i18n("Abort"));
	ToolBar->getButton(ABORT_ID)->setCursor(arrowCursor);

	tmpBar = new KToolBar(this);
	ViewToolBarID = addToolBar(tmpBar);
	ViewToolBar->setBarPos((KToolBar::BarPosition)KOptions->ViewToolBarPosition);
	if (KOptions->ViewToolBarEnabled) enableToolBar(KToolBar::Show,ViewToolBarID);
	else enableToolBar(KToolBar::Hide,ViewToolBarID);
	ViewToolBar->insertButton(*(IconLoader->loadToolBarIcon("hidden.xpm")),HIDDEN_ID,SIGNAL(clicked()),this,SLOT(toggleShowHidden()),TRUE,i18n("Show hidden files"));
	ViewToolBar->insertButton(*(IconLoader->loadToolBarIcon("image.xpm")),MINIIMAGES_ID,SIGNAL(clicked()),this,SLOT(toggleShowMiniImages()),TRUE,i18n("Show images"));
	ViewToolBar->insertButton(*(IconLoader->loadToolBarIcon("archive.xpm")),ARCHIVE_ID,SIGNAL(clicked()),this,SLOT(toggleShowArchive()),TRUE,i18n("Show archives"));
	ViewToolBar->insertSeparator();
	ViewToolBar->insertButton(*(IconLoader->loadToolBarIcon("preview.xpm")),PREVIEW_ID,SIGNAL(clicked()),this,SLOT(toggleImagePreview()),TRUE,i18n("Show preview"));
	ViewToolBar->insertButton(*(IconLoader->loadToolBarIcon("tree.xpm")),TREEVIEW_ID,SIGNAL(clicked()),this,SLOT(toggleShowTreeView()),TRUE,i18n("Show directory tree"));
	ViewToolBar->setToggle(ARCHIVE_ID,TRUE);
	ViewToolBar->setToggle(HIDDEN_ID,TRUE);
	ViewToolBar->setToggle(MINIIMAGES_ID,TRUE);
	ViewToolBar->setToggle(PREVIEW_ID,TRUE);
	ViewToolBar->setToggle(TREEVIEW_ID,TRUE);
	ViewToolBar->setButton(ARCHIVE_ID,KOptions->ShowArchive);
	ViewToolBar->setButton(HIDDEN_ID,KOptions->ShowHiddenFiles);
	ViewToolBar->setButton(MINIIMAGES_ID,KOptions->ShowMiniImages);
	ViewToolBar->setButton(PREVIEW_ID,KOptions->ImagePreview);
	ViewToolBar->setButton(TREEVIEW_ID,KOptions->ShowTreeView);
	ViewToolBar->insertSeparator();
	ViewToolBar->insertButton(*(IconLoader->loadToolBarIcon("mview.xpm")),MULTIPLE_ID,SIGNAL(clicked()),this,SLOT(toggleMultipleView()),TRUE,i18n("Multiple view"));
	ViewToolBar->insertSeparator();
	ViewToolBar->insertButton(*(IconLoader->loadToolBarIcon("single.xpm")),SINGLE_ID,SIGNAL(clicked()),this,SLOT(singleView()),TRUE,i18n("Single"));
	ViewToolBar->insertButton(*(IconLoader->loadToolBarIcon("splitv.xpm")),SPLITV_ID,SIGNAL(clicked()),this,SLOT(splitVertical()),TRUE,i18n("Split vertical"));
	ViewToolBar->insertButton(*(IconLoader->loadToolBarIcon("splith.xpm")),SPLITH_ID,SIGNAL(clicked()),this,SLOT(splitHorizontal()),TRUE,i18n("Split horizontal"));
	ViewToolBar->setToggle(MULTIPLE_ID,TRUE);
	ViewToolBar->setToggle(SINGLE_ID,TRUE);
	ViewToolBar->setToggle(SPLITV_ID,TRUE);
	ViewToolBar->setToggle(SPLITH_ID,TRUE);
	ViewToolBar->setButton(MULTIPLE_ID,KOptions->MultipleView);
	if (KOptions->MultipleView) {
		ViewToolBar->setItemEnabled(SINGLE_ID,FALSE);
		ViewToolBar->setItemEnabled(SPLITV_ID,FALSE);
		ViewToolBar->setItemEnabled(SPLITH_ID,FALSE);
	}
	else ViewToolBar->setButton(KOptions->ViewType,TRUE);

	tmpBar = new KToolBar(this);
	URLToolBarID = addToolBar(tmpBar);
	if (KOptions->URLToolBarEnabled) enableToolBar(KToolBar::Show,URLToolBarID);
	else enableToolBar(KToolBar::Hide,URLToolBarID);
	BookmarkMenu = new QPopupMenu;
	connect(BookmarkMenu,SIGNAL(activated(int)),SLOT(menuActivated(int)));
	tmpBar->insertButton(*(IconLoader->loadToolBarIcon("bookmark.xpm")),BOOKMARKMENU_ID,BookmarkMenu,true,i18n("Bookmarks"));
	tmpBar->insertSeparator();
	tmpBar->insertSeparator();
	QLabel	*URLLabel = new QLabel(tmpBar);
	URLLabel->setAutoResize(true);
	URLLabel->setText("URL :");
	tmpBar->insertWidget(URLLABEL_ID,URLLabel->width(),URLLabel);
	HistoryCombo	*hc = new HistoryCombo(tmpBar);
	URLToolBar->insertWidget(URLLINED_ID,100,hc);
	URLToolBar->setItemAutoSized(URLLINED_ID,true);
	URLCombo->setHistory(&HistoryList);
	connect(URLToolBar,SIGNAL(clicked(int)),SLOT(menuActivated(int)));
	connect(hc,SIGNAL(historySelected(int)),SLOT(menuActivated(int)));
	connect(hc,SIGNAL(returnPressed()),SLOT(historyEnterPressed()));
	tmpBar->setIconText(KOptions->URLToolBarStyle);
}

void KExplorer::loadConfiguration()
{
	ConfigFile = kapp->getConfig();
	ConfigFile->setGroup("Configuration");
	KOptions->UseKDEIcons = ConfigFile->readBoolEntry("UseKDEIcons",TRUE);
	KOptions->UseKDEMimeTypes = ConfigFile->readBoolEntry("UseKDEMimeTypes",TRUE);
	KOptions->UseMagicNumbers = ConfigFile->readBoolEntry("UseMagicNumbers",FALSE);
	KOptions->IconPath = ConfigFile->readEntry("IconPath");
	if (KOptions->IconPath.isEmpty()) {
		KOptions->IconPath = KApplication::kde_datadir();
		KOptions->IconPath += "/kruiser/icons;";
	}
	KOptions->MagicFile = ConfigFile->readEntry("MagicFile");
	if (KOptions->MagicFile.isEmpty()) {
		KOptions->MagicFile = KApplication::kde_mimedir();
		KOptions->MagicFile += "/magic";
	}
	KOptions->ExtensionFile = ConfigFile->readEntry("ExtensionFile");
	if (KOptions->ExtensionFile.isEmpty()) {
		KOptions->ExtensionFile = KApplication::kde_datadir();
		KOptions->ExtensionFile += "/kruiser/dbext";
	}
	KOptions->Style = ConfigFile->readNumEntry("Style",BIGICON_ID);
	KOptions->Sorting = ConfigFile->readNumEntry("Sorting",byName);
//	TmpItem = 0;
//	TmpFile = 0;
	TmpDevice = 0;
	KOptions->ToolBarEnabled = ConfigFile->readBoolEntry("ToolBarEnabled",TRUE);
	KOptions->StatusBarEnabled = ConfigFile->readBoolEntry("StatusBarEnabled",TRUE);
	KOptions->ViewToolBarEnabled = ConfigFile->readBoolEntry("ViewToolBarEnabled",TRUE);
	KOptions->URLToolBarEnabled = ConfigFile->readBoolEntry("URLToolBarEnabled",TRUE);
	KOptions->URLToolBarStyle = ConfigFile->readNumEntry("URLToolBarStyle",0);
	KOptions->ShowHiddenFiles = ConfigFile->readBoolEntry("ShowHiddenFiles",TRUE);
// OLE
	KOptions->ShowMiniImages = ConfigFile->readBoolEntry("ShowMiniImages",FALSE);
// OLE
	KOptions->MiniImageSaving = ConfigFile->readNumEntry("MiniImageSaving",0);
	KOptions->ImageSize = ConfigFile->readNumEntry("ImageSize",4096);
	KOptions->SavedWidth = ConfigFile->readNumEntry("Width",650);
	KOptions->SavedHeight = ConfigFile->readNumEntry("Height",500);
	KOptions->SavedDirWidth = ConfigFile->readNumEntry("DirWidth",250);
	ConfigFile->readListEntry("ColType",KOptions->ColType);
	ConfigFile->readListEntry("ColWidth",KOptions->ColWidth);
	if (KOptions->ColType.count() == 0) {
		KOptions->ColType.append("0");
		KOptions->ColType.append("1");
		KOptions->ColType.append("2");
		KOptions->ColType.append("3");
		KOptions->ColType.append("4");
		KOptions->ColWidth.clear();
		KOptions->ColWidth.append("150");
		KOptions->ColWidth.append("100");
		KOptions->ColWidth.append("150");
		KOptions->ColWidth.append("200");
		KOptions->ColWidth.append("150");
	}
	KOptions->ColName[0] = i18n("Name");
	KOptions->ColName[1] = i18n("Size");
	KOptions->ColName[2] = i18n("File Type");
	KOptions->ColName[3] = i18n("Modified");
	KOptions->ColName[4] = i18n("Permissions");
	KOptions->ColName[5] = i18n("User Name");
	KOptions->ColName[6] = i18n("Group Name");
	KOptions->ColName[7] = i18n("Last Access");
	KOptions->ColName[8] = i18n("Device Name");
	KOptions->ColName[9] = i18n("Mode");
	KOptions->ColName[10] = i18n("Group ID");
	KOptions->ColName[11] = i18n("User ID");
	KOptions->ColName[12] = i18n("Size (raw)");
	KOptions->ColName[13] = i18n("Blocks");
	KOptions->ColName[14] = i18n("NLinks");
	KOptions->ColName[15] = i18n("Creation date");
	KOptions->DateFormat = ConfigFile->readNumEntry("DateFormat",0);
	KOptions->DetailSelectionMode = ConfigFile->readBoolEntry("DetailSelectionMode",false);
	KOptions->ShowArchive = ConfigFile->readBoolEntry("ShowArchive",FALSE);
	ProtList = new SubProtList;
	ProtList->setAutoDelete(TRUE);
	MyStrList	list;
	if (ConfigFile->readListEntry("ArchiveFilter",list) > 0) {
		for (int i=0;i<(int)(list.count());i+=2) {
			int	type(0);
			if (strcmp(list.at(i),"tar") == 0) type = Protocol::Tar;
			else if (strcmp(list.at(i),"zip") == 0) type = Protocol::Zip;
			else if (strcmp(list.at(i),"rpm") == 0) type = Protocol::Rpm;
			ProtList->append(new SubProtocol(type,list.at(i+1)));
		}
	}
	else {
		ProtList->append(new SubProtocol(Protocol::Tar,"*.tar.gz"));
		ProtList->append(new SubProtocol(Protocol::Tar,"*.tgz"));
		ProtList->append(new SubProtocol(Protocol::Tar,"*.tar.Z"));
	}
	KOptions->Shell = ConfigFile->readEntry("Shell");
	if (KOptions->Shell.isEmpty()) KOptions->Shell = "kvt";
	KOptions->LastPath = ConfigFile->readEntry("LastPath");
	KOptions->StartupDir = ConfigFile->readNumEntry("StartupDir",0);
	KOptions->MultipleView = ConfigFile->readBoolEntry("MultipleView",FALSE);
	KOptions->WindowsCount = ConfigFile->readNumEntry("WindowsCount",1);
	KOptions->AutoTile = ConfigFile->readBoolEntry("AutoTile",FALSE);
	KOptions->ViewType = ConfigFile->readNumEntry("ViewType",SINGLE_ID);
	KOptions->DefaultEdit = ConfigFile->readBoolEntry("DefaultEdit",FALSE);
	KOptions->EditApplication = ConfigFile->readEntry("EditApplication","kedit");
	KOptions->PasswdSaving = ConfigFile->readBoolEntry("PasswdSaving",FALSE);
	KOptions->ImagePreview = ConfigFile->readBoolEntry("ImagePreview",FALSE);
	KOptions->ViewToolBarPosition = ConfigFile->readNumEntry("ViewToolBarPosition",KToolBar::Right);
	KOptions->TrackingEnabled = ConfigFile->readBoolEntry("TrackingEnabled",true);
	KOptions->SortingExtended = ConfigFile->readBoolEntry("SortingExtended",true);
	KOptions->HistorySize = ConfigFile->readNumEntry("HistorySize",10);
	KOptions->ShowTreeView = ConfigFile->readBoolEntry("ShowTreeView",true);
	KOptions->SingleClick = ConfigFile->readBoolEntry("SingleClick",false);
	KOptions->SambaVersion = ConfigFile->readNumEntry("SambaVersion",1);
	KOptions->TreeFollow = ConfigFile->readBoolEntry("TreeFollow",true);
	KOptions->AppsInSubMenu = ConfigFile->readBoolEntry("AppsInSubMenu",true);
}

void KExplorer::saveConfiguration()
{
	ConfigFile->setGroup("Configuration");
	ConfigFile->writeEntry("UseKDEIcons",KOptions->UseKDEIcons);
	ConfigFile->writeEntry("UseKDEMimeTypes",KOptions->UseKDEMimeTypes);
	ConfigFile->writeEntry("UseMagicNumbers",KOptions->UseMagicNumbers);
	ConfigFile->writeEntry("IconPath",KOptions->IconPath.data());
	ConfigFile->writeEntry("MagicFile",KOptions->MagicFile.data());
	ConfigFile->writeEntry("ExtensionFile",KOptions->ExtensionFile.data());
	ConfigFile->writeEntry("Style",KOptions->Style);
	ConfigFile->writeEntry("ToolBarEnabled",KOptions->ToolBarEnabled);
	ConfigFile->writeEntry("StatusBarEnabled",KOptions->StatusBarEnabled);
	ConfigFile->writeEntry("ViewToolBarEnabled",KOptions->ViewToolBarEnabled);
	ConfigFile->writeEntry("URLToolBarEnabled",KOptions->URLToolBarEnabled);
	ConfigFile->writeEntry("URLToolBarStyle",KOptions->URLToolBarStyle);
	ConfigFile->writeEntry("ShowHiddenFiles",KOptions->ShowHiddenFiles);
// OLE
	ConfigFile->writeEntry("ShowMiniImages",KOptions->ShowMiniImages);
// OLE
	ConfigFile->writeEntry("MiniImageSaving",KOptions->MiniImageSaving);
	ConfigFile->writeEntry("ImageSize",KOptions->ImageSize);
	ConfigFile->writeEntry("Width",width());
	ConfigFile->writeEntry("Height",height());
	ConfigFile->writeEntry("DirWidth",(LeftView->isVisible() ? DirectoryTree->width() : KOptions->SavedDirWidth));
	ConfigFile->writeEntry("ColType",KOptions->ColType);
	ConfigFile->writeEntry("ColWidth",KOptions->ColWidth);
	ConfigFile->writeEntry("DateFormat",KOptions->DateFormat);
	ConfigFile->writeEntry("DetailSelectionMode",KOptions->DetailSelectionMode);
	ConfigFile->writeEntry("ShowArchive",KOptions->ShowArchive);
	MyStrList	list;
	SubProtListIterator	it(*ProtList);
	for (;it.current();++it) {
		list.append(it.current()->protocol);
		list.append(it.current()->extension.pattern());
	}
	ConfigFile->writeEntry("ArchiveFilter",list);
	ConfigFile->writeEntry("Shell",KOptions->Shell);
	ConfigFile->writeEntry("StartupDir",KOptions->StartupDir);
	ConfigFile->writeEntry("MultipleView",KOptions->MultipleView);
	ConfigFile->writeEntry("WindowsCount",KOptions->WindowsCount);
	ConfigFile->writeEntry("AutoTile",KOptions->AutoTile);
	ConfigFile->writeEntry("ViewType",KOptions->ViewType);
	ConfigFile->writeEntry("DefaultEdit",KOptions->DefaultEdit);
	ConfigFile->writeEntry("EditApplication",KOptions->EditApplication.data());
	ConfigFile->writeEntry("PasswdSaving",KOptions->PasswdSaving);
	ConfigFile->writeEntry("ImagePreview",KOptions->ImagePreview);
	ConfigFile->writeEntry("ViewToolBarPosition",(int)(ViewToolBar->barPos()));
	ConfigFile->writeEntry("TrackingEnabled",KOptions->TrackingEnabled);
	ConfigFile->writeEntry("SortingExtended",KOptions->SortingExtended);
	ConfigFile->writeEntry("LastPath",KOptions->LastPath.data());
	ConfigFile->writeEntry("HistorySize",KOptions->HistorySize);
	ConfigFile->writeEntry("ShowTreeView",KOptions->ShowTreeView);
	ConfigFile->writeEntry("SingleClick",KOptions->SingleClick);
	ConfigFile->writeEntry("Sorting",currentWindow() ? currentWindow()->Sorting : byName);
	ConfigFile->writeEntry("SambaVersion",KOptions->SambaVersion);
	ConfigFile->writeEntry("TreeFollow",KOptions->TreeFollow);
	ConfigFile->writeEntry("AppsInSubMenu",KOptions->AppsInSubMenu);

	saveBookmarks();
}

void KExplorer::loadDevices()
{
	DirectoryTree->addItem((DirViewItem*)0,i18n("System"),0,IconLoader->loadMiniIcon("background.xpm"),IconLoader->loadMiniIcon("background.xpm"),FALSE,FALSE);
	DirectoryTree->addItem((DirViewItem*)0,i18n("Network"),0,IconLoader->loadMiniIcon("world.xpm"),IconLoader->loadMiniIcon("world.xpm"),FALSE,FALSE);
	DirectoryTree->addItem((DirViewItem*)0,i18n("Network neighborhood"),"smb:",IconLoader->loadMiniIcon("network_settings.xpm"),IconLoader->loadMiniIcon("network_settings.xpm"),FALSE,TRUE);
	ConfigFile->setGroup("Devices");
	int		n = ConfigFile->readNumEntry("NumberOfDevices",0);
	if (n > 0) {
		Device	*dev;
		Protocol	*prot = 0;
		MyStrList	list;
		ConfigFile->readListEntry("Devices",list);
		for (int i=0;i<n;i++) {
			int	offset = i*8;
			QString	name(list.at(offset+1));
			if (strcmp(list.at(offset+0),"File") == 0) prot = Manager->createProtocol(Protocol::File,list.at(offset+2));
			else if (strcmp(list.at(offset+0),"Mount") == 0) prot = Manager->createProtocol(Protocol::Mount,list.at(offset+2),list.at(offset+3),list.at(offset+4));
			else if (strcmp(list.at(offset+0),"Ftp") == 0) prot = Manager->createProtocol(Protocol::Ftp,list.at(offset+2),list.at(offset+3),list.at(offset+4),list.at(offset+5),list.at(offset+6));
			else if (strcmp(list.at(offset+0),"Trash") == 0) { prot = Manager->createProtocol(Protocol::Trash,list.at(offset+2)); name = i18n("Trash");}
			else if (strcmp(list.at(offset+0),"Smb") == 0) prot = Manager->createProtocol(Protocol::Smb,list.at(offset+2),list.at(offset+3),list.at(offset+4),list.at(offset+5),list.at(offset+6));
			dev = new Device(name.data(),list.at(offset+7),prot,TRUE,list.at(offset+2),list.at(offset+3),list.at(offset+4),list.at(offset+5),list.at(offset+6));
			QString	icon(list.at(offset+7)),iconSel;
			if (dev->type() == Protocol::Trash)
				icon = (((TrashProtocol*)prot)->isEmpty() ? "kfm_trash.xpm" : "kfm_fulltrash.xpm");
			if (icon == "folder.xpm") iconSel = "folder_open.xpm";
			else iconSel = icon.data();
			DeviceList.append(dev);
			int	itemType = DirNormal;
			if (prot->canBeMounted() && prot->isAccesible()) itemType = DirMount;
			if (prot->isLocal()) DirectoryTree->addItem(DESKTOP_SYSTEM,name.data(),dev->path().data(),IconLoader->loadMiniIcon(icon.data()),IconLoader->loadMiniIcon(iconSel.data()),TRUE,TRUE,itemType);
			else DirectoryTree->addItem(DESKTOP_NETWORK,list.at(offset+1),dev->path().data(),IconLoader->loadMiniIcon(icon.data()),IconLoader->loadMiniIcon(iconSel.data()),TRUE,TRUE,itemType,FALSE);
		}
	}
	else {		// init defaults devices under KDE
		Device	*dev;
		Protocol	*prot;
		// "Root" device
		prot = Manager->createProtocol(Protocol::File,"/");
		dev = new Device("Root","folder.xpm",prot,TRUE,"/","","","","");
		DeviceList.append(dev);
		DirectoryTree->addItem(DESKTOP_SYSTEM,"Root","file:/",IconLoader->loadMiniIcon("folder.xpm"),IconLoader->loadMiniIcon("folder_open.xpm"),TRUE);
		// "Home" device
		QString		home(getenv("HOME"));
		if (!home.isEmpty()) {
			if (home[home.length()-1] != '/') home += "/";
			prot = Manager->createProtocol(Protocol::File,home.data());
			dev = new Device("Home","folder.xpm",prot,TRUE,home.data(),"","","","");
			DeviceList.append(dev);
			QString		tmp("file:");
			tmp += home;
			DirectoryTree->addItem(DESKTOP_SYSTEM,"Home",tmp.data(),IconLoader->loadMiniIcon("folder.xpm"),IconLoader->loadMiniIcon("folder_open.xpm"),TRUE);
		}
		// "Trash" device
		if (!home.isEmpty()) {
			QString	tmp(home.data());
			tmp += "Desktop/Trash/";
			prot = Manager->createProtocol(Protocol::Trash,tmp.data());
			QString	icon = (((TrashProtocol*)prot)->isEmpty() ? "kfm_trash.xpm" : "kfm_fulltrash.xpm");
			dev = new Device(i18n("Trash"),"kfm_trash.xpm",prot,TRUE,tmp.data(),"","","","");
			DeviceList.append(dev);
			QString		tmp2("file:");
			tmp2 += tmp;
			DirectoryTree->addItem(DESKTOP_SYSTEM,i18n("Trash"),tmp2.data(),IconLoader->loadMiniIcon(icon.data()),IconLoader->loadMiniIcon(icon.data()),TRUE);
		}
	}
}

void KExplorer::saveDevices()
{
	// Don't take the order of DeviceList, take the order from tree view
	DirViewItemList	devlist;
	devlist.setAutoDelete(false);
	QListIterator<DirViewItem>	it_local(*(DirectoryTree->rootItem()->Childs->at(0)->Childs));
	for (;it_local.current();++it_local) devlist.append(it_local.current());
	QListIterator<DirViewItem>	it_network(*(DirectoryTree->rootItem()->Childs->at(1)->Childs));
	for (;it_network.current();++it_network) devlist.append(it_network.current());
	QListIterator<DirViewItem>	it(devlist);
	int	index = 0;
	ConfigFile->setGroup("Devices");
	MyStrList	list;
	for (;it.current();++it) {
		Device	*dev = findDevice(it.current()->Label.data());
		if (!dev->keep()) continue;
		switch (dev->type()) {
		   case Protocol::File:
			list.append("File");
			break;
		   case Protocol::Mount:
			list.append("Mount");
			break;
		   case Protocol::Ftp:
			list.append("Ftp");
			dev->setString(3,(KOptions->PasswdSaving ? dev->protocol()->passwd() : ""));
			break;
		   case Protocol::Trash:
			list.append("Trash");
			break;
		   case Protocol::Smb:
			list.append("Smb");
			dev->setString(3,(KOptions->PasswdSaving ? dev->protocol()->passwd() : ""));
			break;
		}
		list.append(dev->name().data());
		for (int i=0;i<5;i++) list.append(dev->string(i).data());
		list.append(dev->icon().data());
		index++;
	}
	ConfigFile->writeEntry("NumberOfDevices",index);
	ConfigFile->writeEntry("Devices",list);
}

void KExplorer::setupMimeTypes()
{
	// Purge existing configuration
	ExtensionDict->clear();
	FilenameDict->clear();
	ExtensionList->clear();
	ApplicationDict->clear();
	ApplicationList->clear();

	// First load extensions
	if (KOptions->UseKDEMimeTypes) {
		scanMimeDir(KApplication::localkdedir() + "/share/mimelnk");
		scanMimeDir(KApplication::kde_mimedir());
	}
	else {
		QString	file = KOptions->ExtensionFile.data();
		KMimeExtension	*item;
		if (!file.isEmpty()) {
			QFile	f(file);
			f.open(IO_ReadOnly | IO_Translate);
			char	buffer[1024];
			QString		str[6],ext;
			while (f.readLine(buffer,1024) > 1) {
				char	*c = strtok(buffer,"\t\n\r");
				for (int i=0;i<6;i++,c=strtok(0,"\t\n\r")) str[i] = c;
				item = new KMimeExtension(str[5],str[0],str[1],str[2],str[3],(str[4] == "noshell" ? FALSE : TRUE));
				ExtensionList->inSort(item);
				for (int i=0;i<item->nExtension();i++)
					if (strncmp(item->extension(i),"*.",2) == 0) ExtensionDict->insert(item->extension(i)+2,item);
					else if (FilenameDict->findRef(item) == -1) FilenameDict->append(item);
				if (!item->MimeName.isEmpty()) ExtensionDict->insert(item->MimeName.data(),item);
			}
		}
		else QMessageBox::critical(this,i18n("Error"),i18n("Can't open extension file"),QMessageBox::Ok | QMessageBox::Default,0);
	}

	// Then load applications and associate with mime types
	ApplicationNameDict = new KMimeAppDict;
	ApplicationNameDict->setAutoDelete(FALSE);
	scanAppLnkDir(KApplication::localkdedir() + "/share/applnk/");
	scanAppLnkDir(KApplication::kde_appsdir());
	delete ApplicationNameDict;
	if (KOptions->UseKDEMimeTypes) associateMimeTypes(ApplicationList,ExtensionDict);
}

void KExplorer::saveMimeTypes()
{ // Only save if using non KDE mime types
	if (KOptions->UseKDEMimeTypes) return;
	KOptions->ExtensionFile = KApplication::localkdedir() + "/share/apps/kruiser/dbext";
	if (!KOptions->ExtensionFile.isEmpty()) {
		QFile	f(KOptions->ExtensionFile.data());
		if (f.open(IO_WriteOnly | IO_Translate)) {
			QTextStream	t(&f);
			KMimeExtListIterator	it(*ExtensionList);
			for (;it.current();++it) {
				QStrListIterator	lit(it.current()->Extensions);
				if (lit.current() == 0) t << ';';
				for (;lit.current();++lit) { t << lit.current() << ';';}
				t << '\t';
				t << it.current()->Application.data() << '\t';
				t << it.current()->Description.data() << '\t';
				t << it.current()->MimeIcon.data() << '\t';
				t << (it.current()->inShell ? "inshell" : "noshell") << '\t';
				t << (it.current()->MimeName.isEmpty() ? "none" : it.current()->MimeName.data()) << endl;
			}
			f.close();
		}
		else QMessageBox::critical(this,i18n("Error"),i18n("Unable to save extension file"),QMessageBox::Ok | QMessageBox::Default,0);
	}
}

void KExplorer::scanAppLnkDir(const QString& dirName)
{
	// process some pending events
	kapp->processEvents(50);

	QDir	dir(dirName);
	if (!dir.exists()) return;
	QString	tmp(dir.dirName());
	if (tmp == "Games" || tmp == "Settings" || tmp == "System") return;
	const QFileInfoList	*list = dir.entryInfoList("*.kdelnk",QDir::Files,QDir::Name);
	QFileInfoListIterator	it(*list);
	for (;it.current();++it) {
		KMimeApplication	*item = new KMimeApplication(it.current()->absFilePath());
		int	pos = dirName.findRev('/',dirName.length()-2);
		QString	str = it.current()->absFilePath().right(it.current()->absFilePath().length()-pos-1);
		if (ApplicationNameDict->find(str.data()) != 0) { delete item; continue;}
		ApplicationNameDict->insert(str.data(),item);
		ApplicationList->inSort(item);
		for (int i=0;i<item->nMimeType();i++) ApplicationDict->insert(item->mimeType(i),item);
	}
	list = dir.entryInfoList(QDir::Dirs,QDir::Name);
	it.toFirst(); it += 2;
	for (;it.current();++it) scanAppLnkDir(it.current()->absFilePath());
}

void KExplorer::scanMimeDir(const QString& dirName)
{
	// process some pending events
	kapp->processEvents(50);

	QDir	dir(dirName);
	if (!dir.exists()) return;
	const QFileInfoList	*list = dir.entryInfoList("*.kdelnk",QDir::Files,QDir::Name);
	QFileInfoListIterator	it(*list);
	for (;it.current();++it) {
		KMimeExtension	*item = new KMimeExtension(it.current()->absFilePath());
		if (!item->MimeName.isEmpty() && ExtensionDict->find(item->MimeName.data()) != 0) { delete item; continue;}
		ExtensionList->inSort(item);
		for (int i=0;i<item->nExtension();i++)
			if (strncmp(item->extension(i),"*.",2) == 0) ExtensionDict->insert(item->extension(i)+2,item);
			else if (FilenameDict->findRef(item) == -1) FilenameDict->append(item);
		if (!item->MimeName.isEmpty()) ExtensionDict->insert(item->MimeName.data(),item);
	}
	list = dir.entryInfoList(QDir::Dirs,QDir::Name);
	it.toFirst(); it += 2;
	for (;it.current();++it) scanMimeDir(it.current()->absFilePath());
}

void KExplorer::mainCallback()
{
	QMessageBox::information(this,i18n("Information"),i18n("Sorry, not implemented yet"), QMessageBox::Ok | QMessageBox::Default,0);
}

void KExplorer::scanDirectory(DirViewItem *item)
{
	if (Busy || !currentWindow()) return;
	currentWindow()->TreePath = item->getPath();
	KOptions->LastPath = (item->Address.isEmpty() ? currentWindow()->TreePath.data() : item->Address.data());
	if (item->Depth < 2 && item->Address.isEmpty()) updateWindow(currentWindow(),item->Label);
	else updateWindow(currentWindow(),item->Address);
	selectionChanged();
	setURLCaption(currentWindow()->Url.data());
	addToHistory(currentWindow()->Url.data());
}

void KExplorer::checkUpdateWindow(const char *str1, const char *str2, const char *treepath)
{
	QListIterator<FileWindow>	it(*WindowList);
	QString		parentURL(str2);
	if (str2) {
		int		pos = parentURL.findRev('/',parentURL.length()-2);
		parentURL.truncate(pos+1);
	}
	for (;it.current();++it) {
		if (treepath && it.current()->TreePath.find(treepath) != -1) {
			it.current()->TreePath = DirectoryTree->rootItem()->getPath();
			it.current()->Url = i18n("Desktop");
			it.current()->UpdateFlag = true;
		}
		if (!it.current()->UpdateFlag && it.current()->Url == str1) it.current()->UpdateFlag = true;
		if (!it.current()->UpdateFlag && str2 && (it.current()->Url == parentURL || it.current()->Url.find(parentURL.data()) != -1))
			it.current()->UpdateFlag = true;
		if (it.current()->UpdateFlag) updateWindow(it.current(),it.current()->Url);
	}
}

void KExplorer::updateWindow(FileWindow* wnd, const QString& urlStr)
{
cout << "scanning " << urlStr << endl;
	message1(i18n("Scanning directory..."));
	wnd->clearList();
	bool	special(FALSE);
	if (urlStr == i18n("Desktop")) listDesktop(wnd), special = TRUE;
	else if (urlStr == i18n("System")) listDevices(wnd,TRUE), special = TRUE;
	else if (urlStr == i18n("Network")) listDevices(wnd,FALSE), special = TRUE;
	if (!urlStr.isEmpty()) {
		wnd->setUrl(urlStr.data());
//wnd->FileView->setLabelString(urlStr.data());
		MenuBar->changeItem(urlStr.data(),wnd->Index+MDIWINDOW_ID);
	}
	else if (wnd->Url.isEmpty()) return;
	if (special) {
		wnd->updateList();
		return;
	}
	KURL	url((urlStr.isEmpty() ? wnd->Url.data() : urlStr.data()));
	Protocol	*prot = Manager->searchProtocol(url);
	if (!prot) prot = createArchiveProtocol(url);
	if (prot == 0) return;
	if (!prot->isAccesible()) {
		Device	*dev = findDevice(prot);
		if (dev) TmpDevice = DirectoryTree->findItem(dev->treePath());
		// if not then we're probably in the case of "network neighborhood" share device
		else TmpDevice = DirectoryTree->findItemFromURL(urlStr.data(),DESKTOP_NETWORKNEIGHBORHOOD);
		openProtocol();
	}
	initBusy();
cout << "start thread" << endl;
	const FileInfoList	*list = Manager->list(prot,url,KOptions->ShowHiddenFiles);
cout << "thread finished\nstarting processing" << endl;
	message1(i18n("Post-processing..."));
	if (list) {
		wnd->FileList->setSorting(wnd->Sorting);
		FileInfoListIterator	it(*list);
		QString		icon;
		FileInfo	*fi;
		bool		created(FALSE);
		for (;it.current();++it) {
			fi = new FileInfo(*(it.current()));
			if (fi->iconName().isEmpty()) {
				if (fi->mimeType()) {
					icon = fi->mimeType()->MimeIcon.data();
					if (strncmp(fi->mimeType()->MimeName.data(),"image/",6) == 0 && !created && (created=createXVPICSDir(url))) ;
				}
				else if (fi->isDir()) {
					if (fi->isReadable()) icon = "folder.xpm";
					else icon = "lockedfolder.xpm";
				}
				else icon = "unknown.xpm";
			}
			else icon = fi->iconName().data();
			fi->setIcons(IconLoader->loadIcon(icon.data(),"unknown.xpm"),IconLoader->loadMiniIcon(icon.data(),"unknown.xpm"));
			wnd->FileList->inSort(fi);
		}
		FileInfoListIterator	it2(*(wnd->FileList));
		for (int i=0;it2.current();++it2,i++) it2.current()->setIndex(i);
	}
cout << "process finished" << endl;
	wnd->updateList();
	finishBusy();
}

void KExplorer::scanSubDirectories(DirViewItem *item)
{
cout << "scanning subdirs of " << item->Label << endl;
	if (Busy) return;
	if (item->Depth < 2 && item->Address.isEmpty()) return;
	KURL	url(item->Address.data());
	Protocol	*prot = Manager->searchProtocol(url);
	if (!prot) prot = createArchiveProtocol(url);
	if (prot == 0) return;
	if (item->Depth == 2 && !prot->isAccesible()) {
		Device	*dev = findDevice(prot);
		TmpDevice = DirectoryTree->findItem(dev->treePath());
		openProtocol();
	}
	initBusy();
	const FileInfoList	*list = Manager->listSubDirs(prot,url,KOptions->ShowHiddenFiles,KOptions->ShowArchive);
	if (list) {
		DirViewItemList		ItemList;
//		ItemList.setAutoDelete(false);		// this is the default
		FileInfoListIterator	it(*list);
		QString		icon, iconSel;
		int	type;
		for (;it.current();++it) {
			if (!it.current()->iconName().isEmpty()) icon = it.current()->iconName().data();
			else if (it.current()->isDir()) {
				if (!it.current()->isReadable()) icon = "lockedfolder.xpm";
				else icon = "folder.xpm";
			}
			else icon = "tgz.xpm";
			iconSel = (icon == "folder.xpm" ? "folder_open.xpm" : icon.data());
			type = (it.current()->isSymLink() ? DirLink : DirNormal);
			KURL	url(it.current()->absFilePath().data());
			bool	hasExpand = (it.current()->isDir() ? prot->hasChilds(url.path()) : TRUE);
			ItemList.inSort(new DirViewItem(0,it.current()->fileName().data(),it.current()->absFilePath().data(),IconLoader->loadMiniIcon(icon.data()),IconLoader->loadMiniIcon(iconSel.data()),hasExpand,type));
			ItemList.last()->Sorting = true;
		}
		DirViewItemListIterator		newIter(ItemList);
		if (!item->ChildsScanned || item->Childs->count() == 0)
			for (;newIter.current();++newIter) item->addChildItem(newIter.current());
		else {
			int	pos(-1);
			DirViewItemListIterator		curIter(*(item->Childs));
			for (;curIter.current();)
				if ((pos=ItemList.find(curIter.current())) == -1) {
					item->removeChildItem(curIter.current());
				}
				else ++curIter;
			for (;newIter.current();)
				if ((pos=item->Childs->find(newIter.current())) != -1) {
					delete newIter.current();
					ItemList.removeRef(newIter.current());
				}
				else ++newIter;
			for (newIter.toFirst();newIter.current();++newIter)
				item->addChildItem(newIter.current());
		}
		item->HasChilds = prot->hasChilds(url.path());
		item->ChildsScanned = TRUE;
		DirectoryTree->updateView();
	}
	finishBusy();
}

void KExplorer::listDevices(FileWindow *wnd, bool local)
{
	QListIterator<Device>	it(DeviceList);
	FileInfo	*fi;
	QString		str("drwxrwxrwx 1 root root 0 " + getTime() + " "), tmp;
	int		index(0);
	for (;it.current();++it) {
		if (local && !it.current()->protocol()->isLocal()) continue;
		else if (!local && it.current()->protocol()->isLocal()) continue;
		tmp = str.data();
		tmp += it.current()->name();
		fi = new FileInfo(tmp.data(),6);
		fi->setIcons(IconLoader->loadIcon(it.current()->icon().data()),IconLoader->loadMiniIcon(it.current()->icon().data()));
		QString		descr;
		switch (it.current()->type()) {
		   case Protocol::File: descr = i18n("Folder"); break;
		   case Protocol::Mount: descr = i18n("Mountable"); break;
		   case Protocol::Ftp: descr = i18n("Ftp"); break;
		   case Protocol::Trash: descr = i18n("Trash"); break;
		}
		fi->setDescription(descr.data());
		fi->setPath(it.current()->path());
		fi->setIndex(index++);
		wnd->FileList->append(fi);
	}
	QString		str1, str2;
	if (local) str1 += i18n("System");
	else str1 += i18n("Network");
	setURLCaption(str1.data());
	str2.setNum(index);
	str2 += i18n(" objects");
	Status1Info->setText(str2.data());
	Status2Info->setText("");
}

void KExplorer::listDesktop(FileWindow *wnd)
{
	QString		str("drwxrwxrwx 1 root root 0 " + getTime() + " "), tmp;
	tmp = str.data();
	tmp += i18n("System");
	tmp += '/';
	FileInfo	*fi = new FileInfo(tmp.data(),6);
	fi->setIcons(IconLoader->loadIcon("background.xpm"),IconLoader->loadMiniIcon("background.xpm"));
	fi->setDescription(i18n("Local devices repository"));
	fi->setPath("file:/");
	fi->setIndex(0);
	wnd->FileList->append(fi);
	tmp = str.data();
	tmp += i18n("Network");
	tmp += '/';
	fi = new FileInfo(tmp.data(),6);
	fi->setIcons(IconLoader->loadIcon("world.xpm"),IconLoader->loadMiniIcon("world.xpm"));
	fi->setDescription(i18n("Remote devices repository"));
	fi->setPath("file:/");
	fi->setIndex(1);
	wnd->FileList->append(fi);
	tmp = str.data();
	tmp += i18n("Network neighborhood");
	tmp += '/';
	fi = new FileInfo(tmp.data(),6);
	fi->setIcons(IconLoader->loadIcon("network_settings.xpm"),IconLoader->loadMiniIcon("network_settings.xpm"));
	fi->setDescription(i18n("Network neighborhood repository"));
	fi->setPath("file:/");
	fi->setIndex(2);
	wnd->FileList->append(fi);
	setURLCaption(i18n("Desktop"));
	Status1Info->setText("");
	Status2Info->setText("");
}

void KExplorer::changeView(int newStyle)
{
	FileWindow	*wnd = currentWindow();
	int	oldStyle = wnd->Style;
	if (oldStyle == newStyle) {
		ToolBar->setButton(oldStyle,TRUE);
		return;
	}
	MenuBar->setItemChecked(oldStyle,FALSE);
	MenuBar->setItemChecked(newStyle,TRUE);
	ToolBar->setButton(oldStyle,FALSE);
	ToolBar->setButton(newStyle,TRUE);
	detailPropertiesChanged();
	wnd->FileView->changeType(newStyle,KOptions->ShowMiniImages,KOptions->DateFormat,KOptions->DetailSelectionMode,&(KOptions->ColType),&(KOptions->ColWidth),KOptions->ColName);
	wnd->Style = newStyle;
	KOptions->Style = newStyle;
}

void KExplorer::bigIcons()
{ changeView(BIGICON_ID);}

void KExplorer::listIcons()
{ changeView(LISTICON_ID);}

void KExplorer::smallIcons()
{ changeView(SMALLICON_ID);}

void KExplorer::detailIcons()
{ changeView(DETAILICON_ID);}

void KExplorer::openItem(FileInfo *item)
{
	if (Busy) return;
	KURL	url(item->absFilePath());
	if (item->isDir()) {
		if (DirectoryTree->currentItem()) DirectoryTree->cdDown(item->fileName());
		else {		// the current item doesn't exists, then use goToDir()
			KURL	gotoURL(item->absFilePath().data());
			goToDir(gotoURL);
		}
	}
	else if (item->mimeType()) {
		if (item->mimeType()->MimeName == "application/x-executable") {
			KProcess	proc;
			QString		cmd(item->absFilePath().data());
			proc << cmd.right(cmd.length()-cmd.find(':')-1).data();
			proc.start(KProcess::DontCare,KProcess::NoCommunication);
		}
		else if (item->mimeType()->MimeName == "application/x-shellscript")
			executeAction("%shell -caption \"%c\" -e %f",url);
		else if (item->mimeType()->Application != "None")
			executeAction(item->mimeType()->Application.data(),url);
		else if (!KOptions->DefaultEdit) openWith();
		else edit();
	}
	else if (!KOptions->DefaultEdit) openWith();
	else edit();
}

void KExplorer::openArchive()
{ DirectoryTree->cdDown(fileView()->getSelected()->at(0)->fileName());}

void KExplorer::executeAction(const char *str, KURL& url)
{
	initBusy();
	Protocol	*prot = Manager->searchProtocol(url);
	QString		fileTmp(Manager->getFile(prot,url));
	if (!fileTmp.isEmpty()) {
		QString		cmd(str);
		char		*c = strtok(cmd.data()," ");
		KProcess	proc;
		bool		needFile = TRUE;
		while (c) {
			if (strcmp(c,"%u") == 0) proc << fileTmp, needFile = FALSE;
			else if (strcmp(c,"%f") == 0) proc << fileTmp, needFile = FALSE;
			else if (strcmp(c,"%m") == 0 || strcmp(c,"%i") == 0) ;	// nothing to do
			else if (strcmp(c,"\"%c\"") == 0) {
				QString		tmp("\"");
				tmp += fileTmp;
				tmp += "\"";
				proc << tmp.data();
			}
			else if (strcmp(c,"%shell") == 0) proc << KOptions->Shell.data();
			else proc << c;
			c = strtok(0," ");
		}
		if (needFile) proc << fileTmp;
		proc.start(KProcess::DontCare,KProcess::NoCommunication);
	}
	finishBusy();
}

/*void KExplorer::destroyFileView()
{
	if (currentWindow()->Style == DETAILICON_ID) fileView()->getColumns(ColType,ColWidth);
	delete fileView();
}*/

FileViewWidget* KExplorer::createFileView(int style, QWidget *parent)
{
	QWidget	*Parent = (parent ? parent : RightSubView);
	FileView = new FileViewWidget(style,KOptions->ShowMiniImages,KOptions->DateFormat,KOptions->DetailSelectionMode,Parent);
	FileView->enableTracking(KOptions->TrackingEnabled);
	FileView->setColumns(KOptions->ColType,KOptions->ColWidth,KOptions->ColName);
	connect(FileView,SIGNAL(requestMiniImage(FileInfo*)),SLOT(miniImageRequested(FileInfo*)));
	connect(FileView,SIGNAL(columnPressed(int)),SLOT(columnPressed(int)));
	connect(FileView,SIGNAL(detailPropertiesChanged()),SLOT(detailPropertiesChanged()));
	FileView->show();
	connect(FileView,SIGNAL(openItem(FileInfo*)),SLOT(openItem(FileInfo*)));
	connect(FileView,SIGNAL(popup()),SLOT(popupFileView()));
	connect(FileView,SIGNAL(selectionChanged()),SLOT(selectionChanged()));
	connect(FileView,SIGNAL(renameItem(FileInfo*,const QString&)),SLOT(renameItem(FileInfo*,const QString&)));
	connect(FileView,SIGNAL(selected(FileViewWidget*)),SLOT(windowSelected(FileViewWidget*)));
	connect(FileView,SIGNAL(dropAccepted(QDropEvent*,FileInfo*,FileViewWidget*)),SLOT(dropOnFileView(QDropEvent*,FileInfo*,FileViewWidget*)));
	QObject::connect(FileView,SIGNAL(backspacePressed()),DirectoryTree,SLOT(cdUp()));
	FileView->setLinkArrows(IconLoader->loadIcon("link.xpm"),IconLoader->loadMiniIcon("link.xpm"));
	FileView->setDNDIcon(IconLoader->loadMiniIcon("dndicon.xpm","unknown.xpm"));
	if (!KOptions->MultipleView) FileView->showLabel(true);
	return FileView;
}

void KExplorer::columnPressed(int col)
{ changeSorting(col);}

void KExplorer::resortFileList()
{
	FileInfoList	*newList = new FileInfoList(currentWindow()->Sorting,currentWindow()->SortDirection);
	FileInfoListIterator	it(*(currentWindow()->FileList));
	for (;it.current();++it) newList->inSort(it.current());
	currentWindow()->FileList->setAutoDelete(FALSE);
	newList->setAutoDelete(TRUE);
	delete currentWindow()->FileList;
	currentWindow()->FileList = newList;
	FileInfoListIterator	it2(*newList);
	for (int i=0;it2.current();++it2,i++) it2.current()->setIndex(i);
	currentWindow()->updateList(true);
}

void KExplorer::changeSorting(int newSort)
{
	MenuBar->setItemChecked(currentWindow()->Sorting+LISTNAME_ID,FALSE);
	currentWindow()->SortDirection = (currentWindow()->Sorting == newSort ? -(currentWindow()->SortDirection) : 1);
	currentWindow()->Sorting = newSort;
	KOptions->Sorting = newSort;
	MenuBar->setItemChecked(currentWindow()->Sorting+LISTNAME_ID,TRUE);
	resortFileList();
}

void KExplorer::cut()
{
	if (Busy) return;
	FileInfoListIterator	iter(*(currentWindow()->FileList));
	for (;iter.current();++iter) iter.current()->setCutted(FALSE);
	FileInfoList	*list = fileView()->getSelected();
	if (list->count() < 1) return;
	URLList.clear();
	FileInfoListIterator	it(*list);
	for (;it.current();++it) {
		URLList.append(it.current()->absFilePath().data());
		it.current()->setCutted(TRUE);
	}
	Cutted = TRUE;
	currentWindow()->updateList(true);
}

void KExplorer::copy()
{
	if (Busy) return;
	FileInfoListIterator	iter(*(currentWindow()->FileList));
	for (;iter.current();++iter) iter.current()->setCutted(FALSE);
	FileInfoList	*list = fileView()->getSelected();
	if (list->count() < 1) return;
	URLList.clear();
	FileInfoListIterator	it(*list);
	for (;it.current();++it) URLList.append(it.current()->absFilePath().data());
	Cutted = FALSE;
	currentWindow()->updateList(true);
}

void KExplorer::paste()
{
	if (Busy) return;
	initBusy();
	if (Cutted) {
		if (Manager->move(URLList,DirectoryTree->currentItem()->Address.data())) removeURLs();
	}
	else Manager->copy(URLList,DirectoryTree->currentItem()->Address.data());
	finishBusy();
	if (containDirs(URLList)) DirectoryTree->refreshItem(DirectoryTree->currentItem()->Address.data());
	checkUpdateWindow(DirectoryTree->currentItem()->Address.data(),(Cutted ? URLList.first() : 0));
}

void KExplorer::remove()
{
	if (Busy) return;
	FileInfoList	*list = fileView()->getSelected();
	if (list->count() < 1) return;
	Protocol	*prot = Manager->searchProtocol(KURL(list->at(0)->absFilePath().data()));
	if (prot) {
		int	res = QMessageBox::warning(this,i18n("Warning"),i18n("Do you really want to delete the selected files ?"),QMessageBox::Yes | QMessageBox::Default,QMessageBox::Cancel);
		if (res != QMessageBox::Yes) return;
		initBusy();
		FileInfoListIterator	it(*list);
		SubProtocol		*subProt;
		QString			urlStr;
		URLList.clear();
		for (;it.current();++it) {
			urlStr = it.current()->absFilePath().data();
			if (it.current()->isDir() && it.current()->isSymLink()) urlStr.truncate(urlStr.length()-1);
			URLList.append(urlStr.data());
		}
		Manager->remove(prot,URLList);
		it.toFirst();
		for (int i=0;i<(int)(URLList.count()) && it.current();++it,i++) {
			urlStr.truncate(0);
			if (it.current()->isDir())
				urlStr = it.current()->absFilePath().data();
			else if (KOptions->ShowArchive && (subProt=matchFileName(it.current()->fileName().data(),ProtList)) != 0)
				urlStr = (it.current()->absFilePath() + '#' + subProt->protocol + ':');
			if (!urlStr.isEmpty())	{
				DirectoryTree->removeItem(it.current()->absFilePath().data());
				FileWindowListIterator	itw(*WindowList);
				for (;itw.current();++itw)
					if (itw.current()->Url.find(urlStr.data()) != -1) {
						itw.current()->TreePath = DESKTOP;
						itw.current()->setUrl(i18n("Desktop"));
						itw.current()->UpdateFlag = true;
					}
			}
		}
		finishBusy();
		DirectoryTree->refreshItem(DirectoryTree->currentItem()->Address.data());
		DirectoryTree->refresh();
	}
	checkUpdateWindow(0,list->first()->absFilePath().data());
}

void KExplorer::property()
{
	if (Busy) return;
	FileInfoList	*list = fileView()->getSelected();
	if (list->count() < 1) return;
	if (list->count() > 1) {
		QMessageBox::critical(this,i18n("Error"),i18n("Can't display properties for more than one file"),QMessageBox::Ok | QMessageBox::Default,0);
		return;
	}
	FileInfo	*item = list->at(0);
	PropertyDlg	*Dlg = new PropertyDlg(item,this);
	if (Dlg->exec()) {
		bool	needScan = false;
		if (Dlg->isChanged() && Manager->chmod(list->at(0)->absFilePath().data(),Dlg->permissions()))
			needScan = true;
		if ((strcmp(item->owner(),Dlg->owner()) || strcmp(item->group(),Dlg->group())) &&
		     Manager->chown(item->absFilePath().data(),Dlg->owner(),Dlg->group())) needScan = true;
		if (Dlg->filename() != item->fileName()) {
			renameItem(item,QString(Dlg->filename()));
			needScan = false;
		}
		if (needScan) scanDirectory(DirectoryTree->currentItem());
	}
	delete Dlg;
}

void KExplorer::newDevice()
{
	if (Busy) return;
	initBusy();
	DeviceDlg	*Dlg = new DeviceDlg(this);
	if (Dlg->exec()) {
		if (Dlg->type() == Protocol::Trash && findTrash() != 0)
			QMessageBox::critical(this,i18n("Error"),i18n("There can be only one trash !"),QMessageBox::Ok | QMessageBox::Default,0);
		else {
			QString		pathStr(Dlg->path());
			processPath(pathStr);
			Protocol	*prot = Manager->createProtocol(Dlg->type(),pathStr.data(),Dlg->host(),Dlg->login(),Dlg->passwd(),Dlg->port());
			QString		icon(Dlg->icon()),iconSel;
			if (icon == "folder.xpm") iconSel = "folder_open.xpm";
			else iconSel = icon.data();
			Device	*dev = new Device(Dlg->name(),icon.data(),prot,Dlg->keep(),pathStr.data(),Dlg->host(),Dlg->login(),Dlg->passwd(),Dlg->port());
			DeviceList.append(dev);
			pathStr = (Dlg->type() == Protocol::Ftp || Dlg->type() == Protocol::Smb ? DESKTOP_NETWORK : DESKTOP_SYSTEM);
			int	itemType = ((prot->canBeMounted() && prot->isAccesible()) ? DirMount : DirNormal);
			bool	updateF = (Dlg->type() == Protocol::Ftp || Dlg->type() == Protocol::Smb);
			DirectoryTree->addItem(pathStr.data(),Dlg->name(),dev->path(),IconLoader->loadMiniIcon(icon.data()),IconLoader->loadMiniIcon(iconSel.data()),true,true,itemType,!updateF);
		}
		saveDevices();
	}
	delete Dlg;
	finishBusy();
}

void KExplorer::removeDevice()
{
	if (Busy) return;
	Device	*dev = (TmpDevice ? findDevice(TmpDevice->Label.data()) : 0);
	if (dev == 0) {
		DeviceDelDlg	*Dlg = new DeviceDelDlg(this);
		QListIterator<Device>	it(DeviceList);
		for (it.toLast();it.current();--it) Dlg->insertDevice(it.current()->name().data(),it.current()->type(),it.current()->path().data(),IconLoader->loadMiniIcon(it.current()->icon().data()));
		if (Dlg->exec()) {
			dev = findDevice(Dlg->selected());
		}
		delete Dlg;
	}
	if (dev != 0) {
		QString		parent(i18n("Desktop"));
		parent += "/";
		if (dev->protocol()->isLocal()) parent += i18n("System");
		else parent += i18n("Network");
		parent += "/";
		QString		url((TmpDevice ? TmpDevice : DirectoryTree->findItem(QString(parent + dev->name() + "/").data()))->getPath());
		DirectoryTree->removeItem(parent.data(),dev->name().data());
		Manager->deleteProtocol(dev->protocol());
		DeviceList.removeRef(dev);
		saveDevices();
		checkUpdateWindow(0,0,url.data());
	}
}

Device* KExplorer::findDevice(const char *name)
{
	QListIterator<Device>	it(DeviceList);
	for (;it.current(); ++it)
		if (it.current()->name() == name) break;
	return it.current();
}

Device* KExplorer::findDevice(Protocol *prot)
{
	QListIterator<Device>	it(DeviceList);
	for (;it.current(); ++it)
		if (it.current()->protocol() == prot) break;
	return it.current();
}

void KExplorer::shutdown()
{
	close();
}

void KExplorer::toggleToolBar()
{
	KOptions->ToolBarEnabled = !KOptions->ToolBarEnabled;
	MenuBar->setItemChecked(TOOLBAR_ID,KOptions->ToolBarEnabled);
	enableToolBar(KToolBar::Toggle,ToolBarID);
}

void KExplorer::toggleViewToolBar()
{
	KOptions->ViewToolBarEnabled = !KOptions->ViewToolBarEnabled;
	MenuBar->setItemChecked(VTOOLBAR_ID,KOptions->ViewToolBarEnabled);
	enableToolBar(KToolBar::Toggle,ViewToolBarID);
}

void KExplorer::toggleURLToolBar()
{
	KOptions->URLToolBarEnabled = !KOptions->URLToolBarEnabled;
	MenuBar->setItemChecked(URLTOOLBAR_ID,KOptions->URLToolBarEnabled);
	enableToolBar(KToolBar::Toggle,URLToolBarID);
}

void KExplorer::toggleStatusBar()
{
	KOptions->StatusBarEnabled = !KOptions->StatusBarEnabled;
	MenuBar->setItemChecked(STATUSBAR_ID,KOptions->StatusBarEnabled);
	enableStatusBar();
}

void KExplorer::popupFileView()
{
	FileInfoList	*list = fileView()->getSelected();
	Pop1->clear();
	if (list->count() == 0) {
		Pop3->clear();
		Pop3->insertItem(i18n("Big icons"),this,SLOT(bigIcons()),0,BIGICON_ID);
		Pop3->insertItem(i18n("List icons"),this,SLOT(listIcons()),0,LISTICON_ID);
		Pop3->insertItem(i18n("Small icons"),this,SLOT(smallIcons()),0,SMALLICON_ID);
		Pop3->insertItem(i18n("Details"),this,SLOT(detailIcons()),0,DETAILICON_ID);
		Pop3->setCheckable(TRUE);
		Pop3->setItemChecked(currentWindow()->Style,TRUE);
		Pop1->insertItem(i18n("View"),Pop3);
		Pop1->insertSeparator();
		Pop2->clear();
		constructListMenu(Pop2,false,KOptions->SortingExtended);
		Pop2->setItemChecked(currentWindow()->Sorting+LISTNAME_ID,true);
		Pop1->insertItem(i18n("Sort icons"),Pop2);
		Pop1->insertSeparator();
		Pop1->insertItem(i18n("Paste"),this,SLOT(paste()));
		Pop1->insertItem(i18n("Paste as link"),this,SLOT(mainCallback()));
		Pop1->insertSeparator();
		if (DirectoryTree->currentItem()->Address.right(8) == ".xvpics/") {
			Pop1->insertItem(i18n("Select outdated thumbnails"),this,SLOT(selectOutdatedThumbnails()));
			Pop1->insertSeparator();
		}
		Pop4->clear();
		TmpAddress = DirectoryTree->currentItem()->Address.data();
		Pop4->insertItem(i18n("Directory"),this,SLOT(newDir()));
		Pop4->insertItem(i18n("Device"),this,SLOT(newDevice()));
		Pop4->insertItem(i18n("Symbolic link"),this,SLOT(mainCallback()));
		Pop1->insertItem(i18n("New ..."),Pop4);
		Pop1->insertSeparator();
		Pop1->insertItem(i18n("Bookmarks"),BookmarkMenu);
		if (KOptions->MultipleView) {
			Pop1->insertSeparator();
			if (currentWindow()->Window->parentWidget() == 0) Pop1->insertItem(i18n("Attach window"),currentWindow()->Window,SLOT(slotAttach()));
			else Pop1->insertItem(i18n("Detach window"),currentWindow()->Window,SLOT(slotDetach()));
		}
	}
	else {
		if (list->count() == 1) {
			if (list->at(0)->isDir()) Pop1->insertItem(i18n("Explore"),this,SLOT(openThisItem()));
			else {
				bool	needOpenWith(true);
				if (KOptions->ShowArchive && matchFileName(list->at(0)->fileName().data(),ProtList)) Pop1->insertItem(i18n("Explore"),this,SLOT(openArchive()));
				KMimeExtension	*ext = list->at(0)->mimeType();
				if (ext && (ext->MimeName == "application/x-executable" || ext->MimeName == "application/x-shellscript")) Pop1->insertItem(*(IconLoader->loadMiniIcon((ext->MimeName == "application/x-executable" ? "exec.xpm" : "terminal.xpm"),"unknown.xpm")),i18n("Execute"),this,SLOT(openThisItem()));
				else if (ext == 0 || (ext->MimeApplications.count() == 0 && ext->Application =="None")) Pop1->insertItem(i18n("Open with ..."),this,SLOT(openWith())), needOpenWith = false;
				else if (ext->MimeApplications.count() == 0) Pop1->insertItem(i18n("Open"),this,SLOT(openThisItem()));
				else if (ext->MimeApplications.count() == 1) {
					Pop1->insertItem(*(IconLoader->loadKDEIcon(ext->MimeApplications.at(0)->MimeIcon.data())),ext->MimeApplications.at(0)->AppName.data(),this,SLOT(openThisItem()));
				}
				else {
					QPopupMenu	*pop = (KOptions->AppsInSubMenu ? Pop2 : Pop1);
					if (KOptions->AppsInSubMenu) {
						Pop2->clear();
						Pop1->insertItem(i18n("Open"),Pop2);
					}
					QListIterator<KMimeApplication>		it(ext->MimeApplications);
					for (int i=0;it.current() && i<4;++it,i++) pop->insertItem(*(IconLoader->loadKDEIcon(it.current()->MimeIcon.data())),it.current()->AppName.data(),APPLICATION_ID+i);
				}
				if (needOpenWith) Pop1->insertItem(i18n("Open with ..."),this,SLOT(openWith()));
				Pop1->insertItem(i18n("Edit"),this,SLOT(edit()));
			}
			Pop1->insertSeparator();
		}
		Pop1->insertItem(i18n("Cut"),this,SLOT(cut()));
		Pop1->insertItem(i18n("Copy"),this,SLOT(copy()));
		if (list->count() == 1) Pop1->insertItem(i18n("Rename"),this,SLOT(startRenaming()));
		Pop1->insertSeparator();
		Pop1->insertItem(i18n("Delete"),this,SLOT(remove()));
		Pop1->insertItem(i18n("Move to trash"),this,SLOT(moveToTrash()));
		Pop1->insertSeparator();
		Pop1->insertItem(i18n("Properties"),this,SLOT(property()));
	}
	Pop1->setFocus();
	Pop1->popup(QCursor::pos());
	Pop1->raise();
}

void KExplorer::removeThisDevice()
{
	TmpDevice = DirectoryTree->popupItem();
	removeDevice();
	TmpDevice = 0;
}

void KExplorer::openThisItem()
{ openItem(fileView()->getSelected()->at(0));}

void KExplorer::edit()
{
	if (Busy) return;
	initBusy();
	KURL		url(fileView()->getSelected()->at(0)->absFilePath().data());
	Protocol	*prot = Manager->searchProtocol(url);
	QString		tmp(Manager->getFile(prot,url));
	if (!tmp.isEmpty()) {
		KProcess	proc;
		int		p1(0),p2;
		QString		Edit(KOptions->EditApplication.simplifyWhiteSpace());
		Edit += " ";
		while (p1 < (int)(Edit.length())) {
			p2 = Edit.find(' ',p1);
			proc << Edit.mid(p1,p2-p1).data();
			p1 = (p2+1);
		}
		proc << tmp.data();
		proc.start(KProcess::DontCare,KProcess::NoCommunication);
	}
	finishBusy();
}

void KExplorer::menuActivated(int id)
{
	if (id < APPLICATION_ID) return;
	if (id < MDIWINDOW_ID) {
		KURL	url(fileView()->getSelected()->at(0)->absFilePath().data());
		executeAction(fileView()->getSelected()->at(0)->mimeType()->MimeApplications.at(id-APPLICATION_ID)->ExecString,url);
	}
	else if (id < LISTNAME_ID) WindowList->at(id-MDIWINDOW_ID)->Window->slotSelect();
	else if (id < HISTORYMENU_ID) changeSorting(id-LISTNAME_ID);
	else if (id < BOOKMARKMENU_ID) {
		KURL	url(HistoryList.at(id-HISTORYMENU_ID-1));
		goToDir(url);
	}
	else if (id < MOVEDEVICE_ID) {
		switch (id-BOOKMARKMENU_ID) {
		   case 1:	// Add bookmark
			addBookmark();
			break;
		   case 2:	// Edit bookmarks
			editBookmarks();
			break;
		   default:	// Go to bookmark
			{ KURL	url(BookmarkList.at(id-BOOKMARKMENU_ID-3)->Bookmark.data());
			  goToDir(url);
			  break;
			}
		}
	}
	else {
		if (id-MOVEDEVICE_ID) DirectoryTree->moveDown(DirectoryTree->popupItem());
		else DirectoryTree->moveUp(DirectoryTree->popupItem());
	}
}

void KExplorer::popupDirectoryTree(DirViewItem *item)
{
	Pop1->clear();
	if (item->Depth >= 2) {
		Pop1->insertItem(i18n("Explore"),this,SLOT(explore()));
		Pop1->insertSeparator();
	}
	Pop1->insertItem(i18n("Expand"),this,SLOT(expand()));
	Pop1->insertItem(i18n("Collapse"),this,SLOT(collapse()));
	Pop1->insertItem(i18n("Refresh"),this,SLOT(refreshDir()));
	if (item->Depth == 2) {
		Pop2->clear();
		Pop2->insertItem(i18n("Up"),MOVEDEVICE_ID);
		Pop2->insertItem(i18n("Down"),MOVEDEVICE_ID+1);
		Pop1->insertItem(i18n("Move..."),Pop2);
		Device	*dev = findDevice(item->Label.data());
		if (dev) {	// their may be some items at depth 2 with no device in "network neighborhood"
			if (dev->string(1) == "/dev/fd0") {
				Pop1->insertSeparator();
				Pop1->insertItem(i18n("Format..."),this,SLOT(formatDevice()));
			}
			if (dev->protocol()->menuEntry()) {
				Pop1->insertSeparator();
				Pop1->insertItem(dev->protocol()->menuEntry(),this,(dev->protocol()->isAccesible() ? SLOT(closeProtocol()) : SLOT(openProtocol())));
			}
			else if (dev->type() == Protocol::Trash) {
				Pop1->insertSeparator();
				Pop1->insertItem(i18n("Empty trash"),this,SLOT(emptyTrash()));
			}
			Pop1->insertSeparator();
			Pop1->insertItem(i18n("Remove device"),this,SLOT(removeThisDevice()));
			Pop1->insertSeparator();
			Pop1->insertItem(i18n("Properties"),this,SLOT(changeDeviceProperties()));
		}
	}
	else if (item->Depth == 1) {
		Pop1->insertSeparator();
		Pop1->insertItem(i18n("Connect new device"),this,SLOT(newDevice()));
		if (item->Label == i18n("Network neighborhood")) {
			Pop1->insertSeparator();
			Pop1->insertItem(i18n("Rescan network"),this,SLOT(rescanNetwork()));
		}
	}
	else if (item->Depth == 4 && item->ParentItem->ParentItem->ParentItem->Label == i18n("Network neighborhood")) {
		// case of a share device under "network neighborhood"
		Pop1->insertSeparator();
		KURL		url(item->Address.data());
		Protocol	*prot = Manager->searchProtocol(url);
		Pop1->insertItem(prot->menuEntry(),this,prot->isAccesible() ? SLOT(closeProtocol()) : SLOT(openProtocol()));
	}
	else if (item->Depth > 2) {
		Pop1->insertSeparator();
		Pop1->insertItem(i18n("Delete"),this,SLOT(removeThisFolder()));
		Pop1->insertSeparator();
		Pop1->insertItem(i18n("Properties"),this,SLOT(propertyThisFolder()));
	}
	if (item->Depth >= 2) {
		Pop1->insertSeparator();
		TmpAddress = item->Address.data();
		Pop1->insertItem(i18n("New directory"),this,SLOT(newDir()));
	}
	Pop1->popup(QCursor::pos());
}

void KExplorer::newDir()
{
	if (Busy) return;
	if (DirectoryTree->currentItem()->Depth < 2) {
		QMessageBox::critical(this,i18n("Error"),i18n("Can't create directory here"),QMessageBox::Ok | QMessageBox::Default,0);
		return;
	}
	LineDlg		*Dlg = new LineDlg(this);
	Dlg->setCaption(i18n("New directory"));
	Dlg->setLabel(i18n("Directory name :"));
	if (Dlg->exec()) {
		// At this point, if TmpAddress is empty, then the call come from
		// normal menu (not popup).
		QString		address = (TmpAddress.isEmpty() ? DirectoryTree->currentItem()->Address.data() : TmpAddress.data());
		QString		str = address.data();
		if (str[str.length()-1] != '/') str += "/";
		QString		encodedName(Dlg->text());
		KURL::encodeURL(encodedName);
		str += encodedName;
		if (str[str.length()-1] != '/') str += "/";
		if (Manager->mkdir(str.data())) {
			DirectoryTree->addItemUrl(address.data(),Dlg->text(),str.data(),IconLoader->loadMiniIcon("folder.xpm","unknown.xpm"),IconLoader->loadMiniIcon("folder_open.xpm","unknown.xpm"),(Dlg->text()[0] != '.' || KOptions->ShowHiddenFiles));
			checkUpdateWindow(0,str.data());
		}
	}
	delete Dlg;
	TmpAddress = "";
}

void KExplorer::openTerminal()
{
	DirViewItem	*item = DirectoryTree->currentItem();
	QString	path("/");
	if (item && !item->Address.isEmpty() && strncmp(item->Address.data(),"file:/",6) == 0) {
		KURL	url(item->Address.data());
		path = url.path();
		path.replace(QRegExp(" "),"\\ ");
	}
	QString		cmd;
	cmd.sprintf("cd %s && %s&",path.data(),KOptions->Shell.data());
	system(cmd.data());
/*	KProcess	p;
	p << "kvt";
	p.start(KProcess::DontCare,KProcess::NoCommunication);*/
}

void KExplorer::openWith()
{
	if (Busy) return;
	OpenDlg		*Dlg = new OpenDlg(ApplicationList,IconLoader,this);
	if (Dlg->exec()) {
		QString		execStr(Dlg->text());
		KURL		url(fileView()->getSelected()->at(0)->absFilePath().data());
		executeAction(execStr.data(),url);
	}
	delete Dlg;
}

void KExplorer::launchFind()
{
	DirViewItem	*item = DirectoryTree->currentItem();
	QString	path("/");
	if (item && !item->Address.isEmpty() && strncmp(item->Address.data(),"file:/",6) == 0) {
		KURL	url(item->Address.data());
		path = url.path();
	}
	QString		cmd;
	cmd.sprintf("cd %s && kfind&",path.data());
	system(cmd.data());
/*	KProcess	p;
	p << "kfind";
	p.start(KProcess::DontCare,KProcess::NoCommunication);*/
}

void KExplorer::dropOnTree(QDropEvent *e, DirViewItem *item)
{
	if (item->Depth < 2) return;
	URLList.clear();
	QUrlDrag::decode(e,URLList);
	TmpAddress = item->Address.data();
	if (item->Depth == 2) {
		Device	*dev = findDevice(item->Label.data());
		Protocol	*prot = dev->protocol();
		if (!prot->isAccesible()) {
			TmpDevice = item;
			openProtocol();
			if (!prot->isAccesible()) return;
		}
	}
	else {
		KURL		url(TmpAddress.data());
		Protocol	*prot = Manager->searchProtocol(url);
		if (!prot) createArchiveProtocol(url);
	}
	Pop1->clear();
	Pop1->insertItem(i18n("Move"),this,SLOT(moveDrag()));
	Pop1->insertItem(i18n("Copy"),this,SLOT(copyDrag()));
	Pop1->insertSeparator();
	Pop1->insertItem(i18n("Link"),this,SLOT(mainCallback()));
	Pop1->popup(QCursor::pos());
}

void KExplorer::moveDrag()
{
	initBusy();
	if (Manager->move(URLList,TmpAddress.data())) removeURLs();
	finishBusy();
	if (containDirs(URLList)) DirectoryTree->refreshItem(TmpAddress.data());
	checkUpdateWindow(TmpAddress.data(),URLList.first());
	TmpAddress = "";
}

void KExplorer::copyDrag()
{
	initBusy();
	Manager->copy(URLList,TmpAddress.data());
	finishBusy();
	if (containDirs(URLList)) DirectoryTree->refreshItem(TmpAddress.data());
	checkUpdateWindow(TmpAddress.data());
	TmpAddress = "";
}

void KExplorer::linkDrag()
{
}

void KExplorer::removeURLs()
{
//	if (Busy) return;
	QStrListIterator	it(URLList);
	for (;it.current();++it) DirectoryTree->removeItem(it.current());
}

void KExplorer::toggleShowHidden()
{
	if (Busy) return;
	KOptions->ShowHiddenFiles = !KOptions->ShowHiddenFiles;
	MenuBar->setItemChecked(HIDDEN_ID,KOptions->ShowHiddenFiles);
	ViewToolBar->setButton(HIDDEN_ID,KOptions->ShowHiddenFiles);
	DirectoryTree->removePointFiles();
	if (DirectoryTree->currentItem() && DirectoryTree->currentItem()->Depth > 1 && KOptions->ShowHiddenFiles) {
		DirectoryTree->rescanChilds(DirectoryTree->currentItem(),false);
	}
	FileWindowListIterator	it(*WindowList);
	for (;it.current();++it) updateWindow(it.current(),0);
}

// OLE
void KExplorer::toggleShowMiniImages()
{
        if (Busy) return;
	KOptions->ShowMiniImages = !KOptions->ShowMiniImages;
	MenuBar->setItemChecked(MINIIMAGES_ID,KOptions->ShowMiniImages);
	ViewToolBar->setButton(MINIIMAGES_ID,KOptions->ShowMiniImages);
	
// kick off redraw of right pane
// please check if these is a viable and good solution
	FileWindowListIterator	it(*WindowList);
	for (;it.current();++it)
		if (it.current()->Style == BIGICON_ID)
			it.current()->FileView->changeType(BIGICON_ID,KOptions->ShowMiniImages);
}
// OLE

void KExplorer::toggleShowArchive()
{
	if (Busy) return;
	KOptions->ShowArchive = !KOptions->ShowArchive;
	MenuBar->setItemChecked(ARCHIVE_ID,KOptions->ShowArchive);
	ViewToolBar->setButton(ARCHIVE_ID,KOptions->ShowArchive);
	if (KOptions->ShowArchive) {
		if (DirectoryTree->currentItem() && DirectoryTree->currentItem()->Depth > 1) DirectoryTree->rescanChilds(DirectoryTree->currentItem(),false);
	}
	else DirectoryTree->removeArchiveFiles();
}

void KExplorer::options()
{
	OptionsDlg = new Options(this);
	OptionsDlg->setOkButton(i18n("OK"));
	OptionsDlg->setApplyButton(i18n("Apply"));
	OptionsDlg->setCancelButton(i18n("Cancel"));
	OptionsDlg->setConfig(KOptions);
	OptionsDlg->setExtList(ExtensionList,IconLoader,KOptions->UseKDEMimeTypes);
	OptionsDlg->setProtList(ProtList);
	connect(OptionsDlg,SIGNAL(applyButtonPressed()),SLOT(optionsApply()));
	OptionsDlg->exec();
	delete OptionsDlg;
}

void KExplorer::optionsApply()
{
	bool	needRefresh = false;
	bool	needScan = false;
	OptionsDlg->setCursor(waitCursor);
	if (OptionsDlg->archModified()) {
		OptionsDlg->getProtList(ProtList);
		if (KOptions->ShowArchive) DirectoryTree->removeArchiveFiles(ProtList);
	}
	if (OptionsDlg->miniImageSaving() != KOptions->MiniImageSaving) {
		KOptions->MiniImageSaving = OptionsDlg->miniImageSaving();
		needRefresh = true;
		if (KOptions->MiniImageSaving == 2) needScan = true;
	}
	if (OptionsDlg->columnsModified() || OptionsDlg->dateFormat() != KOptions->DateFormat
	    || OptionsDlg->selectionMode() != KOptions->DetailSelectionMode) {
		KOptions->DetailSelectionMode = OptionsDlg->selectionMode();
		KOptions->DateFormat = OptionsDlg->dateFormat();
		OptionsDlg->getColumns(KOptions->ColType,KOptions->ColWidth);
		FileWindowListIterator	it(*WindowList);
		for (;it.current();++it)
			if (it.current()->Style == DETAILICON_ID)
				it.current()->FileView->changeType(DETAILICON_ID,KOptions->ShowMiniImages,KOptions->DateFormat,KOptions->DetailSelectionMode,&(KOptions->ColType),&(KOptions->ColWidth),KOptions->ColName);
	}
	if (OptionsDlg->useKDEIcons() != KOptions->UseKDEIcons) {
		KOptions->UseKDEIcons = OptionsDlg->useKDEIcons();
		KOptions->IconPath = OptionsDlg->iconPath();
		if (KOptions->IconPath[KOptions->IconPath.length()-1] != ';') KOptions->IconPath += ";";
		IconLoader->reloadIcons(KOptions->UseKDEIcons,KOptions->IconPath);
		// update right panes
		QListIterator<FileWindow>	it(*WindowList);
		for (;it.current();++it) it.current()->updateList(true);
		// update tree view
		DirectoryTree->update();
		// also update bookmark menu
		constructBookmarkMenu();
		// finally update options dialog
		OptionsDlg->setExtList(ExtensionList,IconLoader,KOptions->UseKDEMimeTypes);
	}
	if (OptionsDlg->useKDEMimeTypes() != KOptions->UseKDEMimeTypes) {
		needScan = true;
		KOptions->UseKDEMimeTypes = OptionsDlg->useKDEMimeTypes();
		KOptions->ExtensionFile = OptionsDlg->extensionFile();
		setupMimeTypes();
		OptionsDlg->setExtList(ExtensionList,IconLoader,KOptions->UseKDEMimeTypes);
	}
	else if (OptionsDlg->extensionsModified()) {	// This can only be achieved if mime types has not been changed
		needScan = true;
		saveMimeTypes();
		setupMimeTypes();
		OptionsDlg->setExtList(ExtensionList,IconLoader,KOptions->UseKDEMimeTypes);
	}
	if (OptionsDlg->useMagicNumbers() != KOptions->UseMagicNumbers || OptionsDlg->magicFile() != KOptions->MagicFile) {
		needScan = true;
		KOptions->UseMagicNumbers = OptionsDlg->useMagicNumbers();
		if (OptionsDlg->magicFile() != KOptions->MagicFile) {
			KOptions->MagicFile = OptionsDlg->magicFile();
			Magic->setMagicFile(KOptions->MagicFile.data());
		}
		Manager->setupMime(ExtensionDict,FilenameDict,Magic,KOptions->UseMagicNumbers);
	}
	KOptions->Shell = OptionsDlg->shell();
	KOptions->StartupDir = OptionsDlg->startup();
	KOptions->ImageSize = OptionsDlg->imageSize();
	KOptions->DefaultEdit = OptionsDlg->defaultEdit();
	KOptions->EditApplication = OptionsDlg->editApplication();
	KOptions->PasswdSaving = OptionsDlg->passwdSaving();
	if (OptionsDlg->mouseTrackingEnabled() != KOptions->TrackingEnabled) {
		KOptions->TrackingEnabled = OptionsDlg->mouseTrackingEnabled();
		QListIterator<FileWindow>	it(*WindowList);
		for (;it.current();++it) it.current()->FileView->enableTracking(KOptions->TrackingEnabled);
		DirectoryTree->setMouseTracking(KOptions->TrackingEnabled);
		if (!KOptions->TrackingEnabled) DirectoryTree->setCursor(arrowCursor);
	}
	if (OptionsDlg->sortingExtended() != KOptions->SortingExtended) {
		KOptions->SortingExtended = OptionsDlg->sortingExtended();
		constructListMenu(ListMenu,true,KOptions->SortingExtended);
		ListMenu->setItemChecked(currentWindow()->Sorting+LISTNAME_ID,true);
	}
	URLToolBar->setIconText((KOptions->URLToolBarStyle=OptionsDlg->urlToolBarStyle()));
	KOptions->HistorySize = OptionsDlg->historySize();
	KOptions->SingleClick = OptionsDlg->singleClick();
	KOptions->SambaVersion = OptionsDlg->sambaVersion();
	KOptions->TreeFollow = OptionsDlg->treeFollow();
	KOptions->AppsInSubMenu = OptionsDlg->appsInSubMenu();
	while ((int)(HistoryList.count()) > KOptions->HistorySize) HistoryList.removeLast();
	constructHistoryMenu();
	URLCombo->refreshHistory();
	OptionsDlg->writeSMB();
	if (needRefresh && !needScan) refresh(false);
	if (needScan) refresh(true);
	OptionsDlg->setCursor(arrowCursor);
	saveConfiguration();
}

void KExplorer::refresh(bool rescan)
{
	if (Busy) return;
	if (rescan) {
		// First refresh the Tree view
		updateTreeView();

		// Then update all subwindows
		QListIterator<FileWindow>	it(*WindowList);
		for (;it.current();++it) updateWindow(it.current(),it.current()->Url);
		selectionChanged();
	}
}

void KExplorer::selectionChanged()
{
	FileInfoList	*list = fileView()->getSelected();
	QString		msg1, msg2;
	if (list->count() == 0) {
		msg1.setNum(currentWindow()->FileList->count());
		msg1 += i18n(" objects");
		unsigned long long	free(0);
		KURL	url(currentWindow()->Url.data());
		Protocol	*prot = Manager->searchProtocol(url);
		if (prot) free = prot->freeSize(url.path());
		ulong	total(0);
		FileInfoListIterator	it(*(currentWindow()->FileList));
		for (;it.current();++it) total += it.current()->size();
		msg2.sprintf(i18n("Total: %s - Free space: %s"),processSize(total).data(),processSize(free).data());
//		msg2 = i18n("Free space : ") + processSize(free);
	}
	else if (list->count() == 1) {
		msg1.setNum(currentWindow()->FileList->count());
		msg1 += i18n(" objects");
		msg2.sprintf("%s (%s) ",list->at(0)->fileName().data(),processSize(list->at(0)->size()).data());
		if (list->at(0)->isSymLink()) msg2 += "-> " + list->at(0)->readLink();
		else msg2 += list->at(0)->description();
	}
	else {
		ulong	total(0);
		msg1.setNum(list->count());
		msg1 += i18n(" objects selected");
		FileInfoListIterator	it(*list);
		for (;it.current();++it) total += it.current()->size();
		msg2.sprintf("%s",processSize(total).data());
	}
	Status1Info->setText(msg1.data());
	Status2Info->setText(msg2.data());

	if( KOptions->ImagePreview ) {
		if (list->count() == 1) Preview->setFileInfo(list->at(0),false);
		else Preview->setFileInfo(0,(list->count()>1));
	}
}

void KExplorer::renameItem(FileInfo *item, const QString& newName)
{
	QString		encodedName(newName.data());
	KURL::encodeURL(encodedName);
	QString		newPath = item->dirPath() + encodedName;
	if (item->isDir()) newPath += '/';
	if (Manager->rename(item->absFilePath().data(),newPath.data())) {
		if (item->isDir()) DirectoryTree->renameItem(item->absFilePath().data(),newPath.data());
		checkUpdateWindow(DirectoryTree->currentItem()->Address.data(),item->absFilePath().data());
	}
	FileInfoList	sel;
	sel.setAutoDelete(false);
	FileInfoListIterator	it(*(currentWindow()->FileList));
	for (;it.current();++it) if (it.current()->absFilePath() == newPath) sel.append(it.current());
	fileView()->setSelection(sel);
}

Device* KExplorer::findTrash()
{
	QListIterator<Device>	it(DeviceList);
	for (;it.current();++it) if (it.current()->type() == Protocol::Trash) break;
	return it.current();
}

void KExplorer::moveToTrash()
{
	Device	*dev = findTrash();
	if (!dev) {
		QMessageBox::critical(this,i18n("Error"),i18n("No trash defined"),QMessageBox::Ok | QMessageBox::Default,0);
		return;
	}
	initBusy();
	FileInfoList	*list = fileView()->getSelected();
	URLList.clear();
	FileInfoListIterator	it(*list);
	QString		TrashAddress;
	for (;it.current();++it) URLList.append(it.current()->absFilePath().data());
cout << "moving to trash : " << dev->path() << endl;
	if (Manager->move(URLList,dev->path())) {
		removeURLs();
		QString	path(DESKTOP_SYSTEM);
		path += i18n("Trash");
		path += '/';
		DirViewItem	*item = DirectoryTree->findItem(path.data());
		TrashAddress = item->Address.data();
		item->Icon = item->IconSel = IconLoader->loadMiniIcon("kfm_fulltrash.xpm");
		DirectoryTree->refresh();
	}
	else QMessageBox::critical(this,i18n("Error"),i18n("Unable to move to trash"),QMessageBox::Ok | QMessageBox::Default,0);
	finishBusy();
	checkUpdateWindow(TrashAddress.data(),URLList.first());
}

void KExplorer::emptyTrash()
{
	Device	*dev = findTrash();
	if (Manager->emptyTrash(dev->protocol())) {
		QString	path(DESKTOP_SYSTEM);
		path += i18n("Trash");
		path += '/';
		DirViewItem	*item = DirectoryTree->findItem(path.data());
		item->Icon = item->IconSel = IconLoader->loadMiniIcon("kfm_trash.xpm");
		DirectoryTree->clearItem(item);
		DirectoryTree->refresh();
		if (item == DirectoryTree->currentItem()) scanDirectory(item);
	}
//	else QMessageBox::critical(this,i18n("Error"),i18n("Unable to empty trash"),QMessageBox::Ok | QMessageBox::Default,0);
}

void KExplorer::removeThisFolder()
{
	if (Busy) return;
	DirViewItem	*item = DirectoryTree->popupItem();
	QString		urlStr(item->Address.data());
	int		pos(-1);
	if ((pos=urlStr.find('#')) != -1 && urlStr.right(1) == ":") urlStr.truncate(pos);
	if (item->Type == DirLink && urlStr.right(1) == "/") urlStr.truncate(urlStr.length()-1);
	KURL		url(urlStr.data());
	Protocol	*prot = Manager->searchProtocol(url);
	if (prot) {
		int	res = QMessageBox::warning(this,i18n("Warning"),i18n("Do you really want to delete the selected files ?"),QMessageBox::Yes | QMessageBox::Default,QMessageBox::Cancel);
		if (res != QMessageBox::Yes) return;
		initBusy();
		URLList.clear();
		URLList.append(urlStr.data());
		if (Manager->remove(prot,URLList)) {
			DirectoryTree->removeItem(item->Address.data());
			FileWindowListIterator	itw(*WindowList);
			for (;itw.current();++itw)
				if (itw.current()->Url.find(urlStr.data()) != -1) {
					itw.current()->TreePath = DESKTOP;
					itw.current()->Url = i18n("Desktop");
					itw.current()->UpdateFlag = true;
				}
		}
		finishBusy();
	}
	checkUpdateWindow(0,url.url().data());
}

void KExplorer::propertyThisFolder()
{
	DirViewItem	*item = DirectoryTree->popupItem();
	KURL		url(item->Address.data());
	Protocol	*prot = Manager->searchProtocol(url);
	if (prot == 0) return;
	FileInfo	*fi = prot->getInfo(url);
	if (fi == 0) return;
	PropertyDlg	*Dlg = new PropertyDlg(fi,this);
	if (Dlg->exec() && Dlg->isChanged())
		if (!Manager->chmod(item->Address.data(),Dlg->permissions())) ;
//			QMessageBox::critical(this,i18n("Error"),i18n("Unable to change permissions"),QMessageBox::Ok | QMessageBox::Default,0);
		else scanDirectory(DirectoryTree->currentItem());
	delete Dlg;
	delete fi;
}

void KExplorer::updateHasChilds(DirViewItem *item)
{
	if (item->Address.isEmpty()) return;
//	if (ShowArchive) item->HasChilds = TRUE;
//	else {
		KURL	url(item->Address.data());
		Protocol	*prot = Manager->searchProtocol(url);
		if (prot) item->HasChilds = prot->hasChilds(url.path());
		DirectoryTree->updateCell(item);
//	}
}

void KExplorer::catchSignal(int sig)
{
	switch(sig) {
	   case SIGPIPE:
		cout << "SIGPIPE signal received" << endl;
		Manager->abort();
		break;
	}
}

Protocol* KExplorer::createArchiveProtocol(KURL& url)
{
	initBusy();
	QString		path(url.parentURL());
	KURL		url2(path.data());
	QString		filename = url2.filename();
	SubProtocol	*subProt = matchFileName(filename.data(),ProtList);
	Protocol	*prot(0);
	if (subProt) prot = Manager->createProtocol(subProt->type,url2.url().data());
	finishBusy();
	return prot;
}

// OLE
void KExplorer::miniImageRequested(FileInfo *fi)
{
}
// OLE

void KExplorer::selectOutdatedThumbnails()
{
	QString		Path(KURL(DirectoryTree->currentItem()->Address.data()).path());
	int	pos = Path.findRev('/',Path.length()-2);
	Path.truncate(pos+1);
	FileInfoList	list;
	list.setAutoDelete(FALSE);
	FileInfoListIterator	it(*(currentWindow()->FileList));
	for (;it.current();++it) {
		if (it.current()->isDir()) continue;
		QString		image(Path+it.current()->fileName());
		if (::access(image.data(),F_OK) != 0) list.append(it.current());
	}
	if (list.count() > 0) fileView()->setSelection(list);
	else QMessageBox::information(this,i18n("Information"),i18n("No outdated thumbnails found"),QMessageBox::Ok | QMessageBox::Default,0);
}

bool KExplorer::goToDir(KURL& url)
{
// Modified to make it recursive for all subprotocols
	if (url.hasSubProtocol()) {
		QString	parentString = url.parentURL();
		KURL	parentURL(parentString.data());
		if (!goToDir(parentURL)) return false;

		QString		childString = url.nestedURL();
		int		pos = childString.find(':')+1;
		if (pos) DirectoryTree->goToDir(childString.data()+pos,true);
	}
	else {
		Protocol	*prot = Manager->searchProtocol(url);
		if ((prot && prot->type()== Protocol::SmbMgr && strcmp(url.host(),"") != 0) ||
		    (!prot && strcmp(url.protocol(),"smb") == 0)) {
			rescanNetwork();
			prot = Manager->searchProtocol(url);
		}
		if (!prot) {
			QString		msg;
			msg.sprintf(i18n("Can't find protocol for %s"),url.url().data());
			if (isVisible()) QMessageBox::critical(this,i18n("Error"),msg.data(),QMessageBox::Ok | QMessageBox::Default,0);
			return false;
		}
		Device		*dev = findDevice(prot);
		QString		path, decodedPath(url.url().mid(prot->prefix().length(),url.url().length()));
		KURL::decodeURL(decodedPath);
		switch (prot->type()) {
		   case Protocol::SmbMgr:
			path = DESKTOP_NETWORKNEIGHBORHOOD + decodedPath;
			break;
		   case Protocol::SmbMach:
			path.sprintf("%s%s/%s/",DESKTOP_NETWORKNEIGHBORHOOD.data(),((SMBMachine*)prot)->workgroup(),((SMBMachine*)prot)->machine());
			break;
		   case Protocol::SmbShare:
			path.sprintf("%s%s/%s/%s/",DESKTOP_NETWORKNEIGHBORHOOD.data(),((SMBShare*)prot)->workgroup(),((SMBShare*)prot)->server(),((SMBShare*)prot)->shareName());
			break;
		   default:
			if (prot->isLocal()) path = DESKTOP_SYSTEM;
			else path = DESKTOP_NETWORK;
			path += (dev->name() + ("/" + decodedPath));
			break;
		}
		if (!path.isEmpty()) DirectoryTree->goToDir(path.data(),false);
		else return false;
	}
	return true;
}

void KExplorer::goToDir()
{
	LineDlg	*Dlg = new LineDlg(this);
	Dlg->setLabel(i18n("Go to directory :"));
	Dlg->enableCompletion();
	if (Dlg->exec()) {
		QString		str(Dlg->text());
		if (str[0] == '/') str.insert(0,"file:");
		if (str.right(1) != '/') str += '/';
		KURL	url(str.data());
		goToDir(url);
	}
}

bool KExplorer::createXVPICSDir(KURL& url)
{
	if (!KOptions->ShowMiniImages || KOptions->MiniImageSaving != 2 || url.hasSubProtocol() || KOptions->Style != BIGICON_ID
	    || strcmp(url.protocol(),"file") != 0 || url.url().right(8) == ".xvpics/") return FALSE;
	QString		path = url.path();
	path += ".xvpics/";
	if (::access(path.data(),F_OK) == 0) return FALSE;		// .xvpics already exists
	if (::mkdir(path.data(),0744) == 0) {
		path = (url.url() + ".xvpics/");
		if (DirectoryTree->currentItem()->ChildsScanned && KOptions->ShowHiddenFiles)
			DirectoryTree->addItem(DirectoryTree->currentItem(),".xvpics",path.data(),IconLoader->loadMiniIcon("folder.xpm","unknown.xpm"),IconLoader->loadMiniIcon("folder_open.xpm","unknown.xpm"),TRUE,FALSE);
		else updateHasChilds(DirectoryTree->currentItem());
		if (KOptions->ShowHiddenFiles) {
			KURL	newUrl(path.data());
			Protocol	*prot = Manager->searchProtocol(newUrl);
			FileInfo	*fi = prot->getInfo(newUrl);
			fi->setIcons(IconLoader->loadIcon("folder.xpm","unknown.xpm"),IconLoader->loadMiniIcon("folder.xpm","unknown.xpm"));
			currentWindow()->FileList->inSort(fi);
		}
//		DirectoryTree->update();
		return TRUE;
	}
	return FALSE;
}

void KExplorer::createWindow(int style)
{
	FileViewWidget	*view = createFileView(style,MDIMgr);
	KMDIWindow	*wnd = MDIMgr->addWindow(view,MDI_SHOW,"mini/kruiser.xpm");
	connect(wnd,SIGNAL(selected(KMDIWindow*)),SLOT(windowSelected(KMDIWindow*)));
	connect(wnd,SIGNAL(closed(KMDIWindow*)),SLOT(windowRemoved(KMDIWindow*)));
	FileWindow	*fwnd = new FileWindow(view,style,wnd);
	fwnd->Sorting = KOptions->Sorting;
	view->show();
	fwnd->Index = WindowList->count();
	WindowList->append(fwnd);
	WindowMenu->insertItem(i18n("(empty)"),fwnd->Index+MDIWINDOW_ID);
	wnd->setFocus();
}

FileWindow* KExplorer::currentWindow()
{
	if (!KOptions->MultipleView) return getWindow(FileView,WindowList);
	return getWindow(MDIMgr->SelectedWindow(),WindowList);
}

void KExplorer::windowSelected(KMDIWindow *wind)
{
	FileWindow	*wnd = getWindow(wind,WindowList);
	if (wnd) wnd->FileView->getFileView()->setFocus();
}

void KExplorer::windowSelected(FileViewWidget *wind)
{
	FileWindow	*wnd = getWindow(wind,WindowList);
	if (wnd) {
		windowSelected(wnd);
		if (KOptions->MultipleView && wnd->Window != MDIMgr->SelectedWindow()) wnd->Window->slotSelect();
	}
}

void KExplorer::windowSelected(FileWindow *wnd)
{
	OldWindow = getWindow(FileView,WindowList);
	if (OldWindow == wnd) return;
	FileView = wnd->FileView;
	if (OldWindow) {
		MenuBar->setItemChecked(OldWindow->Style,FALSE);
		ToolBar->setButton(OldWindow->Style,FALSE);
		MenuBar->setItemChecked(OldWindow->Sorting+LISTNAME_ID,FALSE);
		MenuBar->setItemChecked(OldWindow->Index+MDIWINDOW_ID,FALSE);
		OldWindow->FileView->activate(false);
	}
	MenuBar->setItemChecked(wnd->Style,TRUE);
	ToolBar->setButton(wnd->Style,TRUE);
	MenuBar->setItemChecked(wnd->Sorting+LISTNAME_ID,TRUE);
	MenuBar->setItemChecked(wnd->Index+MDIWINDOW_ID,TRUE);
	wnd->FileView->activate(true);
	OldWindow = wnd;
	selectionChanged();
	DirectoryTree->setCurrentItem(wnd->TreePath.data(),FALSE);
	setURLCaption(wnd->Url.data());
}

void KExplorer::windowRemoved(KMDIWindow *wnd)
{
	FileWindow	*fwnd = getWindow(wnd,WindowList);
	WindowMenu->removeItem(fwnd->Index+MDIWINDOW_ID);
	WindowList->removeRef(fwnd);
	KOptions->WindowsCount--;
	FileWindowListIterator	it(*WindowList);
	for (int i=0;it.current();++it,i++) {
		int	index = WindowMenu->indexOf(it.current()->Index+MDIWINDOW_ID);
		it.current()->Index = i;
		WindowMenu->setId(index,i+MDIWINDOW_ID);
	}
}

void KExplorer::newWindow()
{
	createWindow((WindowList->count() == 0 ? KOptions->Style : currentWindow()->Style));
	KOptions->WindowsCount++;
	scanDirectory(DirectoryTree->currentItem());
}

void KExplorer::popupMDI()
{
	Pop2->clear();
	Pop2->insertItem(i18n("New window"),this,SLOT(newWindow()));
	Pop2->insertSeparator();
	Pop2->insertItem(i18n("Cascade"),this,SLOT(cascade()));
	Pop2->insertItem(i18n("Tile"),this,SLOT(tile()));
	Pop2->insertSeparator();
	FileWindowListIterator	it(*WindowList);
	for (;it.current();++it) Pop2->insertItem((it.current()->Url.isEmpty() ? i18n("(empty)") : it.current()->Url.data()),it.current()->Index+MDIWINDOW_ID);
	if (WindowList->count() != 0) Pop2->setItemChecked(currentWindow()->Index+MDIWINDOW_ID,TRUE);
	Pop2->popup(QCursor::pos());
}

void KExplorer::toggleMultipleView()
{
	MenuBar->setItemChecked(MULTIPLE_ID,!KOptions->MultipleView);
	ViewToolBar->setButton(MULTIPLE_ID,!KOptions->MultipleView);
	KOptions->MultipleView = !KOptions->MultipleView;
	OldWindow = 0;
	if (KOptions->MultipleView) {
		MDIMgr = new KMDIMgrBase(RightSubView);
		connect(MDIMgr,SIGNAL(popup()),SLOT(popupMDI()));
		MDIMgr->setAutoTile(KOptions->AutoTile);
		FileWindowListIterator	it(*WindowList);
		for (int i=0;it.current();++it,i++) {
			it.current()->FileView->showLabel(false);
			it.current()->Window = MDIMgr->addWindow(it.current()->FileView,MDI_SHOW,"mini/kruiser.xpm");
			windowSelected(it.current());
			connect(it.current()->Window,SIGNAL(selected(KMDIWindow*)),SLOT(windowSelected(KMDIWindow*)));
			connect(it.current()->Window,SIGNAL(closed(KMDIWindow*)),SLOT(windowRemoved(KMDIWindow*)));
			it.current()->Index = i;
			WindowMenu->insertItem(it.current()->Url.data(),it.current()->Index+MDIWINDOW_ID);
			it.current()->setUrl(it.current()->Url.data());
		}
		MenuBar->setItemEnabled(WINDOWS_ID,TRUE);
		ViewToolBar->setButton(KOptions->ViewType,FALSE);
		ViewToolBar->setItemEnabled(SINGLE_ID,FALSE);
		ViewToolBar->setItemEnabled(SPLITV_ID,FALSE);
		ViewToolBar->setItemEnabled(SPLITH_ID,FALSE);
		KOptions->WindowsCount = WindowList->count();
		MDIMgr->show();
	}
	else {
		FileWindowListIterator	it2(*WindowList);
		for (;it2.current();++it2) WindowMenu->removeItem(it2.current()->Index+MDIWINDOW_ID);
		FileWindow	*wind = new FileWindow(KOptions->Style,currentWindow());
		WindowList->clear();
		delete MDIMgr;
		wind->FileView = createFileView(wind->Style);
		WindowList->append(wind);
		WindowList->first()->FileView->activate(true);
		MenuBar->setItemEnabled(WINDOWS_ID,FALSE);
		ViewToolBar->setItemEnabled(SINGLE_ID,TRUE);
		ViewToolBar->setItemEnabled(SPLITV_ID,TRUE);
		ViewToolBar->setItemEnabled(SPLITH_ID,TRUE);
		ViewToolBar->setButton(SINGLE_ID,TRUE);
		WindowList->first()->FileView->show();
	}
	FileWindowListIterator	it3(*WindowList);
	for (;it3.current();++it3) it3.current()->updateList();
	MenuBar->setItemChecked(KOptions->ViewType,FALSE);
	KOptions->ViewType = SINGLE_ID;
	MenuBar->setItemChecked(KOptions->ViewType,TRUE);
	MenuBar->setItemEnabled(VIEWTYPE_ID,!KOptions->MultipleView);
}

void KExplorer::toggleAutoTile()
{
	KOptions->AutoTile = !KOptions->AutoTile;
	MenuBar->setItemChecked(AUTOTILE_ID,KOptions->AutoTile);
	MDIMgr->setAutoTile(KOptions->AutoTile);
}

void KExplorer::openProtocol()
{
	DirViewItem	*item = (TmpDevice ? TmpDevice : DirectoryTree->popupItem());
//	Device	*dev = findDevice(item->Label.data());
	initBusy();
	KURL		url(item->Address.data());
	Protocol	*prot = Manager->searchProtocol(url);
	if (Manager->initProtocol(prot)) {
		item->Type = DirMount;
		DirectoryTree->update();
	}
	finishBusy();
	TmpDevice = 0;
}

void KExplorer::closeProtocol()
{
	DirViewItem	*item = (TmpDevice ? TmpDevice : DirectoryTree->popupItem());
//	Device	*dev = findDevice(item->Label.data());
	initBusy();
	KURL		url(item->Address.data());
	Protocol	*prot = Manager->searchProtocol(url);
	if (Manager->finishProtocol(prot)) {
		finishBusy();
		item->Type = DirNormal;
		DirectoryTree->clearItem(item,true,true);
		DirectoryTree->update();
		checkUpdateWindow(0,0,item->getPath());
	}
	else finishBusy();
	TmpDevice = 0;
}

void KExplorer::recreateWindows(QWidget *parent, FileWindowList *list, bool limitToOne)
{
	if (limitToOne) {
		FileWindow	*wnd = new FileWindow(KOptions->Style,currentWindow());
		wnd->FileView = createFileView((currentWindow() ? currentWindow()->Style : KOptions->Style),parent);
//		wnd->FileView->setLabelString(wnd->Url.data());
		list->append(wnd);
	}
	else {
		FileWindowListIterator	it(*WindowList);
		for (;it.current();++it) {
			FileWindow	*wnd = new FileWindow(KOptions->Style,it.current());
			wnd->FileView = createFileView(it.current()->Style,parent);
//			wnd->FileView->setLabelString(wnd->Url.data());
			list->append(wnd);
		}
	}
}

void KExplorer::singleView()
{
	if (KOptions->ViewType == SINGLE_ID) {
		ViewToolBar->setButton(KOptions->ViewType,TRUE);
		return;
	}
	FileWindow	*wnd = currentWindow();
	if (wnd == WindowList->first()) wnd = WindowList->last();
	else wnd = WindowList->first();
	MenuBar->setItemChecked(KOptions->ViewType,FALSE);
	ViewToolBar->setButton(KOptions->ViewType,FALSE);
	KOptions->ViewType = SINGLE_ID;
	MenuBar->setItemChecked(KOptions->ViewType,TRUE);
	ViewToolBar->setButton(KOptions->ViewType,TRUE);
	WindowList->removeRef(wnd);
	windowSelected(WindowList->first());
	RightSubView->moveToFirst(WindowList->first()->FileView);
}

void KExplorer::splitWindow(int type)
{
	if (KOptions->ViewType == type) {
		ViewToolBar->setButton(KOptions->ViewType,TRUE);
		return;
	}
	bool	needCreate = (KOptions->ViewType == SINGLE_ID);
	MenuBar->setItemChecked(KOptions->ViewType,FALSE);
	ViewToolBar->setButton(KOptions->ViewType,FALSE);
	KOptions->ViewType = type;
	MenuBar->setItemChecked(KOptions->ViewType,TRUE);
	ViewToolBar->setButton(KOptions->ViewType,TRUE);
	RightSubView->setOrientation((type == SPLITV_ID ? KSplitter::Vertical : KSplitter::Horizontal));
	if (needCreate) {
		FileWindow	*wnd = new FileWindow(KOptions->Style,WindowList->first());
		wnd->FileView = createFileView(WindowList->first()->Style);
		kapp->processEvents();
		RightSubView->setSeparatorPos((type == SPLITV_ID ? RightSubView->height()/2 : RightSubView->width()/2));
		WindowList->append(wnd);
		WindowList->last()->updateList();
		FileView = WindowList->first()->FileView;
		windowSelected(WindowList->last());
	}
}

void KExplorer::splitVertical()
{ splitWindow(SPLITV_ID);}

void KExplorer::splitHorizontal()
{ splitWindow(SPLITH_ID);}

void KExplorer::dropOnFileView(QDropEvent *e, FileInfo *fi, FileViewWidget *w)
{
	URLList.clear();
	QUrlDrag::decode(e,URLList);
	if (fi) TmpAddress = fi->absFilePath().data();
	else {
		FileWindow	*wnd = getWindow(w,WindowList);
		TmpAddress = wnd->Url.data();
	}
	Pop1->clear();
	Pop1->insertItem(i18n("Move"),this,SLOT(moveDrag()));
	Pop1->insertItem(i18n("Copy"),this,SLOT(copyDrag()));
	Pop1->insertSeparator();
	Pop1->insertItem(i18n("Link"),this,SLOT(mainCallback()));
	Pop1->popup(QCursor::pos());
}

void KExplorer::showImagePreview(bool show)
{
	if (show) {
		Preview = new PreviewArea(MainRightView);
		connect(Preview,SIGNAL(previewClicked()),SLOT(showImagePreviewFullSize()));
		kapp->processEvents();
		MainRightView->setSeparatorPos(MainRightView->height()-80);
		// maybe a picture is already selected, so show preview now:
		emit selectionChanged();
		// Show it if kruiser main window is visible
		if (isVisible()) Preview->show();
	}
	else if (Preview) { delete Preview; Preview = 0;}
	MenuBar->setItemChecked(PREVIEW_ID,show);
	ViewToolBar->setButton(PREVIEW_ID,show);
}

void KExplorer::toggleImagePreview()
{
	KOptions->ImagePreview = !KOptions->ImagePreview;
	showImagePreview(KOptions->ImagePreview);
}

void KExplorer::showImagePreviewFullSize()
{
	if (Preview) {
		FileInfo	*fi = Preview->getFileInfo();
		if (fi) openItem(fi);
	}
}

void KExplorer::setURLCaption(const char *url)
{
	QString	Url(url);
	KURL::decodeURL(Url);
	setCaption(Url.data());
	URLCombo->setEditText(url);
}

bool KExplorer::queryClose()
{
	saveConfiguration();
	saveDevices();
	if (Busy) {
		QMessageBox::warning(this,i18n("Warning"),i18n("Kruiser is busy. Abort current job before closing."),QMessageBox::Ok | QMessageBox::Default,0);
		return false;
	}
	delete Manager;
	return true;
}

void KExplorer::changeDeviceProperties()
{
	Device	*dev = findDevice(DirectoryTree->popupItem()->Label.data());
	DeviceDlg	*dlg = new DeviceDlg(this);
	dlg->setupDevice(dev);
	if (dlg->exec()) {
		// First remove the current device
		TmpDevice = 0;
		closeProtocol();
		Manager->deleteProtocol(dev->protocol());
		int	pos = DeviceList.findRef(dev);
		DeviceList.removeRef(dev);

		// Then create the new device
		QString		pathStr(dlg->path());
		processPath(pathStr);
		Protocol	*prot = Manager->createProtocol(dlg->type(),pathStr.data(),dlg->host(),dlg->login(),dlg->passwd(),dlg->port());
		QString		icon(dlg->icon()),iconSel;
		if (icon == "folder.xpm") iconSel = "folder_open.xpm";
		else iconSel = icon.data();
		Device	*newDev = new Device(dlg->name(),icon.data(),prot,dlg->keep(),pathStr.data(),dlg->host(),dlg->login(),dlg->passwd(),dlg->port());
		DeviceList.insert(pos,newDev);

		// Finally change the device tree item properties
		DirectoryTree->popupItem()->Type = ((prot->canBeMounted() && prot->isAccesible()) ? DirMount : DirNormal);
		DirectoryTree->popupItem()->Label = dlg->name();
		DirectoryTree->popupItem()->Address = newDev->path();
		DirectoryTree->popupItem()->Icon = IconLoader->loadMiniIcon(icon.data());
		DirectoryTree->popupItem()->IconSel = IconLoader->loadMiniIcon(iconSel.data());
		DirectoryTree->updateCell(DirectoryTree->popupItem(),true);
		saveDevices();
	}
	delete dlg;
}

void KExplorer::updateTreeView()
// Update the tree view by rescanning all visible tree items under local devices
// which are not mountable. Non-visible tree items are discarded (their will be
// reloaded when expanding the item again.
{
	// current -> first local device
	DirViewItem	*device = DirectoryTree->rootItem()->Childs->first()->Childs->first();
	DirectoryTree->setUpdatesEnabled(false);
	while (device) {
		Device	*dev = findDevice(device->Label.data());
		if (dev && dev->protocol()->isAccesible()) {	// Don't rescan non accessible devices (like mountable devices)
			DirViewItem	*current = device;
			while (current->Depth > 1) {
				if (!current->Opened || current->Childs->count() == 0) {
					current->Opened = false;
					DirectoryTree->clearItem(current);
					if (current->Depth == 2) current = current->ParentItem;
					else goto next;
				}
				else {
					scanSubDirectories(current);
					if (current->Childs->first()) current = current->Childs->first();
					else goto next;
				}
				continue;
next:				if (current->getNext() == 0) {
					while (current->Depth > 1 && current->getNext() == 0) current = current->ParentItem;
					current = current->getNext();
				}
				else current = current->getNext();
			}
		}
		device = device->getNext();
	}
	// Now we're checking all mountable device for they mount state. If they're not mounted
	// simply clear all subitems and set type to DirNormal.
	QListIterator<Device>	it(DeviceList);
	for (;it.current();++it)
		if (it.current()->protocol()->canBeMounted() && !it.current()->protocol()->isAccesible()) {
			device = DirectoryTree->findItem(it.current()->treePath().data());
			device->Opened = false;
			device->Type = DirNormal;
			DirectoryTree->clearItem(device);
			// Now check if some windows was displaying a directory on this
			// and eventually change the url shown to avoid remounting.
			checkUpdateWindow(0,0,device->getPath());
			// Finally check if the device is the current item in the tree view
			if (DirectoryTree->currentItem() == device) DirectoryTree->setCurrentItem(DirectoryTree->rootItem(),true);
		}
	DirectoryTree->setUpdatesEnabled(true);
	DirectoryTree->updateView();
}

void KExplorer::detailPropertiesChanged()
{
	FileViewWidget	*widget = fileView();
	widget->getColumns(KOptions->ColType,KOptions->ColWidth);
	widget->getDateFormat(KOptions->DateFormat);
	widget->getDetailSelectionMode(KOptions->DetailSelectionMode);
}

bool KExplorer::eventFilter(QObject *, QEvent *e)
{
	switch (e->type()) {
	   case Event_MouseButtonPress:
	   case Event_MouseButtonRelease:
	   case Event_MouseButtonDblClick:
	   case Event_MouseMove:
	   case Event_FocusIn:
	   case Event_FocusOut:
	   case Event_KeyPress:
	   case Event_KeyRelease:
		return true;
	   case Event_Initialize:
		initialize(((QInitEvent*)e)->url());
		return true;
	   default: return false;
	}
}

void KExplorer::setGlobalFilter(QWidget *widget, bool install, QList<QObject> *except)
{
	QList<QObject> *list = (QList<QObject> *)(widget->children());
	if (list){
		unsigned int	i = (widget->isA("QSplitter") ? 1 : 0);
		for (; i< list->count(); i++){
			if (list->at(i)->isWidgetType()==false || (except && except->findRef(list->at(i)) != -1))
				continue;
			QWidget *w = (QWidget *)list->at(i);
			setGlobalFilter(w,install,except);
		}
	}
	if (install) {
		widget->installEventFilter(this);
		widget->setCursor(waitCursor);
	}
	else {
		widget->removeEventFilter(this);
		widget->setCursor(arrowCursor);
	}
}

void KExplorer::message1(const char *msg)
{
	Status1Info->setText(msg);
	QApplication::flushX();
}

void KExplorer::addToHistory(const char *url)
{
	// Only update if the url is already in the history
	if (HistoryList.find(url) == -1) {
		if ((int)(HistoryList.count()) == KOptions->HistorySize) HistoryList.removeLast();
		HistoryList.insert(0,url);
		constructHistoryMenu();
		URLCombo->refreshHistory();
	}
}

void KExplorer::constructHistoryMenu()
{
	// First clear the existing menu
	HistoryMenu->clear();
	// Reconstruct the menu
	QStrListIterator	it(HistoryList);
	for (int i=1;it.current();++it,i++) HistoryMenu->insertItem(it.current(),HISTORYMENU_ID+i);
}

void KExplorer::loadBookmarks()
{
	QString		Filename = KApplication::localkdedir() + "/share/apps/kruiser/bookmarks";
	QFile		f(Filename.data());
	// First clear bookmark list
	BookmarkList.clear();
	// Open the bookmark file
	if (!f.exists()) return;
	if (!f.open(IO_ReadOnly)) {
		QMessageBox::critical(this,i18n("Error"),i18n("Unable to read bookmark file."),QMessageBox::Ok | QMessageBox::Default,0);
		return;
	}
	// Parse bookmark file
	QTextStream	t(&f);
	QString		Buffer;
	QStrList	list;
	list.setAutoDelete(true);
	while (!t.eof()) {
		Buffer = t.readLine().data();
		int	p1(0),p2;
		list.clear();
		for (int i=0;i<5;i++,p1=p2+1) {
			p2 = Buffer.find(',',p1);
			list.append(Buffer.mid(p1,p2-p1).data());
		}
		BookmarkList.append(new BookmarkItem(list.at(0),list.at(1),QString(list.at(2)).toInt(),list.at(3),QString(list.at(4)).toInt()));
	}
	// Close bookmark file
	f.close();
	// Reconstruct bookmark menu
	constructBookmarkMenu();
}

void KExplorer::saveBookmarks()
{
	QString		Filename = KApplication::localkdedir() + "/share/apps/kruiser/bookmarks";
	QFile		f(Filename.data());
	// Open bookmark file
	if (!f.open(IO_WriteOnly)) {
		QMessageBox::critical(this,i18n("Error"),i18n("Unable to write bookmark file."),QMessageBox::Ok | QMessageBox::Default,0);
		return;
	}
	// Parse bookmarks and save them
	QString		Buffer;
	QListIterator<BookmarkItem>	it(BookmarkList);
	for (;it.current();++it) {
		Buffer.sprintf("%s,%s,%d,%s,%d,\n",it.current()->Bookmark.data(),it.current()->Name.data(),it.current()->AccelKey,it.current()->IconName.data(),it.current()->Status);
		f.writeBlock(Buffer.data(),Buffer.length());
	}
	// Close bookmark file
	f.close();
}

void KExplorer::constructBookmarkMenu()
{
	// clear bookmark menu and bookmark accel
	BookmarkMenu->clear();
	BookmarkAccel->clear();
	// clear all entries in URL toolbar
	QListIterator<int>	URLit(BookmarkToolList);
	for (;URLit.current();++URLit) URLToolBar->removeItem(*(URLit.current()));
	BookmarkToolList.clear();
	// Add bookmark management entries
	BookmarkMenu->insertItem(i18n("Add bookmark"),BOOKMARKMENU_ID+1);
	BookmarkAccel->insertItem(CTRL+SHIFT+Key_D,BOOKMARKMENU_ID+1);
	BookmarkMenu->insertItem(i18n("Edit bookmarks..."),BOOKMARKMENU_ID+2);
	BookmarkMenu->insertSeparator();
	// Then recreate it from BookmarkList
	QListIterator<BookmarkItem>	it(BookmarkList);
	int		toolbarPos(2);
	for (int i=3;it.current();++it,i++) {
		if (it.current()->Status & BOOKMARK_MENU) BookmarkMenu->insertItem(*(IconLoader->loadMiniIcon(it.current()->IconName.data())),it.current()->Name.data(),BOOKMARKMENU_ID+i);
		if (it.current()->Status & BOOKMARK_TOOL) {
			URLToolBar->insertButton(*(IconLoader->loadMiniIcon(it.current()->IconName.data())),BOOKMARKMENU_ID+i,true,it.current()->Name.data(),toolbarPos++);
			BookmarkToolList.append(new int(BOOKMARKMENU_ID+i));
		}
		if (it.current()->AccelKey) BookmarkAccel->insertItem(CTRL+SHIFT+it.current()->AccelKey,BOOKMARKMENU_ID+i);
	}
}

void KExplorer::addBookmark()
{
	QString		url(currentWindow()->Url);
	BookmarkList.append(new BookmarkItem(url.data()));
	constructBookmarkMenu();
}

void KExplorer::editBookmarks()
{
	BookmarkDialog	*dlg = new BookmarkDialog(this);
	dlg->readBookmarks(BookmarkList);
	if (dlg->exec()) {
		dlg->writeBookmarks(BookmarkList);
		constructBookmarkMenu();
	}
	delete dlg;
}

void KExplorer::historyEnterPressed()
{
	QString	HistoryText = URLCombo->currentText();
	if (HistoryText[0] == '/') HistoryText.insert(0,"file:");
	KURL	Url(HistoryText.data());
	goToDir(Url);
}

void KExplorer::rescanNetwork()
{
	DirViewItem	*item = DirectoryTree->findItem(DESKTOP_NETWORKNEIGHBORHOOD);
	DirectoryTree->clearItem(item);
	item->Opened = true;
	KURL	url(item->Address.data());
	Manager->searchProtocol(url)->refresh();
	scanSubDirectories(item);
}

void KExplorer::toggleShowTreeView()
{
	KOptions->ShowTreeView = !KOptions->ShowTreeView;
	MenuBar->setItemChecked(TREEVIEW_ID,KOptions->ShowTreeView);
	ViewToolBar->setButton(TREEVIEW_ID,KOptions->ShowTreeView);
	if (KOptions->ShowTreeView) {
		MainView->setSeparatorPos(KOptions->SavedDirWidth);
		LeftView->show();
	}
	else {
		MainView->setSeparatorPos(0);
		LeftView->hide();
	}
}

void KExplorer::protocolClosed(Protocol *prot)
{
	cout << prot->prefix() << " has been closed" << endl;
	Device	*dev = findDevice(prot);
	if (dev) TmpDevice = DirectoryTree->findItem(dev->treePath());
	// if not then we're probably in the case of "network neighborhood" share device
	else TmpDevice = DirectoryTree->findItemFromURL(prot->prefix().data(),DESKTOP_NETWORKNEIGHBORHOOD);
	// now we've got the item, just update it in the tree view
	TmpDevice->Type = DirNormal;
	DirectoryTree->clearItem(TmpDevice,true,true);
	DirectoryTree->update();
	checkUpdateWindow(0,0,TmpDevice->getPath());
	TmpDevice = 0;
}

void KExplorer::startRenaming()
{
	fileView()->startRenaming(fileView()->getSelected()->first());
}

void KExplorer::formatDevice()
{
	system("kfloppy&");
}

//-------------------------------------------------------------------------------------------------

FileWindow::FileWindow(FileViewWidget *view, int style, KMDIWindow *wnd = 0)
	: FileView(view), Style(style), Window(wnd)
{
	FileList = new FileInfoList;
	FileList->setAutoDelete(TRUE);
	Sorting = byName;
	SortDirection = 1;
	UpdateFlag = false;
}

FileWindow::FileWindow(int defaultStyle, FileWindow *wnd)
{
	FileList = new FileInfoList;
	FileList->setAutoDelete(TRUE);
	if (wnd) {
		Sorting = wnd->Sorting;
		SortDirection = wnd->SortDirection;
		Style = wnd->Style;
		Url = wnd->Url.data();
		TreePath = wnd->TreePath.data();
		FileInfoListIterator	it(*(wnd->FileList));
		for (;it.current();++it) {
			FileInfo	*fi = new FileInfo(*(it.current()));
			fi->setIndex(it.current()->index());
			FileList->append(fi);
		}
	}
	else {
		Sorting = byName;
		SortDirection = 1;
		Style = defaultStyle;
	}
	Index = 0;
	FileView = 0;
	Window = 0;
	UpdateFlag = false;
}

FileWindow::~FileWindow()
{
	delete FileList;
	if (FileView) delete FileView;
}

void FileWindow::setView(FileViewWidget *view, int style)
{
	FileView = view;
	if (Window) Window->setView(view);
	Style = style;
}

void FileWindow::updateList(bool keepSel)
{ FileView->setFileList(FileList,keepSel); FileView->setLabelString(Url.data()); UpdateFlag = false;}

void FileWindow::clearList()
{ FileView->clearList(); FileList->clear();}

void FileWindow::setUrl(const char *url)
{
	Url = url;
	if (Window) Window->setCaption(url);
	FileView->setLabelString(url);
}
