#include "imageloader.h"
#include <kurl.h>
#include <qstring.h>
#include <qimage.h>
#include <dither.h>
#include <kapp.h>
#include <iostream.h>
#include <kurl.h>

void* __thread_start(void *arg)
{
	pthread_cleanup_push(__thread_cleanup,arg);
	((ImageLoader*)arg)->thread_start();
	pthread_cleanup_pop(0);
	pthread_detach(pthread_self());
	return 0;
}

void __thread_cleanup(void *arg)
{
	((ImageLoader*)arg)->thread_cleanup();
}

ImageLoader::ImageLoader(QWidget *parent, const char *name)
	: QObject(parent,name)
{
	EventList.setAutoDelete(true);
	installEventFilter(this);
	Loading = Running = false;
}

ImageLoader::~ImageLoader()
{
	stopLoading(true);
}

void ImageLoader::loadMiniImage(FileInfo *fi, QWidget *w, bool threaded)
{
	fi->setMiniImageState(FileInfo::Requested);
//	if (!threaded) loadMiniImageInternal(fi);
//	else {
		ImageLoadEvent	*e = new ImageLoadEvent(fi,w,threaded);
		EventList.append(e);
		if (EventList.count() > 0 && !Running) {
			Running = true;
			startTimer(50);
			nextImage();
		}
//	}
}

void ImageLoader::startLoading()
{
	Running = true;
	ImageLoadEvent	*e = ((int)(EventList.count()) > 0 ? EventList.take(0) : 0);
	if (!e) {
		warning("nothing to load");
		Running = Loading = false;
		killTimers();
		return;
	}
	if (!initLoading(e)) {
		warning("don't need to load image");
		cantLoad(e);
		return;
	}
	Loading = true;
	loadImageInternal(e);
}

void ImageLoader::stopLoading(bool clean)
{
	if (Loading) {
		pthread_cancel(ThreadID);
		pthread_join(ThreadID,NULL);
		Loading = Running = false;
		killTimers();
		ImageLoadedList.clear();
	}
	if (clean) EventList.clear();
}

void ImageLoader::cantLoad(ImageLoadEvent *e)
{
	e->fileInfo()->setMiniImageState(FileInfo::Loaded);
	kapp->postEvent(e->widget(),e);
	// Try to load next image
	Loading = false;
	nextImage();
}

bool ImageLoader::eventFilter(QObject*, QEvent *e)
{
	switch (e->type()) {
	   case Event_NextImage:
		startLoading();
		return true;
	   case Event_ImageLoad:
		{
		Loading = false;
		ImageLoadEvent	*ev = new ImageLoadEvent(*((ImageLoadEvent*)e));
		finishLoading(ev);
		kapp->postEvent(ev->widget(),ev);
		nextImage();
		return true;
		}
	}
	return false;
}

void ImageLoader::nextImage()
{
cout << "timer event" << endl;
	if (!Loading) {
		NextImageEvent	*e = new NextImageEvent;
		kapp->postEvent(this,e);
	}
}

void ImageLoader::thread_start()
{
	InternalImage.load(InternalPath.data());
	ImageLoadedList.append(InternalEvent);
}

void ImageLoader::thread_cleanup()
{
}

void ImageLoader::timerEvent(QTimerEvent *e)
{
	while (ImageLoadedList.count() > 0) {
		ImageLoadEvent	*e = ImageLoadedList.take(0);
		kapp->postEvent(this,e);
	}
}

// Image loading stuff

bool ImageLoader::initLoading(ImageLoadEvent *e)
{
	FileInfo	*fi = e->fileInfo();
	image_path=QString(fi->absFilePath());
	image_url=KURL(image_path);

        // Do some tests, whether a thumbnail should be created or not
	// Maybe some tests could be droped, but so we are on the save side
      	if (((fi->miniImageState() != FileInfo::Loaded))
	    && fi->isLocal() && fi->isFile()
	    && (image_path.contains("file:")==1)
	    && (!image_url.hasSubProtocol()))
		{
		mini_image_outdated = false,
		mini_image_file_exists= false,
		xvpics_dir_exists=false;

                // try to check the mimetype
		// this should speed up the processing of "large" directories very much
		// this test makes only sense, if we don't try to create thumbnails for
		// files which have a unknown MimeType
		// of course we may loose thumbnails even if we could create them
		// if this feature is unwanted just uncomment the unwanted if-branch
		if (fi->mimeType())
			{
			// only process files, whose mimetype includes "image"
			if (fi->mimeType()->MimeName.contains("image/")==0)
				{
				// no image mime-type
				goto end;
				}
			}
		else	
			{
			// No mime type information found
			goto end;
			}

		// if path to image contains ".xvpics" abort immediately
		// don't create thumbnail of thumbnail of thumbnail....
		if (image_path.find(".xvpics", 0) !=-1)
			{
			goto end;
			}

		// remove a "/", if last character is "/"
		// needed for the following path-manipulations
		if (image_path.findRev("/")==(int) image_path.length())
		       {
		       image_path.resize(image_path.length()-1);
		       }

// MG
		mini_image_path = image_url.path();
// MG

	      	int last_backslash = mini_image_path.findRev("/");

	      	mini_image_path.insert(last_backslash+1, ".xvpics/");			

		xvpics_path = mini_image_path;

		last_backslash = xvpics_path.findRev("/");
		xvpics_path.truncate(last_backslash+1);

	      	struct stat     st;
	
		// check if xvpics-dir exists
		// this should speed up the function if we are in a "large" directory without thumbnails
		// of course we could try to cache, if there exists a xvpics-dir, but a good OS will do this for us
		// keep in mind: the second lstat is much more difficult to cache for the OS
		if (lstat(xvpics_path, &st)==0)
		    {
		    xvpics_dir_exists=true;

		    // Does file with corresponding file-name exists ?
		    if (lstat(mini_image_path,&st)==0)
		        {
		        // Yes
		        mini_image_file_exists=true;
			
			QDateTime mini_image_Date;

	          	mini_image_Date.setTime_t(st.st_mtime);

		  	// Is thumbnail outdated ?
		  	if (mini_image_Date >= fi->lastModified())
		    		{
		    		// No,
				// then try to load it as "XV-thumbnail"
				// different image.formats will not be loaded

		      		mini_image.load(mini_image_path,"XV");

				fi->setMiniImage(mini_image);
			
				cout << "not outdated" << endl;
				goto end;
				}
			else
				{
				cout << "outdated" << endl;
				mini_image_outdated = true;
		     		}	
			}
		    }
		}
	else goto end;

	if (!mini_image_file_exists || mini_image_outdated) return true;
end:	return false;
}

void ImageLoader::finishLoading(ImageLoadEvent *e)
{
	FileInfo	*fi = e->fileInfo();
	QImage 	image = InternalImage, ditheredImage;

	if (image.isNull()) {
		cout << "loaded a null image, probably unrecognized image format" << endl;
		return;
	}

        double  wexpand = (double) image.width() / (double) 80,
		hexpand = (double) image.height() / (double) 60;
			
	if (wexpand >= 1.0 || hexpand >= 1.0) // don't expand small images  !
		{
		int 	neww, newh;

		if (wexpand > hexpand)
			{
			neww = (int) (image.width() / wexpand + 0.5);
			newh = (int) (image.height() / wexpand + 0.5);
			}
		else
			{
			neww = (int) (image.width() / hexpand + 0.5);
			newh = (int) (image.height() / hexpand + 0.5);
			}
			image=image.smoothScale(neww, newh);
		}

	// Do  we want to save the image ?
	// 2 = Allways; 0 = Never; 1 = Existing
	kapp->getConfig()->setGroup("Configuration");
	int	saving = kapp->getConfig()->readNumEntry("MiniImageSaving");
	int	image_size = kapp->getConfig()->readNumEntry("ImageSize");
	if (((saving==2) || ((saving==1) && xvpics_dir_exists))
// MG
	    && ((image_size==-1) || ((int)(fi->size())>image_size)))
// MG
	        {
		// Yes !

		// create .xvpics directory
		// Do we already have a .xvpics
		if (!xvpics_dir_exists)
		       {
			cout << "Don't have xvpics-dir to save thumbnail !" << endl;
		       }

		// only finish saving if xvpics_dir exists
		else
		       {
		       // at first dither for a better result
				
// Unfortunately the dithering provided by qt is far from optimal for dithering
// 24/32 8-8-8(rgb)bit to 3-3-2 (rgb); we would be happy if we could set the appropiate colour-table
// for this operation; this would yield much better miniImages with the same quality as xv
// maybe I will code a appropiate dithering function in the future;
// as we get no better thumbnails with dithering, don't do it !!
// Yes, we are happy ! the kde-libary provides the needed function, but only for depth!=8

cout << "dithering..." << endl;				
			if (image.depth()>8)
			    {
			    QColor table[256];
		            int j;

			    // set the correct color table, which is implicit defined by xv-thumbnail format
			    for (j=0; j<256; j++)
			        {
				static int b_255_3[]= {0,85,170,255},  // index*255/3
					  rg_255_7[]={0,36,72,109,145,182,218,255}; // index *255/7
						
				table[j]=QColor(rg_255_7[((j >> 5) & 0x07)], rg_255_7[((j >> 2) & 0x07)],
						b_255_3[((j >> 0) & 0x03)]);

				}
				
			    // create K Floyd-Steinber-Dithering Class
			    kFSDither kdither = kFSDither (table, 256);
				
			    ditheredImage = kdither.dither(image);
			    }
			else
			    {
			    ditheredImage = image.convertDepth(8, PreferDither);
			    }
		
	     		// try to save mini_image !
			ditheredImage.save(mini_image_path, "XV");
		        }
		}
		
cout << "converting..." << endl;
        mini_image.convertFromImage( image, 0);
	fi->setMiniImage(mini_image);
	fi->setMiniImageState(FileInfo::Loaded);	
}

void ImageLoader::loadImageInternal(ImageLoadEvent *e)
{
	InternalPath = image_url.path();
	InternalEvent = e;
	InternalImage.reset();
	// Problem here with xpm and xbm image, interfere with X system and can cause crash.
	// As it is probably a small image, it's probably not a problem to load it synchronously.
	KMimeExtension	*t = e->fileInfo()->mimeType();
	if (!e->threaded() || (t && (t->MimeName == "image/x-xpm" || t->MimeName == "image/x-xbm")))
		thread_start();
	else if (pthread_create(&ThreadID,0,__thread_start,this) == 0) ;
//		pthread_detach(ThreadID);
	else warning("unable to start loading thread");
}