#ifndef _FTPPROT_H_
#define _FTPPROT_H_

#include <config.h>

#include "protocol.h"
#include "mystrlist.h"

#define	FTP_OK		0	// 2xx responses
#define	FTP_ERROR	-1	// 5xx responses
#define	FTP_BROKEN	-2	// sock = -1
#define FTP_CLOSED	-3	// 4xx responses
#define	FTP_COMMERROR	-3	// 4xx responses
#define	FTP_NOTCONN	-4
#define	FTP_CONNERROR	-5	// error while trying to connect
#define	FTP_SOCKERROR	-6	// general socket error

class FtpProtocol : public Protocol
{
public:
	FtpProtocol(const char *path = 0, const char *host = 0, const char *login = 0, const char *passwd = 0, const char *port = 0);
	virtual ~FtpProtocol();

	const FileInfoList* entryInfoList(bool hidden, bool dirsOnly, bool showArchive = FALSE);
	const QStrList* entryList(bool hidden, bool dirsOnly, bool showArchive = FALSE);
  	bool mkdir(const char *pathname);
	QString absPath();
	bool setPath(const char *pathname);
	QString dirName();
	bool remove(const char *filename, ProgressDlg *dlg = 0);
	bool rmdir(const char *dirname, ProgressDlg *dlg = 0);
	bool isRoot();
	bool rename(const char *src, const char *dest);
	bool exists(const char *filename);
	bool chmod(const char *filename, int perm);
	bool chown(const char *filename, const char *owner, const char *group);

	bool copyToProtocol(const char *filename, const char *targetDir = 0, bool move = FALSE, ProgressDlg *dlg = 0);
	bool copyFromProtocol(const char *filename, const char *targetDir, bool move = FALSE, ProgressDlg *dlg = 0);
	bool init();
	bool finish();
	bool cleanup();
	bool matchURL(KURL url);
	const char* currentURL();
	bool isLocal();
	unsigned long long freeSize(const char *dirname);
	bool hasChilds(const char *dirname);
	FileInfo* getInfo(KURL& url);
	bool shutDown();
	void refresh() { updateFlag = filterFlag = true;}
	bool check();

	bool isAccesible();
	const char* menuEntry();

	const char* passwd();
	const char* user() { return (Login.isEmpty() ? "" : Login.data());}
	bool needLogin();
	void setLogin(const char *user, const char *pwd);
	const char* getTempFile(KURL* url, ProgressDlg *dlg = 0);

protected:
	bool fillBuffer();
	QString readLine(bool dontblock = false);
	void flushBuffer();
	int readAnswer(bool dontblock = false);
	void sendCommand(const char *cmd, const char *args = 0);
	void connectionClosed();
	int setErrorMsg(int result);
	int setupDataConnection();
	int acceptDataConnection(int sData, bool writeFlag = FALSE);
	void readDataBuffer();
	void download();
	void upload();

	int ftpConnect();
	int ftpLogin();
	int ftpPwd();
	int ftpCd(const char *path);
	int ftpList();
	int ftpMkDir(const char *dirName);
	int ftpGet(const char *src, const char *dest);
	int ftpGetDir(const char *src, const char *dest);
	int ftpPut(const char *src, const char *dest);
	int ftpPutDir(const char *src, const char *dest);
	int ftpRename(const char *src, const char *dest);
	int ftpRm(const char *filename);
	int ftpRmDir(const char *dirname);

	bool updateEntries();
	bool updateFilteredEntries(bool hidden, bool dirsOnly, bool showArchive = FALSE);

	void cleanCache();

protected:
	QString		Host;
	QString		Path;
	QString		Login;
	QString		Passwd;
	int		Port;

	int		sock;
	int		dataSock;
	int		file;
	QString		CurrentPath;
	FileInfoList	*entries, *rawEntries;
	QStrList	*namedEntries;
	bool		updateFlag, filterFlag;
	QString		Buffer;
	QString		AnswerBuffer;
	QString		DataBuffer;
	int		posBuffer;
	ulong		totalBytes, downBytes;
	ProgressDlg	*dialog;
	bool		UnixType;
	bool		Aborted;
	bool		AcceptResume;
	MyStrList	TempFiles;
};

inline bool FtpProtocol::isRoot()
{ return (CurrentPath == "/");}

inline QString FtpProtocol::absPath()
{ return CurrentPath;}

inline bool FtpProtocol::isLocal()
{ return FALSE;}

inline unsigned long long FtpProtocol::freeSize(const char *)
{ return (unsigned long long)0;}

inline bool FtpProtocol::hasChilds(const char *dirname)
{ return TRUE;}

inline const char* FtpProtocol::passwd()
{ return (Passwd.isEmpty() ? "" : Passwd.data());}

inline bool FtpProtocol::needLogin()
{ return (!Login.isEmpty() && Passwd.isEmpty());}

inline void FtpProtocol::setLogin(const char *user, const char *pwd)
{ Login = user; Passwd = pwd;}

inline bool FtpProtocol::chown(const char *filename, const char *owner, const char *group)
{ return false;}

#endif
