#ifndef _OPTIONSSMB_H_
#define _OPTIONSSMB_H_

#include <qwidget.h>
#include <qlistview.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qlist.h>
#include <qcombobox.h>
#include <qcheckbox.h>

class OptionsSMB : public QWidget
{
	Q_OBJECT;

public:
	OptionsSMB(QWidget *parent = 0, const char *name = 0);
	~OptionsSMB();

	void readSMB();
	void writeSMB();

public slots:
	void addClicked();
	void removeClicked();
	void updateClicked();
	void selectionChanged(QListViewItem*);

protected:
	void resizeEvent(QResizeEvent*);
	void clearAll();

	QListView* selectView() { return (IPType->currentItem() == 0 ? BroadCastListView : ComputerListView);}
	QList<QListViewItem>* selectList() { return (IPType->currentItem() == 0 ? &BroadCastList : &ComputerList);}

public:
	QListView	*BroadCastListView;
	QListView	*ComputerListView;
	QListView	*CurrentView;
	QList<QListViewItem>	BroadCastList, ComputerList;
	QLineEdit	*IP[4];
	QLabel		*IPLabel, *SambaLabel;
	QPushButton	*Add, *Remove, *Update;
	bool		Modified;
	QComboBox	*SambaVersion;
	QComboBox	*IPType;
	QCheckBox	*ShowHiddenShares;
};

#endif