/***************************************************************************
                          krtcinfo.cpp  -  description                              
                             -------------------                                         
    begin                : Fri Jun 11 14:49:33 CEST 1999
                                           
    copyright            : (C) 1999 by Enrico Schulz                         
    email                : emmy@online.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "krtcinfo.h"
#include <qfile.h>
#include <qtimer.h>

Krtcinfo::Krtcinfo(QWidget*parent,const char* name):QWidget(parent,name){
  initializewindow();
}
Krtcinfo::~Krtcinfo(){
}

void Krtcinfo::readfromfile(KTabListBox *tablistbox)
{
  short split;
  char splitchar = ': ';
  char buf[512];
  tablistbox->setSeparator(splitchar);
  QFile *file = new QFile("/proc/rtc");

  if (!file->open(IO_ReadOnly))
  {
    delete file;
  }
  split = 0;
  while (file->readLine(buf, sizeof(buf)-1)>0)
  {
    if (strlen(buf))
    {
      char *p=buf;
      if (splitchar!=0)
      while (*p)
      {
        if ((*p==splitchar)&&(split==0))
        {
          *p++ = ' ';
          while (*p == ' ') ++p;
          *(--p) = splitchar;
          ++p;
          split = 1;
        }
        else
        {
          ++p;
//          split = 0;

        }
      }
      tablistbox->insertItem(buf);
      split=0;
    }
  }
  file->close();
  delete file;
}

void Krtcinfo::initializewindow()
{
  QTimer *timer;
  timer = new QTimer(this, "timer");
  timer->start(1000, false);
  connect(timer, SIGNAL(timeout()), SLOT(update()));
  this->resize(300,300);
  tablistbox = new KTabListBox(this, "tablistbox");
  tablistbox->setAutoUpdate(false);
  tablistbox->setGeometry(0, 0, 300, 270);
  tablistbox->setNumCols(2);
  tablistbox->setColumn(0, i18n("Value"), 100);

  tablistbox->setColumn(1, i18n("Information"), 170);
  readfromfile(tablistbox);

  infobutton = new QPushButton(this, "infobutton");
  infobutton->setGeometry(0, 270, 60, 30);
  infobutton->setText(i18n("&About"));
  connect(infobutton, SIGNAL(clicked()), SLOT(infoclicked()));

  exitbutton = new QPushButton(this, "exitbutton");
  exitbutton->setGeometry(240, 270, 60, 30);
  exitbutton->setText(i18n("&Exit"));
  connect(exitbutton, SIGNAL(clicked()), SLOT(exitclicked()));
}

void Krtcinfo::infoclicked()
{
  infodialog *info;
  info = new infodialog(this, "infodialog");
  info->exec();
}

void Krtcinfo::exitclicked()
{
  close();
}

void Krtcinfo::update()
{
  tablistbox->setAutoUpdate(false);
  tablistbox->clear();
  readfromfile(tablistbox);
  tablistbox->setAutoUpdate(true);
  tablistbox->repaint();
}

