/***************************************************************************
                          printsettings.h  -  description                              
                             -------------------                                         
    begin                : Mon May 17 1999                                           
    copyright            : (C) 1999 by Torsten Uhlmann                         
    email                : TUhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef PRINTSETTINGS_H
#define PRINTSETTINGS_H

#include <qobject.h>
#include <qstring.h>
#include <qlist.h>
#include <qstrlist.h>

struct PrinterEntry {
	int 			printerNo;
	QString		description;
	QString		transformCommand;
	QString   previewCommand;
	QString		printCommand;
};

typedef QList<PrinterEntry>	PrinterList;


/**	PrintSettings will store the settings made
		in the gui and expose these values to the event
		handler class which will use them for printing.
		@author Torsten Uhlmann
*/
class PrintSettings : public QObject  {

	Q_OBJECT

public: 
	PrintSettings();
	~PrintSettings();
	
	enum PagesPerSheet { one, two, four };						
	enum PageSelect { all, even, odd };


	int 					getPrinterNo() {return printerNo;};
	int 					getPaperNo() {return paperNo;};
	PagesPerSheet getPagesPerSheet() {return pagesPerSheet;};
	int						getPagesPerSheetDecimal();
	bool					isReverseOrder() {return reverseOrder;};
	bool					isBook() {return book;};
	int						getSignature(){ return signature;};
	bool					isRange() { return ((rangeFrom || rangeTo) ? true : false);};
	int						getFromPage()	{return rangeFrom;};
	int						getToPage()		{return rangeTo;};
	PageSelect		getPageSelect() {return pageSelect;};
	
	bool					isPostscriptValid() {return postscriptValid;};
	bool					isTransformValid() {return transformValid;};
	void					setPostscriptValid(bool v) 	{postscriptValid = v;};
	void					setTransformValid(bool v) 	{transformValid = v;};
	
	// functions to manipulate the printer list
	
	/** returns the chosen/valid printer entry */
	PrinterEntry	*getPrinterEntry();
	QString				getPaper();
	PrinterList		getPrinterList();
	QStrList 			getPrinterStrList();
	QStrList 			getPaperStrList();
	void					setPrinterList(PrinterList);
	
	/** interface to the file(s) we work on */
	bool					setWorkFile(QString);
	QString				getWorkFile() {return workFile.copy();};
										
public slots:

	void slotInit();
	void slotSetPagesPerSheet(PrintSettings::PagesPerSheet);
	void slotSetReverseOrder(bool);
	void slotSetBook(bool);
	void slotSetSignature(int);
	void slotSetFromPage(int);
	void slotSetToPage(int);
	void slotSetPageSelect(PrintSettings::PageSelect);
	void slotSetPrinter(int p) {printerNo = p; postscriptValid = false; transformValid = false;};
	void slotSetPaper(int p) {paperNo = p; transformValid = false;};
	
	void slotReadConfigFile();
	void slotSaveConfigFile();
	
signals:
	void workFileChanged(const QString&);
	void printerListChanged(const QStrList&);
	void paperListChanged(const QStrList&);
	void paperChanged(int);
	void printerChanged(int);
	
private:

	int						printerNo;
	int						paperNo;
	PagesPerSheet	pagesPerSheet;
	bool 					reverseOrder;
	bool					book;
	int						signature;
	PageSelect		pageSelect;
	int						rangeFrom;
	int						rangeTo;
	
	/** the chosen file */
	QString				workFile;
	
	// a list of printer entries
	PrinterList		printerList;
	QStrList			paperList;
	
	bool					transformValid;
	bool					postscriptValid;
	
};

#endif





















