#include <iostream.h>
#include <qpopmenu.h>

#include "mytreelist.h"

#include "mytreelist.moc"

// Constructor
MyTreeList::MyTreeList(QWidget *parent = 0, const char *name = 0, WFlags f = 0)
    : KTreeList(parent, name, f)
{};

MyTreeList::~MyTreeList()
{};


void MyTreeList::mousePressEvent(QMouseEvent *e)
{
  // first: check which button was pressed

  if (e->button() == MidButton) 
	{
	  // RB: the MMB is hardcoded to the "rubberband" scroll mode
	  if (!rubberband_mode) {
		start_rubberband(e->pos());
	  }
	  return;
	} 
  else if (rubberband_mode) 
	{
	  // another button was pressed while rubberbanding, stop the move.
	  // RB: if we allow other buttons while rubberbanding the tree can expand
	  //     while rubberbanding - we then need to reclaculate and resize the
	  //     rubberband rect and show the new size)
	  end_rubberband();
	  return;  // should we process the button press?
	}

  // find out which row has been clicked
	
  QPoint mouseCoord = e->pos();
  int itemClicked = findRow(mouseCoord.y());
  
  // if a valid row was not clicked, do nothing
  
  if(itemClicked == -1) 
    return;

  KTreeListItem *item = itemAt(itemClicked);
  if(!item) return;
  
  // translate mouse coord to cell coord
  
  int  cellX, cellY;
  colXPos(0, &cellX);
  rowYPos(itemClicked, &cellY);
  QPoint cellCoord(mouseCoord.x() - cellX, mouseCoord.y() - cellY);
  
  // hit test item
  
  if(item->boundingRect(fontMetrics()).contains(cellCoord))
    {
      setCurrentItem(itemClicked);
      if (e->button() == RightButton)
	emit rightButtonHighlighted(itemClicked, e->pos());
      
      if (e->button() == LeftButton)
	emit leftButtonHighlighted(itemClicked, e->pos());
    }
  
  // hit test expand button
  
  else if(item->hasChild()) {
    if(item->expandButtonClicked(cellCoord)) 
      {
	expandOrCollapse(item);
	setCurrentItem(itemClicked);
      
	if (e->button() == RightButton)
	  emit rightButtonHighlighted(itemClicked, e->pos());
      
	// if (e->button() == LeftButton)
	//   emit leftButtonHighlighted(itemClicked, e->pos());
      }
  }
}
