// Homemade headers
#include "uiconfigdlg.h"
#include "resource.h"

// Standard Headers
#include <iostream.h>
#include <string.h>
#include <stdio.h> 

// QT Headers
#include <qlabel.h>
#include <qpixmap.h>
#include <qstring.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qcombobox.h>

// KDE headers
#include <kapp.h>
#include <kconfig.h>
#include <klocale.h>

CUIConfigDlg::CUIConfigDlg(QWidget* parent, const char* name) : QDialog(parent, name, FALSE)
{
  KConfig *config = kapp->getConfig();

  setupToFieldGroup(config);
  setupSBGroup(config);
  setupTBGroup(config);

}

CUIConfigDlg::~CUIConfigDlg()
{
 
  delete(fToFieldGroup);
  delete(fTo);
  delete(fAddress);
  delete(fDisabled);
  delete(fStaticRadioDesc);
  
  delete (fSBComboBox);
  delete (fStaticSBDesc);
  
  delete (fTBComboBox);
  delete (fStaticTBDesc);
 
}

void CUIConfigDlg::writeOptions()
{
  KConfig *config = kapp->getConfig();

  config->setGroup("VIEW");

  if (fTo->isChecked())
    config->writeEntry("ToFieldType", TO_TYPE_PARSED);
  else if (fAddress->isChecked())
    config->writeEntry("ToFieldType", TO_TYPE_ADDRESS);
  else if (fDisabled->isChecked())
    config->writeEntry("ToFieldType", TO_TYPE_DISABLED);

  //cout << "Writing to field type" << endl;

  config->setGroup("APPEARANCE");
  
  if (fTBComboBox->currentItem() == 4)
    {
      config->writeEntry("ShowToolBar", FALSE );
    }

  else
    {
      config->writeEntry("ShowToolBar", TRUE );
      config->writeEntry("ToolBarPos",  fTBComboBox->currentItem());
    }
  
  if (fSBComboBox->currentItem() == 0)
    {
      config->writeEntry("ShowStatusBar", TRUE );
    }
  
  else
    {
      config->writeEntry("ShowStatusBar", FALSE );
    }
}

void CUIConfigDlg::setupToFieldGroup(KConfig* config)
{
  fToFieldGroup = new QButtonGroup(i18n("Display \'To:\' field as.."), this, "ToFieldGroup");
  fToFieldGroup->setExclusive(TRUE);
  fToFieldGroup->setGeometry(10, 10, 410, 90);
  
  fTo = new QRadioButton(i18n("...it is parsed from mail header."), this, "To");
  fTo->setGeometry(30, 30, 280, 15);
 
  fAddress = new QRadioButton(i18n("...username@server for each mailbox."), this, "Address"); 
  fAddress->setGeometry(30, 45, 280, 15);
  
  fDisabled = new QRadioButton(i18n("...a disabled field."), this, "Disabled"); 
  fDisabled->setGeometry(30, 60, 280, 15);
 
  fTo->setChecked(FALSE);
  fAddress->setChecked(FALSE);
  fDisabled->setChecked(FALSE);
  
  config->setGroup("VIEW");
  switch(config->readNumEntry("ToFieldType", TO_TYPE_ADDRESS))
    {
    case TO_TYPE_PARSED:
      fTo->setChecked( TRUE );
      break;

    case TO_TYPE_ADDRESS:
      fAddress->setChecked( TRUE );
      break;

    case TO_TYPE_DISABLED:
      fDisabled->setChecked( TRUE );
      break;

    default:
      fTo->setChecked( TRUE );
      break;
    }


  fStaticRadioDesc = new QLabel(i18n("(A change may not take effect until next mail check)"), this, "StaticRadioDesc");
  fStaticRadioDesc->setGeometry(30, 75, 290, 15);
  
  fToFieldGroup->insert(fTo);
  fToFieldGroup->insert(fAddress);
  fToFieldGroup->insert(fDisabled);
}

void CUIConfigDlg::setupTBGroup(KConfig* config)
{
  fStaticTBDesc = new QLabel(i18n("Toolbar Position: "), this, "StaticTBDesc");
  fStaticTBDesc->setGeometry(60, 105, 100, 20);

  fTBComboBox = new QComboBox(this, "TBComboBox");
  fTBComboBox->setGeometry(230, 105, 120, 20);
  fTBComboBox->insertItem(i18n("Top"), 0);
  fTBComboBox->insertItem(i18n("Left"), 1);
  fTBComboBox->insertItem(i18n("Bottom"), 2);
  fTBComboBox->insertItem(i18n("Right"), 3);
  fTBComboBox->insertItem(i18n("Disabled"), 4);

  config->setGroup("APPEARANCE");

  if (config->readBoolEntry("ShowToolBar", TRUE))
    {
    fTBComboBox->setCurrentItem(config->readNumEntry("ToolBarPos", 0));
    //cout << "Setting TB 0" << endl;
    }

  else
    fTBComboBox->setCurrentItem(4);
}

void CUIConfigDlg::setupSBGroup(KConfig* config)
{
  fStaticSBDesc = new QLabel(i18n("Statusbar Position: "), this, "StaticSBDesc");
  fStaticSBDesc->setGeometry(60, 135, 100, 20);

  fSBComboBox = new QComboBox(this, "SBComboBox");
  fSBComboBox->setGeometry(230, 135, 120, 20);
 
  fSBComboBox->insertItem(i18n("Bottom"), 0);
  fSBComboBox->insertItem(i18n("Disabled"), 1);

  config->setGroup("APPEARANCE");
  if (config->readBoolEntry("ShowStatusBar", TRUE ))
    fSBComboBox->setCurrentItem(0);
  
  else
    fSBComboBox->setCurrentItem(1);
      
}

#include "uiconfigdlg.moc"
