// local includes
#include "clientmanager.h"
#include "clientlocal.h"
#include "clientpop3.h"
#include "clientimap.h"

#include <iostream.h>

ClientManager::ClientManager(QWidget* parent)
{
  fClientLocal = new ClientLocal(parent);
  fClientImap = new ClientImap(parent);
  fClientPop3 = new ClientPop3(parent);
}

ClientManager::~ClientManager()
{
  delete( fClientPop3 );
  delete( fClientImap );
  delete( fClientLocal );
}

bool ClientManager::checkMail(QList<HeaderStruct>* headerList, ServerStruct *serverInfo)
{
  bool success = false;

  // Find out what type of server we will need to connect to and 
  // then tell that client to connect and check
  switch(serverInfo->type)
    {
    case ServerTypePop3:
      //cout << "Checking pop3 server" << endl;
      success = fClientPop3->checkMail(headerList, serverInfo);
      break;

    case ServerTypeImap:
      success = fClientImap->checkMail(headerList, serverInfo);
      break;

    case ServerTypeLocal:
      success = fClientLocal->checkMail(headerList, serverInfo);
      break;
    
    default:
      ERROR_FORCE_DISPLAY("Server type is unknown. Unable to open.");
      break;
    }

  return success;
      
}

