#ifndef _BASE_CONFIG_DLG_H_
#define _BASE_CONFIG_DLG_H_

#include <qdialog.h>

class QCheckBox;
class QSlider;
class QLabel;
class QGroupBox;

class CBaseConfigDlg : public QDialog
{

  Q_OBJECT

public:
  CBaseConfigDlg(QWidget *parent, const char* name);
  ~CBaseConfigDlg();
  
  void writeOptions();

protected:
  QSlider *fCheckTime;
  QSlider *fTimeOutLength;
  
  QLabel *fStaticCheckTimeA;
  QLabel *fStaticCheckTimeB;
  QLabel *fStaticTimeOutLengthA;
  QLabel *fStaticTimeOutLengthB;
  QLabel *fCheckTimeValue;
  QLabel *fTimeOutLengthValue;

  QCheckBox *fStartup;
  QCheckBox *fDockOnLaunch;
  QCheckBox *fNeverDisplaySplash;

  QGroupBox *fGeneralTogglesGroupBox;
  QGroupBox *fTimesGroupBox;

  int fSliderCheckTimeValue;
  int fSliderTimeOutLengthValue;

public slots:
  /** Used to change the label to say the proper number of minutes. If the slider is moved,
   * this slot will be called and the current value will be set in the label.
   */
  void slotCheckTimeChanged(int);

   /** Used to change the label to say the proper number of minutes. If the slider is moved,
   * this slot will be called and the current value will be set in the label.
   */
  void slotTimeOutLengthChanged(int);  
};

#endif
