/***************************************************************************
                          knetdumpdoc.h  -  description                              
                             -------------------                                         
    begin                : Mon Mar 29 14:39:40 CEST 1999
                                           
    copyright            : (C) 1999 by Norbert Weuster                         
    email                : weuster@uni-duisburg.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KNETDUMPDOC_H
#define KNETDUMPDOC_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

//#ifndef GLOBAL_H
#include "global.h"
#include "netheader.h"
//#endif

//#include "ipcsum.h"

#include <kconfigbase.h>

#include <qobject.h>
#include <qtimer.h>
#include <kmsgbox.h>
#include <qsocketnotifier.h>
#include <qlist.h>
#include <qstring.h>

#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/errno.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>
#include <netinet/udp.h>
#include <net/ethernet.h>
#include <arpa/inet.h>
#include <net/if.h>
#include <net/if_arp.h>
#include <netinet/if_tr.h>
#include <netdb.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <stream.h>
// STL headers:
#include <list>
#include <string>
#include <vector>
#include <functional>
#include <algorithm>

extern int arp_show();
//extern int in_cksum();

/**
  * This class provides base functionality for your application document
  */
class KnetdumpDoc : public QObject {
  Q_OBJECT

public:
  /** Constructor for the fileclass of the application **/
  KnetdumpDoc(QObject*, const char *filename=0L);
  /** Destructor for the fileclass of the application **/
  ~KnetdumpDoc();

  QString& gethostname_from(QString &from, bool fromLocal=false);
  QString& gethostname_to(QString &to, bool toLocal=false);

  const short int getLinkLayer();
  const u_int16_t getNetwProtocol() const;
  const void* const getpLinkLayer() const;
  const void* const getpNetwLayer() const;
  const void* const getpTranspLayer() const;
  
  void setPromisc(bool);
  const bool getPromisc() const;
  void setUpdateTime(int value);
  const int getUpdateTime() const;
  void setInactiveTime(int value);
  const int getInactiveTime() const;
  void restartInactiveTimer() const;
  void setPacketMax(int value);
  const unsigned short int getPacketMax() const;
  const unsigned short int getPacketNum() const; 
  const unsigned int getNodeNum() const;
  const QString getNode(unsigned int num);
  const QString getNodeDomainName(const QString ipAddr);
  const bool devIsPresent(const char *name) const;
  void resetInterfaces();
  void activeInterfaces(const char *name);
  const bool getInterfaces(const char* name) const;
  void delPackets();
  void delARPcache();
  void clearStats();
  const int byterec() const ;
  void setFilter(bool, bool, bool, bool, bool, bool, bool, int);
  bool isStopped();
  void pause();
  void proceed();
  bool isNodeLocal(QString ipAddr);
  bool isNodeSelected(QString);
  void setNodeSelected(QString, bool);
  bool isNodeSelected();
  void setSelectNode(bool);
  void setHostResolve(bool);
  bool isHostResolved();
  void setasciiOutput(bool);
  bool isasciiOutput();
  //void sendPing(const char *hostname);
  void storeNode(QString node);
 
public slots:
  void start();
  void stop();
  void hasShown();
  void getPacket(int num);

private slots:
  void packetNotified();
  void cleaner();

signals:
  void activated(int);
  void viewPacket();
  void viewOldPacket();
  void startedDoc();
  void pausedDoc();
  void stoppedDoc();
  void deletedPackets();
  void cleaned();

public:
      bool recIEEE802, recARP, recIP, recTCP, recUDP, recICMP, recX;
      u_int16_t recPort;
     
private:
      KConfig *config;
      int updateTime;
      int inactiveTime;
      unsigned short int buffercount;        // number of packets to store for each interface
      bool promisc;
      bool nodeSelect;
      bool hostResolve;
      bool asciiOutput;
      QString activeIf;

  bool sniffstart;
  int fdsock;
  bool emitter;
  QTimer *inactiveTimer;     
    
  char ebuf[20];
  QSocketNotifier *sn;

  vector<u_int32_t> broadcasts;

  struct packet {                       // one packet
      string ifName;                    // interface name
      int byterecv;                     // number of received bytes
      const void* pLinkLayer;     // pointer to the link layer
      u_int16_t netwProtocol;     // protocol of the following network layer
      const void* pNetwLayer;     // pointer to the network layer (IP, (R)ARP, ..)
      const void* pTranspLayer;   // pointer to the data in the network layer (TCP/UDP/..)
      const char* pbuffer;        // pointer to the complete received buffer
  };
  list<packet> packetList;            // list of packets
 
  list<stats> statsList;

  struct ifDevices {                  // structure for different interfaces 
    string ifName;                  // char *ifname[IFNAMSIZ+1];   // interface name
    struct ifreq saved_ifr;         // saved register of interface
    //u_int32_t hostaddr;           // apropriate host address
    u_int32_t broadcast;            // apropriate broadcast address
    u_int32_t netmask;              // apropriate netmask address
    // short int bufSize;           // buffer size of interface // not needed ? 
    short int linkLayer;            // link layer of interface
  };
  list<ifDevices> ifDevList;          // list of interfaces
  typedef list<ifDevices>::iterator LI;

public: 
  //  const packetcounter getPCounters(const string);
  // const bytecounter getBCounters(const string);
  const struct stats getStatstruct(const string);
  void saveMyOptions();

private:
  void readMyOptions();
  list<KnetdumpDoc::ifDevices>::iterator packetFromDev(string name);
  int storePacket(struct packet &, char *buffer, struct sockaddr fromaddr, int byterecv);
  // void resetcounter(const string);
  void registerDevices();
  void resetDevices();
  void readPacket(char *buf, struct sockaddr *fromaddr, int &byterecv);
  //void storeNewNode();
  bool isInFilterList(QString name);
  int arp_del(char *name, int sockfd);
  int arp_show(int sockfd);
  int in_cksum(u_short * addr, int len);
  QString& extractIPaddress(QString &, struct packet &, bool);
  void setupStatsstruct(string);
  // void setStatstruct(struct stats);

private:
  list<packet>::iterator pPacket; // actual Packet in list;

  // Define of predictor: 
  // used with find algorithm // s. B.Stroustrup 18.4.2.1
  class ifDevices_eq : public unary_function<ifDevices,bool> {
      string name;
     public:
      explicit ifDevices_eq (const string& s) : name (s) {}
      bool operator() (const ifDevices& c)  const { return c.ifName==name; }
  };
  
  // classes used for trafficview:
  class Node {
  public:
      Node (QString nName, bool, bool select);
      ~Node ();
      const QString name () const;
      const QString domainName() const;
      int inactiveCounter () const;
      void resetInactiveCounter ();
      void decInactiveCounter ();
      void setSelected(bool);
      bool isSelected();
      operator QString () const;
      bool operator== (const Node& rhs) const;
  private:
      QString nodeName;
      QString nodeDomainName;
      u_int16_t inactive_cnt;
      bool selected;
  };
  list<Node> nodeList;
  
  // Define of predictor: 
  // used with find algorithm // s. B.Stroustrup 18.4.2.1
  class node_eq : public unary_function<Node,bool> {
      QString name;
     public:
      explicit node_eq (const QString& s) : name (s) {}
      bool operator() (const Node& c)  const { return name==c; } 
  };
  
};

#endif // KNETDUMPDOC_H












