/***************************************************************************
                          modemconnector.h  -  description                              
                             -------------------                                         
    begin                : Wed Apr 7 1999                                           
    copyright            : (C) 1999 by Torsten Uhlmann                         
    email                : TUhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef MODEMCONNECTOR_H
#define MODEMCONNECTOR_H

#include <termios.h>
#include <qobject.h>

/** This class provides basic low level functionality to
		access a serial device.
  *@author Torsten Uhlmann
*/
class ModemConnector : public QObject {

	Q_OBJECT
	
public: 
	ModemConnector(const QString&, const QString&, const QString&);
	~ModemConnector();
	
	/** initialise serial line (set with setDevice) */
	bool initSerialLine();
	
	/** send an AT command to the modem and wait for the answer string */	
	QString	executeCommand(const QString&, const QString&);
	
	/** simplify the executeCommand routine if one only wants to execute
			a certainy command and is interested in the given error code
			but not the returned bytes */
	bool 		executeSimpleCommand(const QString&, const QString&);
	
protected:

	/** set the modem device */
	bool setDevice(const QString&);
	
	/** remove all waiting chars from serial line */
  bool flushSerialLine();

	/** return the read char or an error code if none was read
			- nonblocking -
	*/
	int readC();
	
	/** return the read char or an error code if none was read
			- blocking mode with timeout - */
	int readCBlocking();
	
	/** read a string in blocking mode */
	QString	readStr();

	/** writeStr writes n chars to the serial line */
	bool 	writeStr(const QString&);
	
	/** writeStr write len chars to the serial line */
	bool writeStr(char *c, int len);

  /** the file descriptor of the serial line device
  		I want to leave this low level */
  int _fd;

private:

  /** lockSerialLine checks if line is locked and if not, creates
  		a lock file */
  bool lockSerialLine();

	/** the serial device */
  QString		_device;

  /* name of the lockfile */
  QString		_lockfile;

  /* the baudrate we use */
  tcflag_t 	_baudrate;

  /** structures to store serial device settings */
  struct termios _oldtio, _newtio;


};

#endif

