/*
    KMLOFax
    
    A utility to process facsimile received with the ELSA
    MicroLink(tm) Office modem.

    Copyright (C) 1999-2000 Oliver Gantz <Oliver.Gantz@epost.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ------
    ELSA and MicroLink are trademarks of ELSA AG, Aachen.
*/

#ifndef SENDERALIASES_H 
#define SENDERALIASES_H 

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qdialog.h>
#include <qwidget.h>
#include <qlistview.h>
#include <qlineedit.h>
#include <qpushbutton.h>



class SenderAliases : public QDialog
{
	Q_OBJECT
public:
	SenderAliases(QWidget *parent = 0, const char *name = 0);
	~SenderAliases();

	void loadDir();
	void saveDir();

	void addToolTips(bool on);

public slots:
	QString alias(const char *id_);
	void setAlias(const char *id_);

private slots:
	void addItem();
	void deleteItem();
	void applyItem();
	void currentChangedSlot(QListViewItem *item);

signals:
	void applyButtonPressed();

private:
	bool gotToolTips;

	bool entry_changed;

	QLineEdit *sender_id;
	QLineEdit *sender_name;
	QPushButton *bapply;
	QListView *list;
	QPushButton *badd, *bdel, *bclose;
};


extern SenderAliases *senderaliases;

#endif // SENDERALIASES_H
