/*
    KMLOFax
    
    A utility to process facsimile received with the ELSA
    MicroLink(tm) Office modem.

    Copyright (C) 1999-2000 Oliver Gantz <Oliver.Gantz@epost.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ------
    ELSA and MicroLink are trademarks of ELSA AG, Aachen.
*/

#ifndef FAXVIEW_H 
#define FAXVIEW_H 

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qlistview.h>
#include <qpixmap.h>
#include <qwidget.h>
#include <qpopupmenu.h>
#include <qstring.h>

#include <kconfig.h>

#include "senderaliases.h"




class FaxViewItem : public QListViewItem
{
public:
	FaxViewItem(QListView *parent = 0, const char *name = 0);
	virtual ~FaxViewItem();

	void setName(const QString& name);
	QString name();
	void setNew(bool isnew);
	bool isNew();
	void setSender(const char *sender_);
	const char *sender();
	void setPages(int pages_);
	int pages();
	void setSize(uint size_);
	uint size();
	void setFile(bool hasfile);
	bool hasFile();
	void setAlias();
	QString alias();
	
	void setParams(const QString& name_, bool isnew_, const char *sender_, int pages_, uint size_);

private:
	bool m_new;
	char m_sender[21];
	int m_pages;
	uint m_size;
	bool m_file;
};


inline QString FaxViewItem::name()
{ return text(0); }

inline bool FaxViewItem::isNew()
{ return m_new; }

inline const char *FaxViewItem::sender()
{ return m_sender; }

inline int FaxViewItem::pages()
{ return m_pages; }

inline uint FaxViewItem::size()
{ return m_size; }

inline bool FaxViewItem::hasFile()
{ return m_file; }

inline QString FaxViewItem::alias()
{ return text(3); }



class FaxView : public QListView
{
	Q_OBJECT
public:
	FaxView(QWidget *parent = 0, const char *name = 0);
	~FaxView();

	void readOptions();
	void saveOptions();

	int loadDir();
	void saveDir();
	void purgeDir();
	int rebuildDir();

	void addFaxItem(const QString& name);

	bool selectedFaxNew();
	void setSelectedFaxNew(bool isnew);
	QString selectedFaxName();
	const char *selectedFaxSender();
	QString selectedFaxAlias();
	bool selectedFaxFile();
	void setSelectedFaxFile(bool fexists);

	void gotSelection(bool on);

private slots:
	void enableCommand(int id_, bool enable);
	
	void selectionChangedSlot(QListViewItem *item);
	void doubleClickedSlot(QListViewItem *item);
	void returnPressedSlot(QListViewItem *item);
	void rightButtonClickedSlot(QListViewItem *item, const QPoint& point, int);
	void refreshAliases();
	void contextMenuSlot(int id_);

signals:
	void hasSelection(bool);
	void viewRequested(FaxViewItem *);

	void command(int);
	
private:
	KConfig *config;

	bool got_tooltips;

	FaxViewItem *selectedItem;

	QPopupMenu *contextMenu;
};


#endif // FAXVIEW_H 
