/*
    KMLOCfg
    
    A utility to view and print facsimiles received with the
    ELSA MicroLink(tm) Office modem.

    Copyright (C) 2000 Oliver Gantz (o.gantz@tu-bs.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ------
    ELSA and MicroLink are trademarks of ELSA AG, Aachen.
*/

#ifndef PREFERENCES_H 
#define PREFERENCES_H 

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qtabdialog.h>
#include <qwidget.h>
#include <qstring.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qcombobox.h>

#include <kconfig.h>



class Preferences : public QTabDialog
{
	Q_OBJECT
public:
	Preferences( QWidget * parent = 0, const char * name = 0 );
	virtual ~Preferences();

	void addToolTips( bool on );

	bool genTooltips();

	const QString modDevice();
	int modSpeed();

public slots:
	void reset();
	void apply();

signals:
	void apply_clicked();

private:
	KConfig *KsConfig;

	bool gotToolTips;

	QWidget * page1, * page2;

	QCheckBox * gen_tooltips;

	QLineEdit * mod_device;
	QComboBox * mod_speed;
};


#endif // PREFERENCES_H
