#ifndef MEMDATA_H 
#define MEMDATA_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <kapp.h>

#include "../kernel/memmap.h"

/* watch out, these should be enumerated the same
	way as for the types in memmap.h */ 
const enum mem_types { MEM_FREE=MEMMAP_MEM_FREE,
		MEM_USED=MEMMAP_MEM_USED,
		MEM_CACHED=MEMMAP_MEM_CACHED,
		MEM_BUFFER=MEMMAP_MEM_BUF,
		MEM_RESERVED=MEMMAP_MEM_RESERVED,
		MEM_NONE } ;

class MemData : public QObject
{
	Q_OBJECT
public:
	MemData(QWidget *parent = 0, const char *name = 0);
	virtual ~MemData();

	/**
	 * Get the status for a page in memory
	 *
	 * @return the status of the indicated page
	 **/
	char getPage( int ) const ;
	/**
	 * Same as the last function, but does no checking
	 * on the argument.
	 * @return the status of the indicated page
	 **/
	inline char getPageNoCheck( int ) const ;

	/**
	 * Get all the information at once, be careful
	 * when using this pointer.
	 *
	 * @return pointer to pages in memory  
	 */ 
	const char * getPagePointer() ;

	/**
	 * This method returns the number of pages.
	 *
	 * @return the number of pages 
	 */
	inline int numberOfPages() const { return number_of_pages ; }

	int updateTime() const ;

	static const int MIN_UPDATE_TIME = 200 ;
	static const int DEFAULT_UPDATE_TIME = 1800 ;
	static const int MAX_UPDATE_TIME = 12000 ;

public slots:
	/* use this for moving around the windows etc. */ 

	void setUpdateTime( int ) ;

signals:
	void dataChanged() ;

protected:
	void timerEvent( QTimerEvent * ) ;

private slots:
	void readData() ;
	char readPage( int ) ;

private:
	/**
	 * This function should not be used.
	 */
	int toFile(int) ;
	/**
	 * This function should not be used.
	 */
	int fromFile(int) ;

	/* this is where we get all the data */
	int fd ;
	/* TODO: make this char instead of int? */
	/* and here we store it */
	char *pages ; 
	int number_of_pages ;

	/* re-read the data every ?? miliseconds */
	int update_time ;
	int timer_id ;

};

#endif // MEMDATA_H 
