/*  pmod_functions.c Initialisation of the module
 *
 */

#ifndef __KERNEL__
#define __KERNEL__
#endif
#ifndef MODULE
#define MODULE
#endif
#ifndef EXPORT_SYMTAB
#define EXPORT_SYMTAB 1
#endif

#include "memmap.h"
#include <linux/kernel.h>
#include <asm/uaccess.h>


/*
 * Open and close of memmap
 */
int memmap_open (struct inode *inode, struct file *filp)
{
	MemmapDevice *dev; /* device information */
	dev = memmap_device ;

	/* and use filp->private_data to point to the device data */
	filp->private_data = dev;

	MOD_INC_USE_COUNT;

	return 0;          /* success */
}

int memmap_release (struct inode *inode, struct file *filp)
{
	MOD_DEC_USE_COUNT;
	return 0 ;
}


/*
 * Data management: read, write, lseek
 */
ssize_t memmap_read ( struct file *filp, char *buf,
			size_t count, loff_t *ppos )
{
	/* struct inode * inode = file->f_dentry->d_inode; */

	int i ;
	static char tmp_data[MAX_DATA_SIZE] ;

	MemmapDevice *dev = filp->private_data; /* the first listitem */
	unsigned long f_pos = (unsigned long)(filp->f_pos);

	struct page *page = mem_map ;

	if (f_pos > dev->size)
		return 0;
	if (f_pos + count >= dev->size)
		count = dev->size - f_pos;
	if ( count> MAX_DATA_SIZE )
		count = MAX_DATA_SIZE ;

	page += filp->f_pos ;

	for(i=0;i<count;i++)
	{
		tmp_data[i]=mem_type(page) ;
		page++ ;
	} 	

	dev->usage++; /* the following call may sleep */
	copy_to_user(buf, tmp_data, count);
	dev->usage--;

	filp->f_pos += count;
	return count;
}

/*
 * No write, you cannot change the type of memory! 
 */

/*
 * The "extended" operations -- only seek
 */
loff_t memmap_lseek ( struct file *filp, loff_t off, int whereof )
{
	MemmapDevice *dev = filp->private_data;
	long newpos;

//	printk( "memmap_lseek" ) ;

	switch( whereof ) {
		case 0: /* SEEK_SET */
			newpos = off;
			break;
		case 1: /* SEEK_CUR */
			newpos = filp->f_pos + off;
			break;
		case 2: /* SEEK_END */
			newpos = dev->size + off;
			break;
		default: /* can't happen */
			return -EINVAL;
	}
	if (newpos<0) return -EINVAL;
	if (newpos>=dev->size) return -EINVAL ;

	filp->f_pos = newpos;
	return newpos;
}

char mem_type( struct page *page )
{
	char c = MEMMAP_MEM_ERROR ;

	if (atomic_read(&page->count)) 
	{ 
		if (page->buffers) 
			c = MEMMAP_MEM_BUF ;		/* buffers */ 
		else if ( page->inode ) 
			c = MEMMAP_MEM_CACHED ;		/* cached */ 
	else 
		c = MEMMAP_MEM_USED ;			/* used */ 
	} 
	else if (PageReserved(page)) 
		c = MEMMAP_MEM_RESERVED ;		/* reserved */ 
	else 
		c = MEMMAP_MEM_FREE ;			/* free */ 


	return c ;
}

inline void memmap_print( char *s )
{
	printk( KERN_CRIT "%s\n", s ) ;
}
