/*  main.c
 *
 * Initialisation of the module
 *
 */

#ifndef __KERNEL__
# define __KERNEL__
#endif
#ifndef MODULE
# define MODULE
#endif
#ifndef EXPORT_SYMTAB
# define EXPORT_SYMTAB 1
#endif

#include "memmap.h"

#include <linux/module.h> 
#include <linux/version.h>
#include <linux/mm.h>
#include <linux/sched.h>
#include <linux/kernel.h> /* printk() */
#include <linux/malloc.h> /* kmalloc() */
#include <linux/fs.h>     /* everything... */
#include <linux/errno.h>  /* error codes */
#include <linux/types.h>  /* size_t */

/* define the kernel_version symbol */
char kernel_version[] = UTS_RELEASE ;

/* major number */
static int memmap_major=0 ;

/* the memmap device */
MemmapDevice *memmap_device ;

/* export all needed symbols to the world */
EXPORT_SYMBOL( memmap_device ) ;

/*
 * The different file operations
 */
struct file_operations memmap_fops = {
    memmap_lseek,
    memmap_read,	/* memmap_read */
    NULL,		/* scull_write */
    NULL,		/* scull_readdir */
    NULL,		/* scull_select */
    memmap_ioctl,
    NULL,		/* scull_mmap */
    memmap_open,
    memmap_release,
			/* nothing more, fill with NULLs */
};

/* simple routine the get the number of pages */
static int get_number_of_pages(void)
{
	int nr ;
	struct page *firstpage, *lastpage ; 
 
	firstpage = mem_map ; 
	lastpage = mem_map + MAP_NR(high_memory); 
	 
	nr = (int)(lastpage-firstpage) ; 

	#ifdef MEMMAP_DEBUG
	printk( KERN_WARNING "Found %d pages\n", nr ) ;
	#endif

	return nr ;
}

/* load the module */
int init_module(void)
{
	int result, i;

	printk( "memmap.o: a module written by <pte@ddsw.nl>\n" );

	/*
	 * Register major, and accept a dynamic number
	 */
	result = register_chrdev( memmap_major, "memmap", &memmap_fops);

	if (result < 0) {
		printk(KERN_WARNING "memmap: can't get major %d\n",memmap_major);
        	return result;
	}

	if (memmap_major == 0) memmap_major = result; /* dynamic */

	/* 
	 * allocate the device
	 */
	memmap_device = kmalloc( sizeof (MemmapDevice), GFP_KERNEL);
	if (!memmap_device) {
		result = -ENOMEM;
		goto fail_malloc;
	}

	memset(memmap_device, 0, sizeof( MemmapDevice ));

	/* initialize the devices  */
	for (i=0; i < 1; i++) {
	        memmap_device[i].size = get_number_of_pages() ;
	}

	return 0; /* succeed */

	fail_malloc: unregister_chrdev( memmap_major, "memmap");
	return result;
}	

void cleanup_module(void)
{
	unregister_chrdev( memmap_major, "memmap");
	kfree( memmap_device);

	printk( "Leaving module memmap\n" );
}


