//==========================================================================
//
//   View.h
//
//==========================================================================

#include <qframe.h>
#include <qpixmap.h>
#include <qpoint.h>
#include <qtimer.h>

#include "selrect.h"

class View : public QFrame
{
    Q_OBJECT

    //================================================== Construction
    
public:

    View(QWidget *parent=0);

    //================================================== Events
    
public:
    
    virtual void mousePressEvent(QMouseEvent *);
    virtual void mouseMoveEvent(QMouseEvent *);
    virtual void mouseReleaseEvent(QMouseEvent *);
    
    virtual void paintEvent(QPaintEvent *);

    //================================================== Signal
    
signals:

    void zoomChanged(int);
    
    //================================================== Slots
    
public slots:

    void slotUpdatePixmap();
    
    void slotSetZoom(int);
    void slotIncZoom();
    void slotDecZoom();

    void slotReplace();

    //================================================== Data
    
protected:

    QTimer timer;
    QPixmap pixmap;
    int zoom;

    SelRect selRect;
    
    enum MouseMode { Normal=10, StartSelect=20,
		     MoveSelection1=30, ResizeSelection1=40,
		     MoveSelection2=50, ResizeSelection2=60,
		     MoveSelection3=70, ResizeSelection3=80 };
    
    MouseMode mouseMode;

    QPoint oldPoint, oldPos;
    QSize oldSize;

    //================================================== Utilities

    QPoint pixmapPosition();
    QRect pixmapRect();
}; 

//--------------------------------------------------------------------------
//   end of file
//--------------------------------------------------------------------------

