//==========================================================================
//
//   SelRect.cpp
//
//==========================================================================

#include <qapp.h>

#include <stdlib.h>

#include <X11/Xlib.h>

#include "kmag.h"
#include "selrect.h"

//--------------------------------------------------------------------------
//   Construction
//--------------------------------------------------------------------------

SelRect::SelRect(QWidget *parent) :
    QRect()
{
    init(parent);
}

SelRect::SelRect(const QPoint &topleft, const QPoint &bottomright,
		 QWidget *parent) :
    QRect(topleft, bottomright)
{
    init(parent);
}

SelRect::SelRect(const QPoint &topleft, const QSize &size,
		 QWidget *parent) :
    QRect(topleft, size)
{
    init(parent);
}

SelRect::SelRect(int left, int top, int width, int height,
		 QWidget *parent) :
    QRect(left, top, width, height)
{
    init(parent);
}

void SelRect::init(QWidget *_parent)
{
    parent = _parent ? _parent : QApplication::desktop();

    isVisible = false;

    // partially stolen from KWM - thanx :-)

    Display *dpy = parent->x11Display();
    
    XGCValues gv;
  
    gv.function = GXxor;
    gv.line_width = 0;
    gv.foreground =
	WhitePixel(dpy, DefaultScreen(dpy)) ^
	BlackPixel(dpy, DefaultScreen(dpy));
    
    gv.subwindow_mode = IncludeInferiors;
    
    gc = XCreateGC(dpy, parent->winId(),
		   GCForeground | GCFunction | GCLineWidth | GCSubwindowMode,
		   &gv);
}

SelRect::~SelRect()
{
    XFreeGC(parent->x11Display(), gc);
}

//--------------------------------------------------------------------------
//   
//--------------------------------------------------------------------------

bool SelRect::visible()
{
    return isVisible;
}

//--------------------------------------------------------------------------
//   Slots
//--------------------------------------------------------------------------

void SelRect::show()
{
    if(!isVisible)
    {
	isVisible = true;
	paint(*this);
	old = *this;
    }
}

void SelRect::hide()
{
    if(isVisible)
    {
	isVisible = false;
	paint(*this);
    }
}

void SelRect::update()
{
    if(isVisible)
    {
	paint(old);
	paint(*this);
	old = *this;
    }
    emit updated();
}

void SelRect::paint(const QRect &rect)
{
    QRect normRect = rect.normalize();
    
    XDrawRectangle(parent->x11Display(),
		   parent->winId(), gc,
		   min(normRect.left(), normRect.right()) - 1,
		   min(normRect.top(), normRect.bottom()) - 1,
		   abs(normRect.width()) + 1,
		   abs(normRect.height()) + 1);
}

//--------------------------------------------------------------------------
//   Hider
//--------------------------------------------------------------------------

SelRectHider::SelRectHider(SelRect &_selRect) :
    selRect(_selRect)
{
    if(selRect.visible())
    {
	selRect.hide();
	hidden = true;
    }
    else
    {
	hidden = false;
    }
}

SelRectHider::~SelRectHider()
{
    if(hidden)
    {
	selRect.show();
    }
}

//--------------------------------------------------------------------------
//   end of file
//--------------------------------------------------------------------------

