/*
    look@seti -
    Copyright (C) 1999 Jrgen Hochwald <hochwald@kde.org>
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
			
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
					
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/    

#include "toplevel.h"
#include "qmessagebox.h"
#include "kiconloader.h"

extern TChart *Chart;

TopLevel::TopLevel(const char *name=0)
  : KTopLevelWidget(name)
{
//debug("toplevel.create");
  Chart = new TChart(this);
  setupMenuBar();
  setupStatusBar();
  setupToolBar();
  setView(Chart);
}

TopLevel::~TopLevel() {
//debug("Toplevel.delete");
}

void TopLevel::setupMenuBar()
{
  menubar = new KMenuBar(this);

  fileMenu = new QPopupMenu();
  editMenu = new QPopupMenu();
  optionsMenu = new QPopupMenu();
  helpMenu = new QPopupMenu();
  viewMenu = new QPopupMenu();

  fileMenu->insertItem(i18n("&Open"), Chart, SLOT(LoadWatches()),CTRL+Key_O);
  fileMenu->insertItem(i18n("&Save"), Chart, SLOT(SaveWatches()),CTRL+Key_S);
  fileMenu->insertSeparator();
  fileMenu->insertItem(i18n("&Exit"), kapp, SLOT(quit()), CTRL+Key_Q);

  editMenu->insertItem(i18n("&Add"), Chart, SLOT(AddWatch()),CTRL+Key_A);
  editMenu->insertItem(i18n("&Edit"), Chart, SLOT(EditWatch()), CTRL+Key_E);
  editMenu->insertItem(i18n("&Remove"), Chart, SLOT(RemoveWatch()), CTRL+Key_R);
  editMenu->insertItem(i18n("Remo&ve All"), Chart, SLOT(RemoveAllWatches()),CTRL+Key_V);

  optionsMenu->insertItem(i18n("Options"),   Chart, SLOT(SetupOptions()),CTRL+Key_P);
  optionsMenu->insertItem(i18n("Panel View"),Chart, SLOT(PanelViewOptions()) );
  optionsMenu->insertItem(i18n("Save"),      Chart, SLOT(SaveOptions()));
  
  helpMenu->insertItem(i18n("&Contents"), kapp, SLOT(appHelpActivated()), Key_F1);
  helpMenu->insertSeparator();
  helpMenu->insertItem(i18n("&About"), this, SLOT(aboutApp()));
  helpMenu->insertItem(i18n("About &KDE"), kapp, SLOT(aboutKDE()));

  viewMenu->insertItem(i18n("Detailed View"), Chart, SLOT(ShowDetails()));
  viewMenu->insertItem(i18n("Skymap"), Chart, SLOT(ShowSkymap()));
  viewMenu->insertItem(i18n("Panel View"), Chart, SLOT(ShowPanelIcon()));

  menubar->insertItem(i18n("&File"), fileMenu);
  menubar->insertItem(i18n("&Edit Watches"), editMenu);
  menubar->insertItem(i18n("&View"), viewMenu);
  menubar->insertItem(i18n("&Options"), optionsMenu);
  menubar->insertSeparator(-1);
  menubar->insertItem(i18n("&Help"), helpMenu);

  setMenu(menubar);
}

void TopLevel::setupToolBar()
{
  KIconLoader iconLoader;
  toolbar = new KToolBar(this);

  addToolBar(toolbar);

#define I(f,i,o,s,h) toolbar->insertButton( iconLoader.loadIcon(f),\
	 i, SIGNAL(clicked()), o, SLOT(s()), TRUE, h);

  I("fileopen.xpm",   0,    Chart, LoadWatches, i18n("Load watchlist"));
  I("filefloppy.xpm", 0,    Chart, SaveWatches, i18n("Save watchlist"));
  toolbar->insertSeparator();

  I("ks_plus.xpm",    0,    Chart, AddWatch,    i18n("Add new watch"));
  I("ks_edit.xpm",    0,    Chart, EditWatch,   i18n("Edit current watch"));
  I("ks_minus.xpm",   0,    Chart, RemoveWatch, i18n("Remove current watch"));
  I("ks_icks.xpm",    0,    Chart, RemoveAllWatches, i18n("Remove all watches"));
  toolbar->insertSeparator();

  I("find.xpm",       0,    Chart, ShowDetails, i18n("Detailed View"));
  I("earth.xpm",       0,    Chart, ShowSkymap,  i18n("Skymap View"));
  toolbar->insertSeparator();

  I("idea.xpm",       0,    Chart, SetupOptions, i18n("Options"));
  toolbar->insertSeparator();

  I("help.xpm",       0,    kapp,  appHelpActivated,  i18n("Help"));
#undef I
}

void TopLevel::setupStatusBar()
{
   statusbar = new KStatusBar(this);
   setStatusBar(statusbar);
}


void TopLevel::aboutApp()
{
   QMessageBox::about(this, i18n("About look@seti"), i18n("look@seti 0.22 build October 2000 by Juergen Hochwald"));
}

void TopLevel::keyPressEvent(QKeyEvent * kev) {
   //debug("Taste");
   switch (kev->key()) {
      case Key_Left : ;
      case Key_Right: ;
      case Key_Next : ;
      case Key_Prior: ;
      case Key_Home : ;
      case Key_End  : ;
   }
}
