
/*
 * $Id: picalc.c,v 1.2 1998/03/29 16:20:57 pi Exp pi $
 *
 * $Log: picalc.c,v $
 * Revision 1.2  1998/03/29 16:20:57  pi
 * Einige Konstanten parametrisiert
 *
 * Revision 1.1  1998/03/29 16:00:02  pi
 * Initial revision
 *
 */


/* Berechnung von Pi nach der Machin'schen Formel */
/* auf Geschwindigkeit ueberarbeitet: 23.03.90, UwS */
/* letzte Modifikation: 12.04.90, UwS */

#include <stdio.h>
#include <stdlib.h>

#define TRUE 1
#define FALSE 0

#define MOD_DIGITS 3       /* eine INT-ZELLE repraesentiert so viele Stellen */
#define MODULUS 1000       /* 10^MOD_DIGITS */
#define SAFETY 2           /* SICHERHEITSZELLEN */

typedef short INT16;

typedef INT16 *FELD;

FELD feld1,feld2,ergebnis;
int groesse,stellen;
char *pi_string;


void copy(FELD original,FELD kopie)
{
    int i = groesse;

    while(i--)
        *kopie++ = *original++;
}


void pi_out(char *string)
{
    static char *header = "Pi = 3.";
    int i;

    printf(header);
    for (i = 0;i < stellen && string[i] != '\0';i++)
    {
        if (i % 50 == 0)
            printf("\n");
        putchar(string[i]);
    }
    printf("\n");
}


void konvertiere(FELD feld,char *string)
{
    int i,j,count = 0,teiler;

    for (i = groesse - 2;i >= SAFETY;i--)
    {
        for (teiler = MODULUS / 10; teiler > 0;teiler /= 10) {
            string[count++] = (feld[i] / teiler) % 10 + '0';
        }
    }
    string[count] = '\0';
}


int division2(FELD feld,long divisor)
{
    long dividend;
    int i,ergebnis_nicht_null = FALSE;
    ldiv_t quot_rest;

    quot_rest.rem = 0L;
    for (i = groesse - 1;feld[i] == 0;i--) /* Erste Nullen ueberspringen */
        ;
    for(;i >= 0;i--)
    {
        /* Wenn divisor >= 2^31/10000 gibt es hier Integer-Overflow
         * Das passiert ab divisor = 210000, d.h. 150300 Stellen
         */
        dividend = quot_rest.rem * MODULUS + feld[i];
        quot_rest = ldiv(dividend,divisor); /* ANSI-C !!! */
        
        if((feld[i] = (int)quot_rest.quot) != 0)
            ergebnis_nicht_null = TRUE; 
    }
    return ergebnis_nicht_null;
}


int division(FELD feld,long divisor)
{
    long dividend;
    int i,ergebnis_nicht_null = FALSE;
    long quotient, rest;
    
    rest = 0L;
    for (i = groesse - 1;feld[i] == 0;i--) /* Erste Nullen ueberspringen */
        ;
    for(;i >= 0;i--)
    {
        /* Wenn divisor >= 2^31/10000 gibt es hier Integer-Overflow
         * Das passiert ab divisor = 210000, d.h. 150300 Stellen
         */
        dividend = rest * MODULUS + feld[i];
        quotient = dividend / divisor;
        rest = dividend % divisor;
        
        if((feld[i] = quotient) != 0)
            ergebnis_nicht_null = TRUE; 
    }
    return ergebnis_nicht_null;
}


void addition(FELD summe,FELD feld)
{
    int size = groesse, i,stelle;

    for(i = size - 1;feld[i] == 0;i--)  /* Erste Nullen ueberspringen */
        ;
    for(;i >= 0;i--)
    {
        summe[i] += feld[i];
        stelle = i;
        while (summe[stelle] >= MODULUS)
        {
            summe[stelle] -= MODULUS;
            summe[stelle + 1] ++;
            stelle ++;
        }
    }
}

void subtraktion(FELD differenz,FELD feld)
{
    int size = groesse, i,stelle;

    for(i = size - 1;feld[i] == 0;i--) /* Fuehrende Nullen ueberspringen */
        ;
    for(;i >= 0;i--)
    {
        differenz[i] -= feld[i];
        stelle = i;
        while (differenz[stelle] < 0)
        {
            differenz[stelle] += MODULUS;
            differenz[stelle + 1] --;
            stelle ++;
        }
    }
}


void pi(void) /* Pi = 4 * (4 * arctan(1/5) - arctan(1/239)) */
{
    int size = groesse, addieren = TRUE, nicht_fertig = TRUE, i;
    int potenz;
    long nenner;

    for(i = 0;i < size;i++)
        feld1[i] = feld2[i] = ergebnis[i] = 0;

    potenz = 5;
    nenner = 1;
    feld1[size - 1] = potenz;

    while(nicht_fertig) {
        division(feld1,potenz * potenz);
        copy(feld1,feld2);
        nicht_fertig = division(feld2,nenner);
        if(addieren) {
            addition(ergebnis, feld2);
            addieren = FALSE;
        }
        else {
            subtraktion(ergebnis,feld2);
            addieren = TRUE;
        }
        nenner += 2;
    }

    addition(ergebnis,ergebnis); /* Mit 4          */
    addition(ergebnis,ergebnis); /* multiplizieren */

    for(i = 0;i < size;i++)
        feld1[i] = feld2[i] = 0;
    potenz = 239;
    feld1[size-1] = 1;
    nenner = 1;

    addieren = FALSE; /* Jetzt zuerst subtrahieren */
    nicht_fertig = TRUE;

    while(nicht_fertig) {
        division(feld1,potenz);
        copy(feld1, feld2);
        nicht_fertig = division(feld2,nenner);
        if(addieren) {
            addition(ergebnis,feld2);
            addieren = FALSE;
        }
        else {
            subtraktion(ergebnis,feld2);
            addieren = TRUE;
        }
        nenner += 2;
        division(feld1,potenz);
    }
    addition(ergebnis,ergebnis); /* mit 4          */
    addition(ergebnis,ergebnis); /* multiplizieren */

    konvertiere(ergebnis,pi_string);
    pi_out(pi_string);
}


int main(int argc,char *argv[])
{
    if (argc != 2 || (stellen = atoi(argv[1])) < 1)
    {
        fprintf(stderr,"Usage: picalc <digits>\n"
                       "       1 <= <digits>\n");
        exit(1);
    }

    groesse = (stellen + (MOD_DIGITS - 1)) / MOD_DIGITS +
              1 + SAFETY; /* 1 Vorkommazelle, 2 Sicherheitszellen */
    ergebnis = (FELD) malloc(groesse * sizeof(INT16));
    feld1 = (FELD) malloc(groesse * sizeof(INT16));
    feld2 = (FELD) malloc(groesse * sizeof(INT16));
    pi_string = (char *) malloc(stellen + 10);
    if (!ergebnis || !feld1 || !feld2 || !pi_string)
    {
        fprintf(stderr,"Insufficient memory!\n");
        exit(1);
    }

    pi();
    free(pi_string);
    free(ergebnis);
    free(feld1);
    free(feld2);

    return(0);
}


